/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation;

import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.UnclearVatRateException;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class VatType {
    public static final int VATTYPE_NOT_SET = 0;
    public static final int VATTYPE_EXEMPT = 100;
    public static final int VATTYPE_ZERO = 200;
    public static final int VATTYPE_REVERSE = 300;
    public static final int VATTYPE_HIGH = 400;
    public static final int VATTYPE_MEDIUM = 500;
    public static final int VATTYPE_LOW = 600;
    public static final int VATTYPE_EXPORT = 700;
    public static final int VAT_IDX_LOW = 0;
    public static final int VAT_IDX_MEDIUM = 1;
    public static final int VAT_IDX_HIGH = 2;
    public static final double DEFAULT_VAT_RATE = 0.25;
    public static final String vatVersionDateStr = "2018-10-10";
    public static final String vatSEcardChangeDateStr = "2018-10-01";
    public static Date vatSEcardChangeDate;
    public static final Map<String, Double[]> countryRates;

    static {
        try {
            vatSEcardChangeDate = JsonUtil.dfmt.parse(vatSEcardChangeDateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        countryRates = new TreeMap<String, Double[]>(){
            private static final long serialVersionUID = -3015234286159524187L;
            {
                this.put("SE", new Double[]{0.06, 0.12, 0.25});
                this.put("NO", new Double[]{0.12, 0.15, 0.25});
                this.put("DK", new Double[]{0.25, 0.25, 0.25});
                this.put("DE", new Double[]{0.07, 0.07, 0.19});
                this.put("FI", new Double[]{0.1, 0.14, 0.24});
            }
        };
    }

    public static Double[] getRates(String countryCode, Date rateDate) throws UnclearVatRateException {
        if (countryCode == null) {
            throw new UnclearVatRateException("No country code supplied");
        }
        Double[] rates = countryRates.get(countryCode);
        if (rates == null) {
            throw new UnclearVatRateException("VAT rates for " + countryCode + " are not defined.");
        }
        return rates;
    }

    public static double getVatRate(String countryCode, int vatType, Date rateDate) throws UnclearVatRateException {
        if (vatType == 0) {
            throw new UnclearVatRateException("Vat-type not set");
        }
        Double[] rates = VatType.getRates(countryCode, rateDate);
        switch (vatType) {
            case 100: 
            case 200: 
            case 700: {
                return 0.0;
            }
            case 600: {
                return rates[0];
            }
            case 500: {
                return rates[1];
            }
            case 400: {
                return rates[2];
            }
        }
        throw new UnclearVatRateException("Can't get rate for " + countryCode + " with vatType = " + vatType);
    }

    public static double getVatRate(String countryCode, String feeType, String accountType, Date rateDate, boolean isCompany) throws UnclearVatRateException {
        if (countryCode == null) {
            throw new UnclearVatRateException("No country code supplied for feeType: " + feeType + ", accountType: " + accountType);
        }
        if (feeType.equals("interest-income")) {
            return VatType.getVatRate(countryCode, 100, rateDate);
        }
        Double[] rates = VatType.getRates(countryCode, rateDate);
        if (feeType != null) {
            if ("SE".equalsIgnoreCase(countryCode)) {
                if (feeType.equals("collection")) {
                    return rates[2];
                }
                if (feeType.equals("reminder")) {
                    return rates[2];
                }
                if (feeType.equals("duedate")) {
                    return rates[2];
                }
                if (feeType.equals("cost")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("kickback")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("legal-action")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("adm")) {
                    if (accountType.equalsIgnoreCase("paymentplan") || accountType.equalsIgnoreCase("account-credit")) {
                        return VatType.getVatRate(countryCode, 100, rateDate);
                    }
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
                if (feeType.equals("credit")) {
                    if (accountType.equalsIgnoreCase("paymentplan")) {
                        return VatType.getVatRate(countryCode, 100, rateDate);
                    }
                    if (accountType.equalsIgnoreCase("creditcard") || accountType.equalsIgnoreCase("direct-bank")) {
                        if (rateDate == null || !rateDate.before(vatSEcardChangeDate)) {
                            return VatType.getVatRate(countryCode, 100, rateDate);
                        }
                        return VatType.getVatRate(countryCode, 400, rateDate);
                    }
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
                if (feeType.equals("postage") || feeType.equals("emailinvoice") || feeType.equals("subscription")) {
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
                if (feeType.equals("revenue-reminder")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
            } else if ("NO".equalsIgnoreCase(countryCode)) {
                if (feeType.equals("collection")) {
                    return rates[2];
                }
                if (feeType.equals("reminder")) {
                    return rates[2];
                }
                if (feeType.equals("duedate")) {
                    return rates[2];
                }
                if (feeType.equals("kickback")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("legal-action")) {
                    return rates[2];
                }
                if (feeType.equals("adm")) {
                    if (accountType.equalsIgnoreCase("paymentplan")) {
                        return VatType.getVatRate(countryCode, 100, rateDate);
                    }
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
                if (feeType.equals("credit")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("postage") || feeType.equals("emailinvoice") || feeType.equals("subscription")) {
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
            } else if ("FI".equalsIgnoreCase(countryCode)) {
                if (feeType.equals("collection")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("reminder")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("duedate")) {
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
                if (feeType.equals("kickback")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("legal-action")) {
                    return VatType.getVatRate(countryCode, 100, rateDate);
                }
                if (feeType.equals("adm")) {
                    if (accountType.equalsIgnoreCase("paymentplan")) {
                        return VatType.getVatRate(countryCode, 100, rateDate);
                    }
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
                if (feeType.equals("credit")) {
                    if (accountType.equalsIgnoreCase("creditcard")) {
                        return VatType.getVatRate(countryCode, 100, rateDate);
                    }
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
                if (feeType.equals("postage") || feeType.equals("emailinvoice") || feeType.equals("subscription")) {
                    return VatType.getVatRate(countryCode, 400, rateDate);
                }
            }
        }
        throw new UnclearVatRateException("VAT rates not defined for supplied parameters. Countrycode: " + countryCode + ", FeeType: " + feeType + ", AccountType: " + accountType + ", Company: " + isCompany);
    }
}

