/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation.conv;

import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.conv.ReconInputConverter;
import com.svea.webpay.common.reconciliation.conv.ReconToFlatFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;

public class ReconToFlatExcel
implements ReconInputConverter {
    private CellStyle dateCellStyle;
    private CellStyle headerCellStyle;
    private String dateFormatStr;
    public static final String defaultDateFormatStr = "yyyy-MM-dd";
    public static final String defaultFileName = "reconciliation-report";
    public static Integer[] colWidths;
    private int rowNum;
    private int colNum;
    private Row row;
    private Cell cell;
    private File outFile;
    private String outFilePrefix;

    static {
        Integer[] integerArray = new Integer[10];
        integerArray[0] = 3072;
        integerArray[1] = 4096;
        integerArray[3] = 3072;
        integerArray[6] = 10240;
        integerArray[7] = 7680;
        integerArray[9] = 5120;
        colWidths = integerArray;
    }

    public String getDateFormatStr() {
        return this.dateFormatStr;
    }

    public void setDateFormatStr(String dateFormatStr) {
        this.dateFormatStr = dateFormatStr;
    }

    public String getOutFilePrefix() {
        return this.outFilePrefix;
    }

    public void setOutFilePrefix(String outFilePrefix) {
        this.outFilePrefix = outFilePrefix;
        if (this.outFilePrefix != null && this.outFilePrefix.endsWith(".json")) {
            this.outFilePrefix = this.outFilePrefix.substring(0, outFilePrefix.length() - 5);
        }
    }

    public File getOutFile() {
        return this.outFile;
    }

    @Override
    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public void reset() {
        this.outFile = null;
    }

    public File createExcelFile(PaymentReport report) throws ParseException, EncryptedDocumentException, InvalidFormatException, IOException {
        String outFileName = null;
        if (this.outFile == null) {
            if (this.outFilePrefix != null && this.outFilePrefix.trim().length() > 0) {
                outFileName = this.outFilePrefix;
            } else {
                if (report.getTaxId() != null && report.getTaxId().trim().length() > 0) {
                    outFileName = report.getTaxId();
                }
                if (report.getOrgName() != null && report.getOrgName().trim().length() > 0) {
                    outFileName = outFileName != null && outFileName.trim().length() > 0 ? String.valueOf(outFileName) + "-" + report.getOrgName() : report.getOrgName();
                }
                if (outFileName == null || outFileName.trim().length() == 0) {
                    outFileName = defaultFileName;
                }
                if (report.getPaymentReportGroup() != null && report.getPaymentReportGroup().size() > 0) {
                    outFileName = String.valueOf(outFileName) + "-" + report.getPaymentReportGroup().get(0).getReconciliationDate();
                    outFileName = String.valueOf(outFileName) + "-" + report.getPaymentReportGroup().get(0).getCurrency();
                }
            }
            this.outFile = new File(outFileName);
        }
        if (!this.outFile.getAbsolutePath().toLowerCase().endsWith(".xlsx")) {
            this.outFile = new File(String.valueOf(this.outFile.getAbsolutePath()) + ".xlsx");
        }
        ReconToFlatFormat flatConverter = new ReconToFlatFormat();
        flatConverter.setCreateBalanceTrxForDebt(true);
        List<Object[]> rows = flatConverter.convertFromReconToRowObjects(report);
        SXSSFWorkbook wb = new SXSSFWorkbook(rows.size() + 1);
        if (this.dateFormatStr == null || this.dateFormatStr.trim().length() == 0) {
            this.dateFormatStr = defaultDateFormatStr;
        }
        CreationHelper createHelper = wb.getCreationHelper();
        this.dateCellStyle = wb.createCellStyle();
        this.dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(this.dateFormatStr));
        this.headerCellStyle = wb.createCellStyle();
        this.headerCellStyle.setWrapText(true);
        Font font = wb.createFont();
        font.setBold(true);
        this.headerCellStyle.setFont(font);
        SXSSFSheet sheet = wb.createSheet();
        this.rowNum = 0;
        if (rows.size() > 0) {
            this.createHeader((Sheet)sheet, rows.get(0));
            int i = 1;
            while (i < rows.size()) {
                this.createRow((Sheet)sheet, rows.get(i));
                ++i;
            }
        }
        XSSFFormulaEvaluator.evaluateAllFormulaCells((Workbook)wb);
        sheet.createFreezePane(0, 1);
        FileOutputStream out = new FileOutputStream(this.outFile);
        wb.write((OutputStream)out);
        out.close();
        wb.dispose();
        return this.outFile;
    }

    private void createRow(Sheet sh, Object[] srcRow) {
        this.colNum = 0;
        this.row = sh.createRow(this.rowNum++);
        int i = 0;
        while (i < srcRow.length) {
            Object srcColumn = srcRow[i];
            if (srcColumn instanceof String) {
                this.cell = this.row.createCell(this.colNum++);
                this.cell.setCellValue((String)srcColumn);
            } else if (srcColumn instanceof Date) {
                this.cell = this.row.createCell(this.colNum++);
                this.cell.setCellValue((Date)srcColumn);
                this.cell.setCellStyle(this.dateCellStyle);
            } else if (srcColumn instanceof Double || srcColumn instanceof Integer) {
                this.cell = this.row.createCell(this.colNum++);
                this.cell.setCellValue(((Double)srcColumn).doubleValue());
            } else {
                this.cell = this.row.createCell(this.colNum++);
                if (srcColumn != null) {
                    this.cell.setCellValue(srcColumn.toString());
                }
            }
            ++i;
        }
    }

    private void createHeader(Sheet sh, Object[] columnHeaders) {
        this.colNum = 0;
        this.row = sh.createRow(this.rowNum++);
        this.row.setHeightInPoints(40.0f);
        Object[] objectArray = columnHeaders;
        int n = columnHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            Object c = objectArray[n2];
            this.cell = this.row.createCell(this.colNum++);
            this.cell.setCellStyle(this.headerCellStyle);
            this.cell.setCellValue((String)c);
            if (colWidths.length > this.colNum - 1 && colWidths[this.colNum - 1] != null) {
                sh.setColumnWidth(this.colNum - 1, colWidths[this.colNum - 1].intValue());
            }
            ++n2;
        }
    }

    @Override
    public List<StringBuffer> convertFromRecon(PaymentReport report) throws Exception {
        ArrayList<StringBuffer> result = new ArrayList<StringBuffer>();
        File createdFile = this.createExcelFile(report);
        if (createdFile != null) {
            result.add(new StringBuffer(createdFile.getAbsolutePath()));
        }
        return result;
    }
}

