/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin;

import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpayadminservice.client.AdminService;
import com.svea.webpayadminservice.client.Authentication;
import com.svea.webpayadminservice.client.IAdminService;
import java.net.URL;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

public class WebpayAdminBase {
    protected boolean isTest = false;
    protected boolean isPaymentPlan = false;
    protected static final QName ADMIN_SERVICE_NAME = new QName("http://tempuri.org/", "AdminService");
    protected static final String testWSAdminAddress = "https://webpayadminservicestage.svea.com/AdminService.svc";
    protected URL wsdlAdminURL = AdminService.WSDL_LOCATION;
    protected AdminService adminService;
    protected IAdminService adminServicePort;
    protected Authentication auth;
    protected SveaCredential cre;
    protected String existingSpi = System.getProperty("javax.xml.ws.spi.Provider");
    protected String existingSoapFactory = System.getProperty("javax.xml.soap.SOAPFactory");

    public WebpayAdminBase() {
        URL url = ClassLoader.getSystemResource("logging.properties");
        if (url != null) {
            System.setProperty("java.util.logging.config.file", url.getFile());
        }
        this.adminService = new AdminService(this.wsdlAdminURL, ADMIN_SERVICE_NAME);
        this.adminServicePort = this.adminService.getAdminSoapService();
    }

    public void initCredentials(SveaCredential aCre) {
        this.cre = aCre;
        this.auth = new Authentication();
        this.auth.setUsername(this.cre.getUsername());
        this.auth.setPassword(this.cre.getPassword());
        if ("paymentplan".equalsIgnoreCase(this.cre.getAccountType())) {
            this.isPaymentPlan = true;
        }
    }

    public SveaCredential getCredentials() {
        return this.cre;
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    public void setAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    public IAdminService getAdminServicePort() {
        return this.adminServicePort;
    }

    public void setAdminServicePort(IAdminService adminServicePort) {
        this.adminServicePort = adminServicePort;
    }

    public IAdminService getServicePort() {
        return this.adminServicePort;
    }

    public void closeClient() {
        System.setProperty("javax.xml.ws.spi.Provider", this.existingSpi);
        System.setProperty("javax.xml.soap.SOAPFactory", this.existingSoapFactory);
    }

    public void setPartPayment(boolean flag) {
        this.isPaymentPlan = flag;
    }

    public boolean isPartPayment() {
        return this.isPaymentPlan;
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public void setAuth(Authentication auth) {
        this.auth = auth;
    }

    public String getEndpointAddress() {
        BindingProvider bp = (BindingProvider)this.getServicePort();
        Map map = bp.getRequestContext();
        Object endpointAddress = map.get("javax.xml.ws.service.endpoint.address");
        return endpointAddress.toString();
    }

    public boolean isTest() {
        return this.isTest;
    }

    public void setTest(boolean isTest) {
        this.isTest = isTest;
        if (isTest) {
            BindingProvider bp = (BindingProvider)this.getServicePort();
            bp.getRequestContext().put("javax.xml.ws.service.endpoint.address", testWSAdminAddress);
        }
    }
}

