/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin;

import com.svea.webpay.common.auth.ListOfSveaCredentials;
import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportFactory;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpay.common.reconciliation.conv.ReconInputConverter;
import com.svea.webpay.common.reconciliation.conv.ReconToBgMax;
import com.svea.webpay.common.reconciliation.conv.ReconToFlatExcel;
import com.svea.webpay.common.reconciliation.conv.ReconToFlatFormat;
import com.svea.webpay.common.reconciliation.conv.ReconToFlatJson;
import com.svea.webpayadmin.WebpayAdminClient;
import com.svea.webpayadmin.report.WebpayAdminReportFactory;
import com.svea.webpayadmin.report.WebpayCardReportFactory;
import com.svea.webpayadmin.report.WebpayCreditReportFactory;
import com.svea.webpayadmin.report.WebpayNoRiskReportFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebpayAdminClientMain {
    private Date fromDate = null;
    private Date untilDate = null;
    private File of = null;
    private File od = null;
    public static Logger log = LoggerFactory.getLogger(WebpayAdminClientMain.class);
    public static final String DEFAULT_TAXID = null;
    private List<PaymentReportFactory> clients;
    private List<SveaCredential> credentials;
    private String orgNo;
    private String orgName;

    private void loadConfig(String configfile) throws Exception {
        if (configfile.toLowerCase().endsWith(".json")) {
            this.credentials = SveaCredential.loadCredentialsFromJsonFile(configfile);
        } else if (configfile.toLowerCase().endsWith(".xml")) {
            this.credentials = SveaCredential.loadCredentialsFromXmlFile(configfile);
        }
        this.initClients();
    }

    private void loadJsonConfig(String configFile) throws Exception {
        ListOfSveaCredentials creds = (ListOfSveaCredentials)JsonUtil.gson.fromJson((Reader)new FileReader(configFile), ListOfSveaCredentials.class);
        if (creds != null && creds.getCredentials() != null && !creds.getCredentials().isEmpty()) {
            this.credentials = creds.getCredentials();
            this.initClients();
        } else {
            System.out.println("No credentials found i file: " + configFile);
            System.exit(1);
        }
    }

    private void createConfig(String user, String pass, boolean enrich, boolean kickback) throws Exception {
        WebpayAdminClient client = new WebpayAdminClient();
        ListOfSveaCredentials creds = client.getCredentialsByIdentity(user, pass);
        this.credentials = creds.getCredentials();
        if (enrich) {
            for (SveaCredential sc : this.credentials) {
                sc.setEnrichFromInvoice(true);
                sc.setIncludeKickbacks(kickback);
                sc.setSkipEmail(false);
                sc.setSkipTaxId(false);
            }
        }
        this.initClients();
    }

    private void createConfig(String accountNr, String user, String pass, String type, boolean enrich, boolean kickback) throws Exception {
        WebpayAdminClient client = new WebpayAdminClient();
        ListOfSveaCredentials creds = client.getCredentialsByIdentity(user, pass);
        this.credentials = new ArrayList<SveaCredential>();
        SveaCredential cred = null;
        if (creds.getCredentials() != null) {
            for (SveaCredential sc : creds.getCredentials()) {
                if (!sc.getAccountNo().equals(accountNr)) continue;
                cred = sc;
                break;
            }
        }
        if (cred == null) {
            new SveaCredential(accountNr, user, pass, type);
        }
        if ("invoice".equalsIgnoreCase(type)) {
            cred.setIncludeCardPayments(true);
        }
        cred.setEnrichFromInvoice(enrich);
        cred.setIncludeKickbacks(kickback);
        cred.setSkipEmail(false);
        cred.setSkipTaxId(false);
        cred.createDefaultAccountMap();
        this.credentials.add(cred);
        this.initClients();
    }

    public List<SveaCredential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(List<SveaCredential> credentials) {
        this.credentials = credentials;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getUntilDate() {
        return this.untilDate;
    }

    public void setUntilDate(Date untilDate) {
        this.untilDate = untilDate;
    }

    public void initClients() {
        this.clients = new ArrayList<PaymentReportFactory>();
        PaymentReportFactory client = null;
        for (SveaCredential cre : this.credentials) {
            if (this.orgNo != null && cre.getOrgNo() == null) {
                cre.setOrgNo(this.orgNo);
            }
            if (this.orgName != null && cre.getOrgName() != null) {
                cre.setOrgName(this.orgName);
            }
            client = null;
            if (cre.getAccountNo() != null && cre.getAccountNo().trim().length() > 0) {
                if ("invoice".equals(cre.getAccountType()) || "paymentplan".equals(cre.getAccountType())) {
                    client = new WebpayAdminReportFactory().init(cre);
                } else if ("creditcard".equals(cre.getAccountType())) {
                    client = new WebpayCardReportFactory().init(cre);
                } else if ("account-credit".equals(cre.getAccountType())) {
                    client = new WebpayCreditReportFactory().init(cre);
                } else if ("admin".equals(cre.getAccountType())) {
                    client = new WebpayNoRiskReportFactory().init(cre);
                }
            }
            if (client == null) continue;
            this.clients.add(client);
        }
    }

    public PaymentReport fillReport() {
        PaymentReport report = new PaymentReport();
        report.setTaxId(this.orgNo);
        report.setOrgName(this.orgName);
        List<PaymentReportGroup> groups = null;
        for (PaymentReportFactory c : this.clients) {
            try {
                log.debug("Reading for " + c.getSveaCredential().toString());
                groups = c.createBankStatementLines(report, this.fromDate, this.untilDate);
                if (groups == null) continue;
                if (c.getSveaCredential().isIgnoreFees()) {
                    for (PaymentReportGroup g : groups) {
                        g.clearFees();
                    }
                }
                if (!c.getSveaCredential().isEnrichFromInvoice()) continue;
                WebpayAdminClient enrichClient = new WebpayAdminClient();
                enrichClient.initCredentials(c.getSveaCredential());
                for (PaymentReportGroup group : groups) {
                    enrichClient.enrichFromInvoice(group.getPaymentTypeReference(), group.getPaymentReportDetail(), true, c.getSveaCredential().isSkipTaxId(), c.getSveaCredential().isSkipEmail());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return report;
    }

    public void runQuery(String format, boolean noPrune) {
        PaymentReport report = this.fillReport();
        if (!noPrune) {
            report.pruneReport();
        }
        if (this.od != null && this.of == null) {
            String filePrefix;
            if (report.getTaxId() == null) {
                report.setTaxId(DEFAULT_TAXID);
            }
            if ((filePrefix = report.getTaxId()) == null) {
                for (SveaCredential cr : this.credentials) {
                    if (cr.getUsername() == null || cr.getUsername().trim().length() <= 0) continue;
                    filePrefix = cr.getUsername();
                    break;
                }
            }
            if (filePrefix == null) {
                filePrefix = "ReconciliationReport";
            }
            this.of = new File(filePrefix + "-" + JsonUtil.dfmt.format(this.fromDate) + (this.fromDate.equals(this.untilDate) ? "" : "-" + JsonUtil.dfmt.format(this.untilDate)));
        }
        if (this.od != null && this.of != null) {
            this.of = new File(this.od.getAbsolutePath() + File.separator + this.of.getName());
        }
        ReconInputConverter converter = null;
        if (format == null || format.equals("json")) {
            String output = JsonUtil.PaymentReportToJson(report);
            PrintStream out = null;
            if (this.of != null) {
                if (!this.of.getAbsolutePath().toLowerCase().endsWith(".json")) {
                    this.of = new File(this.of.getAbsolutePath() + ".json");
                }
                try {
                    out = new PrintStream(this.of);
                }
                catch (FileNotFoundException fe) {
                    fe.printStackTrace(System.err);
                }
            } else {
                out = System.out;
            }
            out.println(output);
            if (out != System.out) {
                out.close();
                System.out.println(this.of.getAbsolutePath());
            }
        } else {
            if (format.equals("csv")) {
                converter = new ReconToFlatFormat();
            } else if (format.equals("xlsx")) {
                converter = new ReconToFlatExcel();
            } else if (format.equals("flat-json")) {
                converter = new ReconToFlatJson();
            } else if (format.equals("bgmax")) {
                converter = new ReconToBgMax();
            } else {
                System.err.print("Unknown format " + format);
                System.exit(1);
            }
            converter.setOutFile(this.of);
            try {
                List<StringBuffer> result = converter.convertFromRecon(report);
                for (StringBuffer s : result) {
                    System.out.println(s.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        WebpayAdminClientMain main = new WebpayAdminClientMain();
        Options options = new Options();
        options.addOption("u", "user", true, "User supplied by Svea Ekonomi to fetch reports. Can be specified in config-file.");
        options.addOption("p", "pass", true, "Password supplied by Svea Ekonomi to fetch reports. Can be specified in config-file.");
        options.addOption("a", "account", true, "Specify account when using user as argument. Not mandatory");
        options.addOption("t", "type", true, "Specify type of account. Mandatory when account is used.");
        options.addOption("k", "kickback", false, "Read kickbacks on this account (as well as normal transactions)");
        options.addOption("format", true, "Select other format than json. Available formats are 'xlsx', 'csv', 'flat-json' and 'bgmax'");
        options.addOption("enrich", false, "Enrich data with as much information as possible.");
        options.addOption("outfile", true, "Output to file instead of stdout");
        options.addOption("outdir", true, "Output to directory (and use outfile name if present)");
        options.addOption("d", "fromdate", true, "From date in format yyyy-MM-dd. If omitted, yesterday's date is used");
        options.addOption("untildate", true, "Until date in format yyyy-MM-dd");
        options.addOption("recipientorgnr", true, "Sets recipient org nr to this in output");
        options.addOption("recipientname", true, "Sets recipient name to this in output");
        options.addOption("c", "configfile", true, "Xml-configuration file where credentials are stored. Use a config file when detailed configuration is needed.");
        options.addOption("j", "jsonconfigfile", true, "Json-configuration file where credentials and settings are store. Use a config file when details configuration is needed.");
        options.addOption("noprune", false, "Return report type groups even if they are empty. Good to use to check what accounts are actually checked.");
        options.addOption("debug", true, "Enable debug");
        options.addOption("savejsonconfigfile", true, "Save credentials as json file");
        DefaultParser parser = new DefaultParser();
        HelpFormatter formatter = new HelpFormatter();
        String user = null;
        String pass = null;
        String accountNr = null;
        String type = null;
        String format = null;
        boolean enrich = false;
        boolean noprune = false;
        boolean kickback = false;
        String outfile = null;
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("c")) {
                main.loadConfig(cmd.getOptionValue("c"));
            }
            if (cmd.hasOption("j")) {
                main.loadJsonConfig(cmd.getOptionValue("j"));
            }
            if (cmd.hasOption("u")) {
                user = cmd.getOptionValue("u");
            }
            if (cmd.hasOption("k")) {
                kickback = true;
            }
            if (cmd.hasOption("enrich")) {
                enrich = true;
            }
            if (cmd.hasOption("noprune")) {
                noprune = true;
            }
            if (cmd.hasOption("p")) {
                pass = cmd.getOptionValue("p");
            }
            if (cmd.hasOption("a")) {
                accountNr = cmd.getOptionValue("a");
            }
            if (cmd.hasOption("t")) {
                type = cmd.getOptionValue("t");
            }
            if (!cmd.hasOption("c") && !cmd.hasOption("j")) {
                ArrayList<String> missingOpts = new ArrayList<String>();
                if (user == null) {
                    missingOpts.add("If config file is not specified, user must be specified");
                }
                if (pass == null) {
                    missingOpts.add("If config file is not specified, password must be specified");
                }
                if (accountNr != null && type == null) {
                    StringBuffer str = new StringBuffer();
                    str.append("If config file is not specified and account is specified, type must be specified.\n");
                    str.append("  Possible types are:\n");
                    str.append("  invoice\n");
                    str.append("  paymentplan\n");
                    str.append("  creditcard\n");
                    str.append("  loan\n");
                    str.append("  account-credit");
                    missingOpts.add(str.toString());
                }
                if (missingOpts.size() > 0) {
                    throw new MissingOptionException(missingOpts);
                }
                if (accountNr != null) {
                    main.createConfig(accountNr, user, pass, type, enrich, kickback);
                } else {
                    main.createConfig(user, pass, enrich, kickback);
                }
            }
            if (cmd.hasOption("d")) {
                main.fromDate = JsonUtil.dfmt.parse(cmd.getOptionValue("d"));
            }
            if (cmd.hasOption("format")) {
                format = cmd.getOptionValue("format");
                if (!((format = format.toLowerCase()).equals("xlsx") || format.equals("csv") || format.equals("flat-json") || format.equals("json") || format.equals("bgmax"))) {
                    throw new MissingOptionException("Available formats are: json, xlsx, csv, flat-json and bgmax. If format is omitted json is used.");
                }
            }
            if (cmd.hasOption("outfile")) {
                outfile = cmd.getOptionValue("outfile");
                main.of = new File(outfile);
            }
            if (cmd.hasOption("outdir")) {
                String outdir = cmd.getOptionValue("outdir");
                main.od = new File(outdir);
            }
            if (cmd.hasOption("untildate")) {
                main.untilDate = JsonUtil.dfmt.parse(cmd.getOptionValue("untildate"));
            }
            if (main.fromDate == null) {
                Calendar cal = Calendar.getInstance();
                cal.add(5, -1);
                main.fromDate = cal.getTime();
            }
            if (main.untilDate == null) {
                main.untilDate = main.fromDate;
            }
            if (cmd.hasOption("recipientorgnr")) {
                main.orgNo = cmd.getOptionValue("recipientorgnr");
            }
            if (cmd.hasOption("recipientname")) {
                main.orgName = cmd.getOptionValue("recipientname");
            }
            if (cmd.hasOption("savejsonconfigfile")) {
                SveaCredential.saveCredentialsAsJson(main.credentials, cmd.getOptionValue("savejsonconfigfile"));
            } else {
                main.runQuery(format, noprune);
            }
        }
        catch (MissingOptionException me) {
            System.out.println(me.getMessage());
            formatter.printHelp("WebpayAdminClientMain", options);
        }
        catch (UnrecognizedOptionException uo) {
            System.out.println(uo.getMessage());
            formatter.printHelp("WebpayAdminClientMain", options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

