/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin.report;

import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpay.common.reconciliation.VatType;
import com.svea.webpayadmin.WebpayAdminBase;
import com.svea.webpayadmin.WebpayAdminClient;
import com.svea.webpayadminservice.client.AccountingReportRow;
import com.svea.webpayadminservice.client.FinancialReportHeader;
import com.svea.webpayadminservice.client.FinancialReportRow;
import com.svea.webpayadminservice.client.GetAccountingReportRequest;
import com.svea.webpayadminservice.client.GetAccountingReportResponse2;
import com.svea.webpayadminservice.client.GetFinancialReportRequest;
import com.svea.webpayadminservice.client.GetFinancialReportResponse2;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class ReportFactoryBase {
    protected WebpayAdminBase svea;
    protected SveaCredential cre;

    public SveaCredential getSveaCredential() {
        return this.cre;
    }

    public List<AccountingReportRow> getAccountingReport(Timestamp date) throws Exception {
        GetAccountingReportRequest request = new GetAccountingReportRequest();
        if (this.cre.getAccountNo() != null) {
            request.setClientId(new Integer(this.cre.getAccountNo()).intValue());
        }
        request.setAuthentication(this.svea.getAuth());
        XMLGregorianCalendar acctDate = this.convert(date);
        request.setFromDate(acctDate);
        request.setToDate(acctDate);
        GetAccountingReportResponse2 response = this.svea.getServicePort().getAccountingReport(request);
        if (response == null) {
            throw new Exception("No response.");
        }
        if (response.getReportRows() != null) {
            return response.getReportRows().getAccountingReportRow();
        }
        throw new Exception(response.getErrorMessage());
    }

    public XMLGregorianCalendar convert(Timestamp date) throws DatatypeConfigurationException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(date.getTime());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
    }

    public GetFinancialReportResponse2 getFinancialReport(Timestamp date) throws DatatypeConfigurationException {
        GetFinancialReportRequest request = new GetFinancialReportRequest();
        request.setClientId(new Integer(this.cre.getAccountNo()).intValue());
        request.setAuthentication(this.svea.getAuth());
        XMLGregorianCalendar acctDate = this.convert(date);
        request.setFromDate(acctDate);
        request.setToDate(acctDate);
        GetFinancialReportResponse2 response = this.svea.getServicePort().getFinancialReport(request);
        FinancialReportHeader fh = response.getReportHeader();
        if (fh != null && fh.getAddress() != null) {
            this.cre.setCountryCode(fh.getAddress().getCountryCode());
        }
        return response;
    }

    public double getAmountOnBankFromSvea(Timestamp date) throws Exception {
        double result = 0.0;
        if (!this.svea.isPartPayment()) {
            List<AccountingReportRow> rows = this.getAccountingReport(date);
            for (AccountingReportRow r : rows) {
                if (r.getAccountNumber() != (long)Integer.parseInt(this.cre.getAccountMap().get("cash")) && r.getId() != FeeDetail.AccountingReportRowIdMap.get("cash").intValue()) continue;
                result = r.getDebit().subtract(r.getCredit()).doubleValue();
            }
        } else {
            List<FinancialReportRow> rows;
            GetFinancialReportResponse2 fr = this.getFinancialReport(date);
            List<FinancialReportRow> list = rows = fr.getReportRows() != null ? fr.getReportRows().getFinancialReportRow() : null;
            if (rows == null) {
                System.err.println("Could not read amount on bank for date " + date);
                return 0.0;
            }
            int sumRowId = 152;
            for (FinancialReportRow r : rows) {
                if (r.getRowId() != sumRowId) continue;
                result = r.getDebit().subtract(r.getCredit()).doubleValue();
            }
        }
        return result;
    }

    protected void fillDeviations(PaymentReportGroup gr, Timestamp date) throws Exception {
        GetFinancialReportResponse2 frr = this.getFinancialReport(date);
        FinancialReportHeader fh = frr.getReportHeader();
        List<FinancialReportRow> result = frr.getReportRows() != null ? frr.getReportRows().getFinancialReportRow() : null;
        PaymentReportDetail d = null;
        ArrayList<PaymentReportDetail> listToEnrich = new ArrayList<PaymentReportDetail>();
        boolean payoutFound = false;
        if (result == null) {
            return;
        }
        for (FinancialReportRow r : result) {
            if (r.getRowId() == 152 || r.getRowId() == 151 || r.getRowId() == 150 || r.getRowId() == 167) {
                gr.setTotalReceivedAmt(r.getDebit().subtract(r.getCredit()).doubleValue());
                payoutFound = true;
                continue;
            }
            if (r.getRowId() == 168 || r.getRowId() == 107) {
                if (fh.getClientTypeId() == 24 || fh.getClientTypeId() == 25) {
                    gr.setEndingBalance(r.getCredit().subtract(r.getDebit()).doubleValue());
                } else {
                    gr.setEndingBalance(r.getDebit().subtract(r.getCredit()).doubleValue());
                }
                gr.setTotalReceivedAmt(0.0);
                payoutFound = true;
                continue;
            }
            if (r.getRowId() == 106 || r.getRowId() == 163) {
                gr.setOpeningBalance(r.getCredit().subtract(r.getDebit()).doubleValue());
                continue;
            }
            if (r.getRowId() == 18 || r.getRowId() == 20 || r.getRowId() == 41 || r.getRowId() == 53 || r.getRowId() == 99 || r.getRowId() == 39) {
                FeeDetail ddf = new FeeDetail();
                ddf.setFee(r.getDebit().subtract(r.getCredit()).doubleValue());
                if (r.getRowId() == 53) {
                    ddf.setFeeType("duedate");
                } else if (r.getRowId() == 41) {
                    ddf.setFeeType("emailinvoice");
                } else if (r.getRowId() == 99) {
                    ddf.setFeeType("interest-income");
                } else if (r.getRowId() == 39) {
                    ddf.setFeeType("adm");
                } else if (r.getRowId() == 18) {
                    ddf.setFeeType("reminder");
                } else if (r.getRowId() == 20) {
                    ddf.setFeeType("subscription");
                }
                ddf.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), ddf.getFeeType(), this.cre.getAccountType(), date, this.cre.isCompany()));
                gr.addOtherFee(ddf);
            }
            if (r.getRowId() != 0 && r.getRowId() != 125 && r.getRowId() != 169) continue;
            d = null;
            d = PaymentReportDetail.parseDeviation(this.cre.getCountryCode(), this.cre.getAccountType(), gr.getReconciliationDateAsDate(), this.cre.isCompany(), r.getDescription(), r.getCredit().subtract(r.getDebit()).doubleValue(), r.getCount(), r.getRowId());
            if (d == null || d.getPaidAmt() == null) continue;
            gr.addDetail(d);
            if (r.getRowId() == 0) {
                FeeDetail deviation = new FeeDetail();
                deviation.setFee(-FeeDetail.getFeeSum(d.getFees()).doubleValue());
                deviation.setFeeVat(0.0);
                deviation.setFeeType("deviations");
                gr.addOtherFee(deviation);
            }
            if (d.getInvoiceId() == null && d.getOrderId() == null) continue;
            listToEnrich.add(d);
        }
        WebpayAdminClient enrichClient = new WebpayAdminClient();
        enrichClient.initCredentials(this.cre);
        if (this.cre.getAccountType().equalsIgnoreCase("invoice")) {
            enrichClient.enrichFromInvoice(gr.getPaymentTypeReference(), listToEnrich, false, this.cre.isSkipTaxId(), this.cre.isSkipEmail());
        } else if (this.cre.getAccountType().equalsIgnoreCase("paymentplan")) {
            enrichClient.enrichFromPaymentPlan(gr.getPaymentTypeReference(), listToEnrich, false, this.cre.isSkipTaxId());
        }
        if (!payoutFound) {
            gr.setTotalReceivedAmt(0.0);
        }
    }

    public List<FeeDetail> getOtherFeesFromAccountingSuggestion(PaymentReportGroup gr, Timestamp date) throws Exception {
        Map<String, FeeDetail> fees = this.getFeeSummaries(date);
        ArrayList<FeeDetail> otherFees = new ArrayList<FeeDetail>();
        for (FeeDetail f : fees.values()) {
            if ("0".equals(f.getAccountNr()) && f.getFee() == 0.0 || f.getAccountNr().equals(this.cre.getAccountMap().get("cash")) || f.getAccountNr().equals(this.cre.getAccountMap().get("receivables"))) continue;
            if (f.getAccountNr().equals(this.cre.getAccountMap().get("vat"))) {
                gr.setTotalVatAmt(gr.getTotalVatAmt() + f.getFee());
                continue;
            }
            if (f.getAccountNr().equals(this.cre.getAccountMap().get("deposit"))) {
                f.setFeeType("deposit");
                otherFees.add(f);
                continue;
            }
            if (f.getAccountNr().equals(this.cre.getAccountMap().get("postage"))) {
                f.setFeeType("postage");
                f.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), f.getFeeType(), this.cre.getAccountType(), date, this.cre.isCompany()));
                otherFees.add(f);
                continue;
            }
            if (f.getAccountNr().equals(this.cre.getAccountMap().get("revenue-reminder"))) {
                f.setFeeType("revenue-reminder");
                f.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), f.getFeeType(), this.cre.getAccountType(), date, this.cre.isCompany()));
                otherFees.add(f);
                continue;
            }
            if ("admin".equals(this.cre.getAccountType())) continue;
            if (f.getAccountNr().equals(this.cre.getAccountMap().get("adm"))) {
                f.setFeeType("adm");
                f.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), f.getFeeType(), this.cre.getAccountType(), date, this.cre.isCompany()));
                otherFees.add(f);
                continue;
            }
            if (!f.getAccountNr().equals(this.cre.getAccountMap().get("credit"))) continue;
            f.setFeeType("credit");
            f.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), f.getFeeType(), this.cre.getAccountType(), date, this.cre.isCompany()));
            otherFees.add(f);
        }
        return otherFees;
    }

    private Map<String, FeeDetail> getFeeSummaries(Timestamp date) throws Exception {
        TreeMap<String, FeeDetail> result = new TreeMap<String, FeeDetail>();
        List<AccountingReportRow> rows = this.getAccountingReport(date);
        for (AccountingReportRow r : rows) {
            if (r.getId() == FeeDetail.AccountingReportRowIdMap.get("cash").intValue()) {
                this.cre.addAccountMapping("cash", Long.toString(r.getAccountNumber()));
            }
            if (r.getId() == FeeDetail.AccountingReportRowIdMap.get("receivables").intValue()) {
                this.cre.addAccountMapping("receivables", Long.toString(r.getAccountNumber()));
            }
            if (r.getId() != FeeDetail.AccountingReportRowIdMap.get("vat").intValue()) continue;
            this.cre.addAccountMapping("vat", Long.toString(r.getAccountNumber()));
        }
        FeeDetail f = null;
        Map<String, String> reverseAccountMap = this.cre.getReverseAccountMap();
        for (AccountingReportRow r : rows) {
            if (r.getAccountNumber() == 0L) continue;
            f = (FeeDetail)result.get(Long.toString(r.getAccountNumber()));
            if (f == null) {
                f = new FeeDetail();
                f.setAccountNr(Long.toString(r.getAccountNumber()));
                f.setFee(0.0);
                result.put(f.getAccountNr(), f);
                String acctType = reverseAccountMap.get(f.getAccountNr());
                if (acctType != null) {
                    f.setFeeType(acctType);
                }
            }
            f.setFee(f.getFee() + r.getDebit().subtract(r.getCredit()).doubleValue());
        }
        return result;
    }
}

