/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin.report;

import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportFactory;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpay.common.reconciliation.VatType;
import com.svea.webpayadmin.WebpayAdminBase;
import com.svea.webpayadmin.report.ReportFactoryBase;
import com.svea.webpayadmin.report.WebpayCardReportFactory;
import com.svea.webpayadmin.report.WebpayKickbackReportFactory;
import com.svea.webpayadmin.report.WebpayNoRiskReportFactory;
import com.svea.webpayadminservice.client.ArrayOfInvoiceReportRow;
import com.svea.webpayadminservice.client.ArrayOfPaymentPlanReportRow;
import com.svea.webpayadminservice.client.ArrayOfRegressionReportRow;
import com.svea.webpayadminservice.client.GetInvoiceReportRequest;
import com.svea.webpayadminservice.client.GetInvoiceReportResponse2;
import com.svea.webpayadminservice.client.GetPaymentPlanReportRequest;
import com.svea.webpayadminservice.client.GetPaymentPlanReportResponse2;
import com.svea.webpayadminservice.client.GetRegressionReportRequest;
import com.svea.webpayadminservice.client.GetRegressionReportResponse2;
import com.svea.webpayadminservice.client.InvoiceReportRow;
import com.svea.webpayadminservice.client.PaymentPlanReportRow;
import com.svea.webpayadminservice.client.RegressionReportRow;
import com.svea.webpayadminservice.client.SpecificationReportType;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class WebpayAdminReportFactory
extends ReportFactoryBase
implements PaymentReportFactory {
    @Override
    public PaymentReportFactory init(SveaCredential aCre) {
        this.cre = aCre;
        this.svea = new WebpayAdminBase();
        this.svea.initCredentials(aCre);
        return this;
    }

    @Override
    public List<PaymentReportGroup> createBankStatementLines(PaymentReport report, Date fromDate, Date untilDate) throws Exception {
        ArrayList<PaymentReportGroup> resultList = new ArrayList<PaymentReportGroup>();
        Calendar fromCal = Calendar.getInstance();
        if (fromDate != null) {
            fromCal.setTime(fromDate);
        }
        Calendar untilCal = Calendar.getInstance();
        if (untilDate != null) {
            untilCal.setTime(untilDate);
        } else {
            untilCal.setTime(fromDate);
        }
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 0);
        fromCal.set(14, 0);
        untilCal.set(11, 0);
        untilCal.set(12, 0);
        untilCal.set(13, 0);
        untilCal.set(14, 0);
        Timestamp date = null;
        PaymentReportGroup gr = null;
        while (!fromCal.after(untilCal)) {
            double diffRounding;
            FeeDetail rounding;
            date = new Timestamp(fromCal.getTimeInMillis());
            fromCal.add(5, 1);
            gr = new PaymentReportGroup();
            String reconcileAcct = this.cre.getRemappedAccountFor("reconcile");
            if (reconcileAcct != null) {
                gr.setReconcileAcct(reconcileAcct);
            }
            gr.setReconciliationDate(new Date(date.getTime()));
            gr.setPaymentType(this.cre.getAccountType());
            gr.setPaymentTypeReference(this.cre.getAccountNo());
            gr.setVatAcct(this.cre.getRemappedAccountFor("vat"));
            gr.setCurrency(this.cre.getCurrency());
            if (!this.svea.isPartPayment()) {
                this.fillDeviations(gr, date);
                this.fillFromInvoiceReport(gr, date);
                this.fillNoRiskPayments(report, gr, date);
            } else {
                this.fillDeviations(gr, date);
                Double totalReceivedAmount = gr.getTotalReceivedAmt();
                Iterator<FeeDetail> deviationAmount = gr.calculateReceivedAmt();
                gr.setTotalReceivedAmt((Double)((Object)deviationAmount));
                this.fillFromPaymentPlan(report, gr, date);
                gr.setTotalReceivedAmt(totalReceivedAmount);
            }
            String dstAcct = this.cre.getRemappedAccountFor("cash");
            if (dstAcct != null) {
                gr.setDstAcct(dstAcct);
            }
            report.addPaymentReportGroup(gr);
            resultList.add(gr);
            if (gr.getTotalInvoiceFees() != null) {
                for (FeeDetail fd : gr.getTotalInvoiceFees()) {
                    FeeDetail.remapFeeAccount(this.cre, fd);
                }
            }
            if (gr.getTotalOtherFees() != null) {
                for (FeeDetail fd : gr.getTotalOtherFees()) {
                    FeeDetail.remapFeeAccount(this.cre, fd);
                }
            }
            List<PaymentReportGroup> cardGroups = null;
            if (this.cre.isIncludeCardPayments()) {
                cardGroups = this.fillCardPayments(report, gr, date);
                List<PaymentReportGroup> directGroups = null;
                directGroups = this.fillDirectPayments(report, gr, date);
                for (PaymentReportGroup prg : directGroups) {
                    cardGroups.add(prg);
                }
            }
            if ((rounding = gr.calculateRoundingFee(gr.getTotalReceivedAmt(), cardGroups)) != null && (diffRounding = rounding.getFeeTotal() - gr.getEndingBalance()) != 0.0) {
                rounding.setFee(diffRounding);
                rounding.setAccountNr(this.cre.getAccountMap().get(rounding.getFeeType()));
                gr.addOtherFee(rounding);
                gr.updateTotalFees();
            }
            gr.cancelOtherFees("credit", new String[]{"deviations", "rounding"});
            gr.replaceDeviationsAsRounding();
            gr.roundVatToGroupValue();
        }
        return resultList;
    }

    private void fillNoRiskPayments(PaymentReport report, PaymentReportGroup gr, Timestamp date) throws Exception {
        WebpayNoRiskReportFactory nrFactory = new WebpayNoRiskReportFactory();
        nrFactory.init(this.cre);
        List<PaymentReportGroup> groups = nrFactory.createBankStatementLines(report, date, date);
        if (groups != null) {
            for (PaymentReportGroup g : groups) {
                gr.setTotalReceivedAmt(gr.getTotalReceivedAmt() - g.getTotalReceivedAmt());
                gr.setTotalPaidAmt(gr.getTotalPaidAmt() - g.getTotalPaidAmt());
            }
        }
    }

    private List<PaymentReportGroup> fillCardPayments(PaymentReport report, PaymentReportGroup parentGroup, Timestamp date) throws Exception {
        WebpayCardReportFactory cardFactory = new WebpayCardReportFactory();
        cardFactory.init(this.cre);
        List<PaymentReportGroup> groups = cardFactory.createBankStatementLines(report, date, date);
        if (groups != null) {
            for (PaymentReportGroup g : groups) {
                if (g.isEmpty()) continue;
                g.setPaymentType("creditcard");
                if (this.cre.isIgnoreFees()) continue;
                FeeDetail cardFees = new FeeDetail();
                cardFees.setFeeType("credit");
                cardFees.setFee(FeeDetail.getFeeSum(g.getTotalInvoiceFees()) + FeeDetail.getFeeSum(g.getTotalOtherFees()));
                cardFees.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), cardFees.getFeeType(), this.cre.getAccountType(), date, this.cre.isCompany()));
                cardFees.setFee(-cardFees.getFee().doubleValue());
                cardFees.setFeeVat(-cardFees.getFeeVat().doubleValue());
                ArrayList<FeeDetail> otherFees = new ArrayList<FeeDetail>();
                otherFees.add(cardFees);
                parentGroup.combineTotalOtherFees(otherFees, new String[]{"credit"}, true);
                parentGroup.updateTotalFees();
            }
        }
        return groups;
    }

    private List<PaymentReportGroup> fillDirectPayments(PaymentReport report, PaymentReportGroup parentGroup, Timestamp date) throws Exception {
        WebpayCardReportFactory cardFactory = new WebpayCardReportFactory();
        cardFactory.init(this.cre);
        cardFactory.setSpecificationReportType(SpecificationReportType.BANK);
        List<PaymentReportGroup> groups = cardFactory.createBankStatementLines(report, date, date);
        if (groups != null) {
            for (PaymentReportGroup g : groups) {
                g.setPaymentType("direct-bank");
                if (this.cre.isIgnoreFees()) continue;
                FeeDetail cardFees = new FeeDetail();
                cardFees.setFeeType("credit");
                cardFees.setFee(FeeDetail.getFeeSum(g.getTotalInvoiceFees()) + FeeDetail.getFeeSum(g.getTotalOtherFees()));
                cardFees.setFeeVat(FeeDetail.getVatSum(g.getTotalInvoiceFees()) + FeeDetail.getVatSum(g.getTotalOtherFees()));
                cardFees.setFee(-cardFees.getFee().doubleValue());
                cardFees.setFeeVat(-cardFees.getFeeVat().doubleValue());
                ArrayList<FeeDetail> otherFees = new ArrayList<FeeDetail>();
                otherFees.add(cardFees);
                parentGroup.combineTotalOtherFees(otherFees, new String[]{"credit"}, true);
                parentGroup.updateTotalFees();
            }
        }
        return groups;
    }

    private void fillFromInvoiceReport(PaymentReportGroup gr, Timestamp date) throws Exception {
        FeeDetail fee;
        PaymentReportDetail d;
        double vatRateAdmFee = VatType.getVatRate(this.cre.getCountryCode(), "adm", gr.getPaymentType(), date, this.cre.isCompany());
        double vatRateCreditFee = VatType.getVatRate(this.cre.getCountryCode(), "credit", gr.getPaymentType(), date, this.cre.isCompany());
        List<InvoiceReportRow> invoices = this.getInvoiceReport(date);
        for (InvoiceReportRow invoice : invoices) {
            d = new PaymentReportDetail();
            d.setCustomerId(Long.toString(invoice.getCustomerId()));
            d.setInvoiceId(Long.toString(invoice.getInvoiceId()));
            d.setPayerName(invoice.getName());
            d.setPaidAmt(invoice.getAmount().doubleValue());
            d.setClientOrderNo(invoice.getClientOrderNumber());
            if (invoice.getCheckoutOrderId() != null && invoice.getCheckoutOrderId() > 0L) {
                d.setCheckoutOrderId(invoice.getCheckoutOrderId().toString());
            }
            if (invoice.getSveaOrderId() != null && invoice.getSveaOrderId() > 0L) {
                d.setOrderId(invoice.getSveaOrderId().toString());
            }
            if (invoice.getSveaOrderCreationDate() != null) {
                XMLGregorianCalendar odate = invoice.getSveaOrderCreationDate();
                d.setOrderDate(JsonUtil.dfmt.format(odate.toGregorianCalendar().getTime()));
            }
            if (invoice.getAdministrationFee().signum() != 0) {
                fee = new FeeDetail("adm", invoice.getAdministrationFee().doubleValue(), 0.0);
                FeeDetail.remapFeeAccount(this.cre, fee);
                fee.calculateVat(vatRateAdmFee);
                d.addFee(fee);
            }
            if (invoice.getCreditFee().signum() != 0) {
                fee = new FeeDetail("credit", invoice.getCreditFee().doubleValue(), 0.0);
                FeeDetail.remapFeeAccount(this.cre, fee);
                fee.calculateVat(vatRateCreditFee);
                d.addFee(fee);
            }
            d.calculateReceivedAmt();
            gr.addDetail(d);
        }
        List<RegressionReportRow> regressions = this.getRegressionReport(date);
        if (regressions != null && regressions.size() > 0) {
            double totalRegressions = 0.0;
            for (RegressionReportRow rr : regressions) {
                d = new PaymentReportDetail();
                d.setCustomerId(Long.toString(rr.getCustomerId()));
                d.setInvoiceId(Long.toString(rr.getInvoiceId()));
                d.setOrderId(rr.getClientOrderNumber());
                d.setPayerName(rr.getName());
                d.setPaidAmt(-rr.getTransactionAmount().doubleValue());
                if (rr.getCheckoutOrderId() != null && rr.getCheckoutOrderId() > 0L) {
                    d.setCheckoutOrderId(rr.getCheckoutOrderId().toString());
                }
                if (rr.getSveaOrderId() != null && rr.getSveaOrderId() > 0L) {
                    d.setOrderId(Long.toString(rr.getSveaOrderId()));
                }
                if (rr.getSveaOrderCreationDate() != null) {
                    XMLGregorianCalendar odate = rr.getSveaOrderCreationDate();
                    d.setOrderDate(JsonUtil.dfmt.format(odate.toGregorianCalendar().getTime()));
                }
                totalRegressions += rr.getTransactionAmount().doubleValue();
                if (rr.getFee().signum() != 0) {
                    fee = new FeeDetail("adm", rr.getFee().doubleValue(), 0.0);
                    fee.calculateVat(vatRateAdmFee);
                    FeeDetail.remapFeeAccount(this.cre, fee);
                    d.addFee(fee);
                }
                d.calculateReceivedAmt();
                gr.addDetail(d);
            }
            if (totalRegressions != 0.0) {
                PaymentReportDetail regressionDetail = gr.findDetailWithFeeAmount("deviations", -totalRegressions);
                if (regressionDetail != null) {
                    gr.removeDetail(regressionDetail);
                } else {
                    FeeDetail reverseRegressionAmtFee = new FeeDetail();
                    reverseRegressionAmtFee.setFee(-totalRegressions);
                    reverseRegressionAmtFee.setFeeVat(0.0);
                    reverseRegressionAmtFee.setFeeType("regress");
                    reverseRegressionAmtFee.setAccountNr(this.cre.getAccountMap().get("deviations"));
                    gr.addOtherFee(reverseRegressionAmtFee);
                }
            }
        }
        List<FeeDetail> otherFees = this.getOtherFeesFromAccountingSuggestion(gr, date);
        gr.updateTotalFees();
        gr.combineTotalOtherFees(otherFees, new String[]{"credit", "adm"}, true);
        double sveasBankTotal = this.getAmountOnBankFromSvea(date);
        if (sveasBankTotal != gr.getTotalReceivedAmt()) {
            gr.setTotalReceivedAmt(sveasBankTotal);
            double totalVat = gr.getTotalVatAmt();
            double invoiceVat = FeeDetail.getVatSum(gr.getTotalInvoiceFees());
            double otherVat = FeeDetail.getVatSum(gr.getTotalOtherFees());
            double diffVat = totalVat - invoiceVat - otherVat;
            diffVat = FeeDetail.roundFee(diffVat, 2);
            if (diffVat > 0.0) {
                FeeDetail add = new FeeDetail();
                add.setFee(0.0);
                add.setFeeVat(diffVat);
                FeeDetail.add(otherFees, add);
            }
        }
        FeeDetail.remapFeeAccounts(this.cre, gr.getTotalOtherFees());
        FeeDetail.remapFeeAccounts(this.cre, gr.getTotalInvoiceFees());
    }

    private void fillFromPaymentPlan(PaymentReport report, PaymentReportGroup gr, Timestamp date) throws Exception {
        FeeDetail fee;
        PaymentReportDetail d;
        List<PaymentPlanReportRow> invoices = this.getPaymentPlanReport(date);
        for (PaymentPlanReportRow paymentPlanReportRow : invoices) {
            d = new PaymentReportDetail();
            d.setCustomerId(Long.toString(paymentPlanReportRow.getCustomerId()));
            d.setInvoiceId(Long.toString(paymentPlanReportRow.getContractId()));
            d.setClientOrderNo(paymentPlanReportRow.getOrderId());
            d.setPayerName(paymentPlanReportRow.getName());
            d.setPaidAmt(paymentPlanReportRow.getAmount().doubleValue());
            if (paymentPlanReportRow.getCheckoutOrderId() != null && paymentPlanReportRow.getCheckoutOrderId() > 0L) {
                d.setCheckoutOrderId(paymentPlanReportRow.getCheckoutOrderId().toString());
            }
            if (paymentPlanReportRow.getSveaOrderId() != null && paymentPlanReportRow.getSveaOrderId() > 0L) {
                d.setOrderId(paymentPlanReportRow.getSveaOrderId().toString());
            }
            if (paymentPlanReportRow.getSveaOrderCreationDate() != null) {
                XMLGregorianCalendar odate = paymentPlanReportRow.getSveaOrderCreationDate();
                d.setOrderDate(JsonUtil.dfmt.format(odate.toGregorianCalendar().getTime()));
            }
            if (paymentPlanReportRow.getAdministrationFee().signum() != 0) {
                fee = new FeeDetail("adm", paymentPlanReportRow.getAdministrationFee().doubleValue(), 0.0);
                FeeDetail.remapFeeAccount(this.cre, fee);
                d.addFee(fee);
            }
            d.setReceivedAmt(paymentPlanReportRow.getPayToClientAmount().doubleValue());
            gr.addDetail(d);
        }
        List<RegressionReportRow> regressions = this.getRegressionReport(date);
        if (regressions != null && regressions.size() > 0) {
            for (RegressionReportRow rr : regressions) {
                d = new PaymentReportDetail();
                d.setCustomerId(Long.toString(rr.getCustomerId()));
                d.setInvoiceId(Long.toString(rr.getInvoiceId()));
                d.setClientOrderNo(rr.getClientOrderNumber());
                d.setPayerName(rr.getName());
                d.setPaidAmt(-rr.getTransactionAmount().doubleValue() + (rr.getFee() != null ? rr.getFee().doubleValue() : 0.0));
                if (rr.getCheckoutOrderId() != null && rr.getCheckoutOrderId() > 0L) {
                    d.setCheckoutOrderId(rr.getCheckoutOrderId().toString());
                }
                if (rr.getSveaOrderId() > 0L) {
                    d.setOrderId(Long.toString(rr.getSveaOrderId()));
                }
                if (rr.getSveaOrderCreationDate() != null) {
                    XMLGregorianCalendar odate = rr.getSveaOrderCreationDate();
                    d.setOrderDate(JsonUtil.dfmt.format(odate.toGregorianCalendar().getTime()));
                }
                if (rr.getFee().signum() != 0) {
                    fee = new FeeDetail("adm", rr.getFee().doubleValue(), 0.0);
                    fee.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), fee.getFeeType(), this.cre.getAccountType(), date, this.cre.isCompany()));
                    FeeDetail.remapFeeAccount(this.cre, fee);
                    d.addFee(fee);
                }
                d.calculateReceivedAmt();
                gr.addDetail(d);
            }
        }
        if (this.cre.isIncludeKickbacks()) {
            List<PaymentReportDetail> list = gr.getPaymentReportDetail();
            ArrayList<PaymentReportDetail> kickbackSums = new ArrayList<PaymentReportDetail>();
            if (list != null && list.size() > 0) {
                for (PaymentReportDetail detail : list) {
                    if (detail.getPaidAmt() != 0.0 || detail.getFees() == null || detail.getFees().size() != 1 || !"kickback".equals(detail.getFees().get(0).getFeeType())) continue;
                    kickbackSums.add(detail);
                }
                if (kickbackSums.size() > 0) {
                    List<PaymentReportGroup> kickbackGroups = null;
                    WebpayKickbackReportFactory wkr = new WebpayKickbackReportFactory();
                    wkr.init(this.cre);
                    kickbackGroups = wkr.createBankStatementLines(report, date, date);
                    ArrayList<PaymentReportGroup> groupsToAdd = new ArrayList<PaymentReportGroup>();
                    for (PaymentReportDetail kbs : kickbackSums) {
                        for (PaymentReportGroup kgs : kickbackGroups) {
                            if (kbs.getReceivedAmt().doubleValue() != kgs.getTotalReceivedAmt().doubleValue()) continue;
                            groupsToAdd.add(kgs);
                            gr.removeDetail(kbs);
                        }
                    }
                    for (PaymentReportGroup ggr : groupsToAdd) {
                        for (PaymentReportDetail dd : ggr.getPaymentReportDetail()) {
                            gr.addDetail(dd);
                        }
                    }
                }
            }
        }
    }

    public List<RegressionReportRow> getRegressionReport(Timestamp date) throws Exception {
        GetRegressionReportRequest request = new GetRegressionReportRequest();
        request.setClientId(new Integer(this.cre.getAccountNo()).intValue());
        request.setAuthentication(this.svea.getAuth());
        XMLGregorianCalendar xdate = this.convert(date);
        request.setFromDate(xdate);
        request.setToDate(xdate);
        GetRegressionReportResponse2 response = this.svea.getServicePort().getRegressionReport(request);
        ArrayOfRegressionReportRow res = response.getReportRows();
        return res != null ? res.getRegressionReportRow() : null;
    }

    public List<InvoiceReportRow> getInvoiceReport(Timestamp date) throws Exception {
        if (this.cre.getAccountNo() == null || this.cre.getAccountNo().trim().length() == 0) {
            return null;
        }
        GetInvoiceReportRequest request = new GetInvoiceReportRequest();
        request.setClientId(new Integer(this.cre.getAccountNo()).intValue());
        request.setAuthentication(this.svea.getAuth());
        XMLGregorianCalendar xdate = this.convert(date);
        request.setFromDate(xdate);
        request.setToDate(xdate);
        GetInvoiceReportResponse2 response = null;
        try {
            response = this.svea.getServicePort().getInvoiceReport(request);
        }
        catch (Exception e) {
            throw new Exception(this.svea.getEndpointAddress() + ": " + e.getMessage());
        }
        if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
            throw new Exception("Can't read invoice report for account " + this.cre.getAccountNo() + ": " + response.getErrorMessage());
        }
        ArrayOfInvoiceReportRow res = response.getReportRows();
        return res.getInvoiceReportRow();
    }

    public List<PaymentPlanReportRow> getPaymentPlanReport(Timestamp date) throws Exception {
        GetPaymentPlanReportRequest request = new GetPaymentPlanReportRequest();
        request.setClientId(new Integer(this.cre.getAccountNo()).intValue());
        request.setAuthentication(this.svea.getAuth());
        XMLGregorianCalendar xdate = this.convert(date);
        request.setFromDate(xdate);
        request.setToDate(xdate);
        GetPaymentPlanReportResponse2 response = this.svea.getServicePort().getPaymentPlanReport(request);
        ArrayOfPaymentPlanReportRow res = response.getReportRows();
        if (res == null) {
            return null;
        }
        return res.getPaymentPlanReportRow();
    }
}

