/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin.report;

import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportFactory;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpayadmin.WebpayAdminBase;
import com.svea.webpayadmin.report.ReportFactoryBase;
import com.svea.webpayadminservice.client.ArrayOfKickbackReportRow;
import com.svea.webpayadminservice.client.GetKickbackReportRequest;
import com.svea.webpayadminservice.client.GetKickbackReportResponse2;
import com.svea.webpayadminservice.client.KickbackReportRow;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class WebpayKickbackReportFactory
extends ReportFactoryBase
implements PaymentReportFactory {
    @Override
    public PaymentReportFactory init(SveaCredential aCre) {
        this.cre = aCre;
        this.svea = new WebpayAdminBase();
        this.svea.initCredentials(aCre);
        return this;
    }

    @Override
    public List<PaymentReportGroup> createBankStatementLines(PaymentReport report, Date fromDate, Date untilDate) throws Exception {
        ArrayList<PaymentReportGroup> resultList = new ArrayList<PaymentReportGroup>();
        Calendar fromCal = Calendar.getInstance();
        if (fromDate != null) {
            fromCal.setTime(fromDate);
        }
        Calendar untilCal = Calendar.getInstance();
        if (untilDate != null) {
            untilCal.setTime(untilDate);
        } else {
            untilCal.setTime(fromDate);
        }
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 0);
        fromCal.set(14, 0);
        untilCal.set(11, 0);
        untilCal.set(12, 0);
        untilCal.set(13, 0);
        untilCal.set(14, 0);
        Timestamp date = null;
        PaymentReportGroup gr = null;
        while (!fromCal.after(untilCal)) {
            String reconcileAcct;
            date = new Timestamp(fromCal.getTimeInMillis());
            fromCal.add(5, 1);
            gr = new PaymentReportGroup();
            String dstAcct = this.cre.getRemappedAccountFor("cash");
            if (dstAcct != null) {
                gr.setDstAcct(dstAcct);
            }
            if ((reconcileAcct = this.cre.getRemappedAccountFor("reconcile")) != null) {
                gr.setReconcileAcct(reconcileAcct);
            }
            gr.setReconciliationDate(new Date(date.getTime()));
            gr.setPaymentType("paymentplan");
            gr.setPaymentTypeReference(this.cre.getAccountNo());
            gr.setVatAcct(this.cre.getRemappedAccountFor("vat"));
            gr.setCurrency(this.cre.getCurrency());
            List<KickbackReportRow> kickbacks = this.getKickbackReport(date);
            if (kickbacks == null) {
                kickbacks = new ArrayList<KickbackReportRow>();
            }
            for (KickbackReportRow kickback : kickbacks) {
                PaymentReportDetail d = new PaymentReportDetail();
                d.setInvoiceId(kickback.getInvoiceId() != null ? kickback.getInvoiceId().toString() : null);
                d.setCustomerId(kickback.getCustomerId() != null ? kickback.getCustomerId().toString() : null);
                d.setPaidAmt(new Double(0.0));
                FeeDetail fee = new FeeDetail();
                fee.setFeeType("kickback");
                fee.setFee(kickback.getAmount().doubleValue());
                d.addFee(fee);
                d.calculateReceivedAmt();
                gr.addDetail(d);
            }
            resultList.add(gr);
        }
        return resultList;
    }

    public List<KickbackReportRow> getKickbackReport(Timestamp date) throws Exception {
        GetKickbackReportRequest request = new GetKickbackReportRequest();
        request.setClientId(new Long(this.cre.getAccountNo()));
        request.setAuthentication(this.svea.getAuth());
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, -1);
        XMLGregorianCalendar xdate = this.convert(new Timestamp(cal.getTimeInMillis()));
        request.setRunDate(xdate);
        GetKickbackReportResponse2 response = this.svea.getServicePort().getKickbackReport(request);
        if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
            throw new Exception("Can't read kickback report for account " + this.cre.getAccountNo() + ": " + response.getErrorMessage());
        }
        ArrayOfKickbackReportRow res = response.getKickbacks();
        return res != null ? res.getKickbackReportRow() : null;
    }
}

