/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin.report;

import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportFactory;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpayadmin.WebpayAdminBase;
import com.svea.webpayadmin.WebpayAdminClient;
import com.svea.webpayadmin.report.ReportFactoryBase;
import com.svea.webpayadminservice.client.ArrayOfInvoicePaidToClientRow;
import com.svea.webpayadminservice.client.GetDebtInvoicesPaidToClientForReportRequest;
import com.svea.webpayadminservice.client.GetDebtInvoicesPaidToClientForReportResponse2;
import com.svea.webpayadminservice.client.GetInvoicesPaidToClientForReportRequest;
import com.svea.webpayadminservice.client.GetInvoicesPaidToClientForReportResponse2;
import com.svea.webpayadminservice.client.InvoicePaidToClientRow;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class WebpayNoRiskReportFactory
extends ReportFactoryBase
implements PaymentReportFactory {
    @Override
    public PaymentReportFactory init(SveaCredential aCre) {
        this.cre = aCre;
        this.svea = new WebpayAdminBase();
        this.svea.initCredentials(aCre);
        return this;
    }

    @Override
    public List<PaymentReportGroup> createBankStatementLines(PaymentReport report, Date fromDate, Date untilDate) throws Exception {
        ArrayList<PaymentReportGroup> resultList = new ArrayList<PaymentReportGroup>();
        Calendar fromCal = Calendar.getInstance();
        if (fromDate != null) {
            fromCal.setTime(fromDate);
        }
        Calendar untilCal = Calendar.getInstance();
        if (untilDate != null) {
            untilCal.setTime(untilDate);
        } else {
            untilCal.setTime(fromDate);
        }
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 0);
        fromCal.set(14, 0);
        untilCal.set(11, 0);
        untilCal.set(12, 0);
        untilCal.set(13, 0);
        untilCal.set(14, 0);
        Timestamp date = null;
        PaymentReportGroup gr = null;
        while (!fromCal.after(untilCal)) {
            List<InvoicePaidToClientRow> collectionInvoices;
            List<InvoicePaidToClientRow> invoices;
            String reconcileAcct;
            date = new Timestamp(fromCal.getTimeInMillis());
            fromCal.add(5, 1);
            gr = new PaymentReportGroup();
            String dstAcct = this.cre.getRemappedAccountFor("cash");
            if (dstAcct != null) {
                gr.setDstAcct(dstAcct);
            }
            if ((reconcileAcct = this.cre.getRemappedAccountFor("reconcile")) != null) {
                gr.setReconcileAcct(reconcileAcct);
            }
            gr.setReconciliationDate(new Date(date.getTime()));
            gr.setPaymentType("admin");
            gr.setPaymentTypeReference(this.cre.getAccountNo());
            gr.setVatAcct(this.cre.getRemappedAccountFor("vat"));
            gr.setCurrency(this.cre.getCurrency());
            if ("admin".equals(this.cre.getAccountType())) {
                this.fillDeviations(gr, date);
            }
            if ((invoices = this.getInvoicesPaidToClient(date)) == null) {
                invoices = new ArrayList<InvoicePaidToClientRow>();
            }
            if ((collectionInvoices = this.getDebtInvoicesPaidToClient(date)) != null && collectionInvoices.size() > 0) {
                invoices.addAll(collectionInvoices);
            }
            for (InvoicePaidToClientRow invoice : invoices) {
                PaymentReportDetail d = new PaymentReportDetail();
                if (invoice.getCheckoutOrderId() != null && invoice.getCheckoutOrderId() != 0L) {
                    d.setCheckoutOrderId(invoice.getCheckoutOrderId().toString());
                }
                d.setInvoiceId(invoice.getInvoiceId() != null ? invoice.getInvoiceId().toString() : null);
                d.setOrderId(invoice.getSveaOrderId() != null ? invoice.getSveaOrderId().toString() : null);
                if (invoice.getSveaOrderCreationDate() != null) {
                    d.setOrderDate(JsonUtil.dfmt.format(invoice.getSveaOrderCreationDate().toGregorianCalendar().getTime()));
                }
                d.setPaidAmt(invoice.getAmount().doubleValue());
                d.setEnrichFromInvoice(true);
                d.calculateReceivedAmt();
                gr.addDetail(d);
            }
            List<FeeDetail> otherFees = null;
            if ("admin".equals(this.cre.getAccountType())) {
                otherFees = this.getOtherFeesFromAccountingSuggestion(gr, date);
            }
            gr.updateTotalFees();
            if (otherFees != null && otherFees.size() > 0) {
                gr.combineTotalOtherFees(otherFees, new String[]{"credit", "adm"}, true);
                gr.updateTotalFees();
            }
            gr.setTotalVatAmt(FeeDetail.getVatSum(gr.getTotalInvoiceFees()));
            if ("admin".equals(this.cre.getAccountType())) {
                double sveasBankTotal = this.getAmountOnBankFromSvea(date);
                if (sveasBankTotal != gr.calculateReceivedAmt()) {
                    gr.setTotalReceivedAmt(sveasBankTotal);
                    FeeDetail rounding = gr.calculateRoundingFee(gr.getTotalReceivedAmt(), null);
                    if (rounding != null) {
                        rounding.setAccountNr(this.cre.getAccountMap().get(rounding.getFeeType()));
                        gr.addOtherFee(rounding);
                        gr.updateTotalFees();
                    }
                }
                gr.cancelOtherFees("credit", new String[]{"deviations", "rounding"});
                gr.replaceDeviationsAsRounding();
            }
            FeeDetail.remapFeeAccounts(this.cre, gr.getTotalOtherFees());
            FeeDetail.remapFeeAccounts(this.cre, gr.getTotalInvoiceFees());
            report.addPaymentReportGroup(gr);
            resultList.add(gr);
        }
        if (gr.getPaymentReportDetail() != null) {
            WebpayAdminClient enrichClient = new WebpayAdminClient();
            enrichClient.initCredentials(this.cre);
            enrichClient.enrichFromInvoice(gr.getPaymentTypeReference(), gr.getPaymentReportDetail(), false, this.cre.isSkipTaxId(), this.cre.isSkipEmail());
        }
        return resultList;
    }

    public List<InvoicePaidToClientRow> getInvoicesPaidToClient(Timestamp date) throws Exception {
        GetInvoicesPaidToClientForReportRequest request = new GetInvoicesPaidToClientForReportRequest();
        request.setClientId(new Long(this.cre.getAccountNo()));
        request.setAuthentication(this.svea.getAuth());
        XMLGregorianCalendar xdate = this.convert(date);
        request.setFromDate(xdate);
        request.setToDate(xdate);
        GetInvoicesPaidToClientForReportResponse2 response = this.svea.getServicePort().getInvoicesPaidToClientForReport(request);
        if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
            throw new Exception("Can't read admin invoice report for account " + this.cre.getAccountNo() + ": " + response.getErrorMessage());
        }
        ArrayOfInvoicePaidToClientRow res = response.getInvoices();
        return res != null ? res.getInvoicePaidToClientRow() : null;
    }

    public List<InvoicePaidToClientRow> getDebtInvoicesPaidToClient(Timestamp date) throws Exception {
        GetDebtInvoicesPaidToClientForReportRequest request = new GetDebtInvoicesPaidToClientForReportRequest();
        request.setClientId(new Long(this.cre.getAccountNo()));
        request.setAuthentication(this.svea.getAuth());
        XMLGregorianCalendar xdate = this.convert(date);
        request.setFromDate(xdate);
        request.setToDate(xdate);
        GetDebtInvoicesPaidToClientForReportResponse2 response = this.svea.getServicePort().getDebtInvoicesPaidToClientForReport(request);
        if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
            throw new Exception("Can't read debt invoice report for account " + this.cre.getAccountNo() + ": " + response.getErrorMessage());
        }
        ArrayOfInvoicePaidToClientRow res = response.getInvoices();
        return res != null ? res.getInvoicePaidToClientRow() : null;
    }
}

