/*
 * Decompiled with CFR 0.152.
 */
package com.svea.businessobjects;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.Location;
import org.notima.generic.businessobjects.Person;

public class SveaUtility {
    public static final int ROUNDING_DECIMALS = 3;

    public static String getCountryCode(Location location) {
        String countryCode = location.getCountryCode();
        if ("FI".equals(countryCode) || "AX".equals(countryCode) || "AA".equals(countryCode)) {
            return "FI";
        }
        return countryCode;
    }

    public static String toDigitsOnly(String cleanUp) {
        if (cleanUp == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cleanUp.length(); ++i) {
            char c = cleanUp.charAt(i);
            if (c < '0' || c > '9') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static XMLGregorianCalendar getXMLDate(Date d) throws DatatypeConfigurationException {
        GregorianCalendar cal = new GregorianCalendar();
        XMLGregorianCalendar date2 = null;
        if (d != null) {
            cal.setTime(d);
            date2 = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        return date2;
    }

    public static Map<String, String> setFromLocation(BusinessPartner<?> customer, Person user, Location location) throws Exception {
        String countryCode = location.getCountryCode();
        boolean isCompany = false;
        if (countryCode == null) {
            countryCode = "se";
        }
        String countryStr = countryCode.toLowerCase();
        StringBuffer street = new StringBuffer();
        if (location.getAddress1() != null && location.getAddress1().trim().length() > 0) {
            street.append(location.getAddress1());
        }
        if (location.getAddress2() != null && location.getAddress2().trim().length() > 0) {
            if (street.length() > 0) {
                street.append("\n");
            }
            street.append(location.getAddress2());
        }
        if (location.getAddress3() != null && location.getAddress3().trim().length() > 0) {
            if (street.length() > 0) {
                street.append("\n");
            }
            street.append(location.getAddress3());
        }
        if (location.getAddress4() != null && location.getAddress4().trim().length() > 0) {
            if (street.length() > 0) {
                street.append("\n");
            }
            street.append(location.getAddress4());
        }
        String fname = null;
        String lname = null;
        if (!customer.isCompany()) {
            int firstSpace;
            fname = user.getFirstName();
            lname = user.getLastName();
            if ((fname == null || fname.trim().length() == 0 || lname == null || lname.trim().length() == 0) && (firstSpace = (fname = customer.getName()).lastIndexOf(" ")) > 0 && firstSpace < fname.length() - 1) {
                lname = fname.substring(firstSpace + 1);
                fname = fname.substring(0, firstSpace);
            }
        } else {
            isCompany = true;
            fname = customer.getName();
            lname = "";
        }
        Map<String, String> adr = SveaUtility.mk_address(fname, lname, street.toString(), location.getPostal(), location.getCity(), countryStr, isCompany);
        return adr;
    }

    public static Map<String, String> mk_address(String fname, String lname, String street, String postno, String city, String country, boolean isCompany) {
        Hashtable<String, String> address = new Hashtable<String, String>();
        address.put("fname", fname);
        address.put("lname", lname);
        address.put("street", street);
        address.put("zip", postno);
        address.put("city", city);
        address.put("country", country);
        if (isCompany) {
            address.put("isCompany", "true");
        }
        return address;
    }
}

