/*
 * Decompiled with CFR 0.152.
 */
package com.svea.businessobjects.sveaadmin;

import com.svea.businessobjects.SveaUtility;
import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpayadminservice.client.Address;
import com.svea.webpayadminservice.client.ArrayOfNumberedOrderRow;
import com.svea.webpayadminservice.client.ArrayOfOrderRow;
import com.svea.webpayadminservice.client.CompanyIdentity;
import com.svea.webpayadminservice.client.CreateOrderInformation;
import com.svea.webpayadminservice.client.CreateOrderRequest;
import com.svea.webpayadminservice.client.CreatePaymentPlanDetails;
import com.svea.webpayadminservice.client.CustomerIdentity;
import com.svea.webpayadminservice.client.CustomerType;
import com.svea.webpayadminservice.client.IndividualIdentity;
import com.svea.webpayadminservice.client.NumberedOrderRow;
import com.svea.webpayadminservice.client.Order;
import com.svea.webpayadminservice.client.OrderDeliveryStatus;
import com.svea.webpayadminservice.client.OrderRow;
import com.svea.webpayadminservice.client.OrderType;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.KeyValue;
import org.notima.generic.businessobjects.Location;
import org.notima.generic.businessobjects.OrderLine;
import org.notima.generic.businessobjects.Payment;
import org.notima.generic.businessobjects.PaymentWriteOff;
import org.notima.generic.businessobjects.PaymentWriteOffs;
import org.notima.generic.businessobjects.Person;
import org.notima.generic.ifacebusinessobjects.OrderInvoiceLine;

public class SveaAdminConverter {
    public static CreateOrderRequest convert(org.notima.generic.businessobjects.Order<CreateOrderRequest> src, OrderType ot, CreatePaymentPlanDetails cpp) throws Exception {
        CreateOrderRequest req = new CreateOrderRequest();
        CreateOrderInformation dst = new CreateOrderInformation();
        req.setOrderInformation(dst);
        BusinessPartner bp = src.getBillBpartner();
        if (bp != null) {
            if (bp.getAddressOfficial() == null) {
                bp.setAddressOfficial(src.getBillLocation());
            }
            if (bp.getAddressShipping() == null) {
                bp.setAddressShipping(src.getShipLocation());
            }
        }
        Person p = src.getBillPerson();
        ArrayList<Person> contacts = bp.getContacts();
        if (p != null) {
            if (contacts == null || contacts.size() == 0) {
                if (contacts == null) {
                    contacts = new ArrayList<Person>();
                    bp.setContacts(contacts);
                }
                contacts.add(p);
            } else if (contacts.get(0) != p) {
                contacts.add(0, p);
            }
        } else {
            if (contacts == null || contacts.size() == 0) {
                throw new Exception("Business Partner must have a contact to convert to CustomerIdentity");
            }
            p = (Person)contacts.get(0);
        }
        dst.setClientOrderNumber(src.getDocumentKey());
        dst.setCustomerIdentity(SveaAdminConverter.convert(src.getBillBpartner()));
        dst.setOrderDeliveryAddress(SveaAdminConverter.convert(src.getShipLocation(), p));
        dst.setOrderDate(SveaUtility.getXMLDate(src.getDateOrdered()));
        dst.setCustomerReference(p.getName());
        ArrayOfOrderRow rows = new ArrayOfOrderRow();
        List<OrderRow> rl = rows.getOrderRow();
        for (OrderInvoiceLine ol : src.getOrderInvoiceLines()) {
            rl.add(SveaAdminConverter.convert(ol));
        }
        dst.setOrderRows(rows);
        dst.setOrderType(ot);
        if (cpp != null) {
            dst.setCreatePaymentPlanDetails(cpp);
        }
        return req;
    }

    public static org.notima.generic.businessobjects.Order<Order> convert(Order src) throws Exception {
        if (src == null) {
            return null;
        }
        org.notima.generic.businessobjects.Order dst = new org.notima.generic.businessobjects.Order();
        dst.setDocumentKey(src.getClientOrderId());
        dst.setCurrency(src.getCurrency());
        dst.setSalesOrder(true);
        dst.setDocumentDate(src.getCreatedDate().toGregorianCalendar().getTime());
        BusinessPartner<CustomerIdentity> bp = SveaAdminConverter.convert(src.getCustomer());
        dst.setBpartner(bp);
        if (!src.getOrderType().equals(OrderType.PAYMENT_PLAN.value())) {
            bp.setIdentityNo(Long.toString(src.getCustomerId()));
        }
        ArrayOfNumberedOrderRow orderArray = src.getOrderRows();
        List<NumberedOrderRow> rows = orderArray.getNumberedOrderRow();
        for (NumberedOrderRow r : rows) {
            if (OrderDeliveryStatus.CANCELLED.value().equals(r.getStatus())) continue;
            dst.addOrderLine(SveaAdminConverter.convert(r));
        }
        dst.calculateGrandTotal();
        dst.setNativeOrder((Object)src);
        return dst;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OrderLine convert(NumberedOrderRow src) throws Exception {
        OrderLine dst = new OrderLine();
        dst.setProductKey(src.getArticleNumber());
        dst.setName(src.getDescription());
        dst.setKey(src.getArticleNumber());
        dst.setQtyEntered(src.getNumberOfUnits().doubleValue());
        dst.setUOM(src.getUnit());
        dst.setPricesIncludeVAT(src.isPriceIncludingVat().booleanValue());
        dst.setPriceActual(Double.valueOf(src.getPricePerUnit().doubleValue()));
        dst.setTaxPercent(src.getVatPercent().doubleValue());
        if (src.getDiscountAmount().signum() != 0) {
            if (src.isDiscountAmountIncludingVat().booleanValue()) {
                if (!src.isPriceIncludingVat().booleanValue()) throw new Exception("Discount includes VAT but price is excluding VAT");
                dst.setPriceNormal(Double.valueOf(dst.getPriceNormal() + src.getDiscountAmount().doubleValue()));
            } else {
                if (src.isPriceIncludingVat().booleanValue()) throw new Exception("Price includes VAT but discount is excluding VAT");
                dst.setPriceNormal(Double.valueOf(dst.getPriceNormal() + src.getDiscountAmount().doubleValue()));
            }
        } else {
            dst.setPriceNormal(dst.getPriceActual());
        }
        dst.setLineNo((int)src.getRowNumber());
        dst.calculateLineTotalIncTax(2);
        return dst;
    }

    public static OrderRow convert(OrderInvoiceLine src) {
        OrderRow dst = new OrderRow();
        dst.setArticleNumber(src.getProductKey());
        String description = src.getName();
        if (description != null && description.trim().length() > 0 && src.getDescription() != null) {
            description = description + " " + src.getDescription();
        }
        dst.setDescription(description);
        dst.setNumberOfUnits(BigDecimal.valueOf(src.getQtyEntered()));
        dst.setUnit(src.getUOM());
        dst.setPricePerUnit(BigDecimal.valueOf(src.getPriceNormal()));
        dst.setVatPercent(BigDecimal.valueOf(src.getTaxPercent()));
        if (src.getPriceNormal() != src.getPriceActual()) {
            dst.setDiscountAmount(BigDecimal.valueOf(src.getPriceNormal() - src.getPriceActual()));
            dst.setDiscountAmountIncludingVat(src.isPricesIncludeVAT());
        }
        dst.setPriceIncludingVat(src.isPricesIncludeVAT());
        dst.setTemporaryReference(Integer.toString(src.getLineNo()));
        return dst;
    }

    public static Address convert(Location src, Person p) {
        Address dst = new Address();
        dst.setCoAddress(src.getCo());
        if (src.getStreet() != null) {
            dst.setStreet(src.getStreet());
        } else {
            dst.setStreet(src.getAddress1());
        }
        dst.setHouseNumber(src.getHouseNo());
        dst.setZipCode(src.getPostal());
        dst.setLocality(src.getCity());
        dst.setCountryCode(src.getCountryCode());
        if (p != null) {
            dst.setFirstName(p.getFirstName());
            dst.setLastName(p.getLastName());
            dst.setFullName(p.getName());
        }
        return dst;
    }

    public static BusinessPartner<CustomerIdentity> convert(CustomerIdentity src) throws Exception {
        BusinessPartner dst = new BusinessPartner();
        dst.setCompany(CustomerType.COMPANY.equals((Object)src.getCustomerType()));
        dst.setIdentityNo(src.getNationalIdNumber());
        dst.setTaxId(src.getNationalIdNumber());
        if (dst.isCompany() && dst.getTaxId() != null && dst.getTaxId().startsWith("16")) {
            dst.setTaxId(dst.getTaxId().substring(2));
        }
        dst.setName(src.getFullName());
        dst.setIsCustomer(Boolean.valueOf(true));
        Location address = new Location();
        address.setCo(src.getCoAddress());
        address.setStreet(src.getStreet());
        address.setHouseNo(src.getHouseNumber());
        address.setPostal(src.getZipCode());
        address.setCity(src.getLocality());
        address.setEmail(src.getEmail());
        address.setPhone(src.getPhoneNumber());
        dst.setAddressOfficial(address);
        return dst;
    }

    public static CustomerIdentity convert(BusinessPartner<?> bp) throws Exception {
        CustomerIdentity dst = new CustomerIdentity();
        dst.setNationalIdNumber(bp.getTaxId());
        List contacts = bp.getContacts();
        if (contacts == null || contacts.size() < 1) {
            throw new Exception("Business Partner must have a contact to convert to CustomerIdentity");
        }
        Person contact = (Person)contacts.get(0);
        dst.setEmail(contact.getEmail());
        dst.setPhoneNumber(contact.getPhone());
        dst.setFullName(bp.getName());
        Location address = bp.getAddressOfficial();
        if (address != null) {
            dst.setCoAddress(address.getCo());
            if (address.getStreet() != null) {
                dst.setStreet(address.getStreet());
            } else {
                dst.setStreet(address.getAddress1());
            }
            dst.setHouseNumber(address.getHouseNo());
            dst.setZipCode(address.getPostal());
            dst.setLocality(address.getCity());
            dst.setCountryCode(address.getCountryCode());
        }
        if (bp.isCompany()) {
            CompanyIdentity ci = new CompanyIdentity();
            ci.setCompanyIdentification(bp.getTaxId());
            ci.setCompanyVatNumber(bp.getVatNo());
            dst.setCompanyIdentity(ci);
            dst.setCustomerType(CustomerType.COMPANY);
            if (dst.getCoAddress() == null || dst.getCoAddress().trim().length() == 0) {
                dst.setCoAddress(contact.getName());
            }
        } else {
            IndividualIdentity ii = new IndividualIdentity();
            ii.setFirstName(contact.getFirstName());
            ii.setLastName(contact.getLastName());
            if (contact.getAttributes() != null) {
                for (KeyValue kv : contact.getAttributes()) {
                    if (!"birthDate".equalsIgnoreCase(kv.getKey())) continue;
                    ii.setBirthDate(kv.getValue());
                }
            }
            dst.setIndividualIdentity(ii);
            dst.setCustomerType(CustomerType.INDIVIDUAL);
        }
        return dst;
    }

    public List<Payment<PaymentReportDetail>> convert(PaymentReportGroup group, boolean retriesOnly, boolean includeFees) throws ParseException {
        ArrayList<Payment<PaymentReportDetail>> dstList = new ArrayList<Payment<PaymentReportDetail>>();
        if (group == null || group.getPaymentReportDetail() == null) {
            return dstList;
        }
        for (PaymentReportDetail d : group.getPaymentReportDetail()) {
            if (d == null || (!retriesOnly || d.getRetry() == null || !d.getRetry().booleanValue()) && retriesOnly) continue;
            Payment p = this.convert(d, group, includeFees);
            p.setNativePayment((Object)d);
            dstList.add((Payment<PaymentReportDetail>)p);
        }
        return dstList;
    }

    public Payment convert(PaymentReportDetail src, PaymentReportGroup group, boolean includeFees) throws ParseException {
        Payment dst = new Payment();
        dst.setPaymentDate(JsonUtil.dfmt.parse(group.getReconciliationDate()));
        dst.setCurrency(group.getCurrency());
        dst.setAccountNo(group.getDstAcct());
        dst.setAmount(includeFees ? src.getReceivedAmt() : src.getPaidAmt());
        dst.setBusinessPartnerKey(src.getCustomerId());
        dst.setInvoiceNo(src.getInvoiceId());
        BusinessPartner bp = new BusinessPartner();
        dst.setBusinessPartner(bp);
        bp.setName(src.getPayerName());
        bp.setIdentityNo(src.getPayerOrgNo());
        dst.setOrderNo(src.getOrderId() != null && src.getOrderId().trim().length() > 0 ? src.getOrderId() : src.getPaymentId());
        dst.setClientOrderNo(src.getClientOrderNo());
        if (dst.getInvoiceNo() == null && dst.getOrderNo() == null && src.getClientOrderNo() != null) {
            dst.setInvoiceNo(src.getClientOrderNo());
        }
        if (includeFees && src.getPaidAmt() != src.getReceivedAmt()) {
            PaymentWriteOff pw;
            double vatOnPaymentFee = 0.0;
            if (src.getFees() != null) {
                for (FeeDetail fd : src.getFees()) {
                    if (dst.getPaymentWriteOffs() == null) {
                        dst.setPaymentWriteOffs(new PaymentWriteOffs());
                        ArrayList list = new ArrayList();
                        dst.getPaymentWriteOffs().setPaymentWriteOff(list);
                    }
                    pw = new PaymentWriteOff();
                    pw.setAccountNo(fd.getAccountNr());
                    pw.setAmount(fd.getFee());
                    dst.getPaymentWriteOffs().getPaymentWriteOff().add(pw);
                    if (fd.getFeeVat() == null || fd.getFeeVat() == 0.0) continue;
                    vatOnPaymentFee += fd.getFeeVat().doubleValue();
                }
            }
            if (vatOnPaymentFee != 0.0) {
                pw = new PaymentWriteOff();
                pw.setAccountNo(group.getVatAcct());
                pw.setAmount(Double.valueOf(vatOnPaymentFee));
                dst.getPaymentWriteOffs().getPaymentWriteOff().add(pw);
            }
        }
        return dst;
    }
}

