/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation;

import com.svea.webpay.common.auth.SveaCredential;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FeeDetail {
    public static final int DEFAULT_ROUNDING_DECIMALS = 2;
    public static final String FEETYPE_ADM = "adm";
    public static final String FEETYPE_CREDIT = "credit";
    public static final String FEETYPE_REMINDER = "reminder";
    public static final String FEETYPE_COLLECTION = "collection";
    public static final String FEETYPE_INTEREST = "interest";
    public static final String FEETYPE_POSTAGE = "postage";
    public static final String FEETYPE_MIXED = "mixed";
    public static final String FEETYPE_CREDITCARD = "creditcard";
    public static final String FEETYPE_REGRESS = "regress";
    public static final String FEETYPE_COST = "cost";
    public static final String FEETYPE_KICKBACK = "kickback";
    public static final String FEETYPE_VAT = "vat";
    public static final String FEETYPE_DEVIATIONS = "deviations";
    public static final String FEETYPE_ROUNDING = "rounding";
    public static final String FEETYPE_DUEDATE = "duedate";
    public static final String FEETYPE_EMAILINVOICE = "emailinvoice";
    public static final String FEETYPE_SUBSCRIPTION = "subscription";
    public static final String FEETYPE_LEGAL_ACTION = "legal-action";
    public static final String REVENUE_REMINDER = "revenue-reminder";
    public static final String REVENUE_INTEREST = "interest-income";
    public static final String ACCTTYPE_CASH = "cash";
    public static final String ACCTTYPE_RECONCILE = "reconcile";
    public static final String ACCTTYPE_DEPOSIT = "deposit";
    public static final String ACCTTYPE_RECEIVABLES = "receivables";
    public static final String ACCTTYPE_VAT = "vat";
    public static final String ACCTTYPE_BALANCE = "debt";
    public static final String ACCTTYPE_FEE = "fee";
    public static final String ACCTTYPE_DEVIATIONS = "deviations";
    public static Map<String, Integer> AccountingReportRowIdMap = new TreeMap<String, Integer>();
    public static Map<Integer, String> AccountingReportRowIdAsKeyMap;
    private String feeType;
    private Double fee = 0.0;
    private Double feeVat = 0.0;
    private String accountNr;
    private Integer vatType;

    static {
        AccountingReportRowIdMap.put(REVENUE_INTEREST, 99);
        AccountingReportRowIdMap.put(ACCTTYPE_RECEIVABLES, 129);
        AccountingReportRowIdMap.put(ACCTTYPE_CASH, 127);
        AccountingReportRowIdMap.put("vat", 130);
        AccountingReportRowIdMap.put(FEETYPE_CREDIT, 137);
        AccountingReportRowIdAsKeyMap = new TreeMap<Integer, String>();
        AccountingReportRowIdAsKeyMap.put(99, REVENUE_INTEREST);
        AccountingReportRowIdAsKeyMap.put(129, ACCTTYPE_RECEIVABLES);
        AccountingReportRowIdAsKeyMap.put(127, ACCTTYPE_CASH);
        AccountingReportRowIdAsKeyMap.put(130, "vat");
        AccountingReportRowIdAsKeyMap.put(137, FEETYPE_CREDIT);
    }

    public static Double getFeeSum(List<FeeDetail> list) {
        if (list == null) {
            return 0.0;
        }
        Double result = 0.0;
        for (FeeDetail f : list) {
            result = result + f.fee;
        }
        return result;
    }

    public static Double getVatSum(List<FeeDetail> list) {
        if (list == null) {
            return 0.0;
        }
        Double result = 0.0;
        for (FeeDetail f : list) {
            result = result + f.feeVat;
        }
        return result;
    }

    public static Double getTotalSum(List<FeeDetail> list) {
        if (list == null) {
            return 0.0;
        }
        Double result = 0.0;
        for (FeeDetail f : list) {
            result = result + f.getFeeTotal();
        }
        return result;
    }

    public static void subtract(List<FeeDetail> list, String[] feeTypes, boolean removeCompletely, FeeDetail subtract) {
        FeeDetail remainder = new FeeDetail();
        remainder.fee = subtract != null ? subtract.fee : 0.0;
        remainder.feeVat = subtract != null ? subtract.feeVat : 0.0;
        double sf = 0.0;
        double sv = 0.0;
        ArrayList<FeeDetail> removeThese = new ArrayList<FeeDetail>();
        String[] stringArray = feeTypes;
        int n = feeTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String feeType = stringArray[n2];
            for (FeeDetail f : list) {
                if (feeType != null && feeType.trim().length() > 0) {
                    if (!feeType.equals(f.feeType)) continue;
                    if (removeCompletely) {
                        removeThese.add(f);
                        continue;
                    }
                }
                if (f.fee == null) {
                    f.fee = 0.0;
                }
                if (f.feeVat == null) {
                    f.feeVat = 0.0;
                }
                sf = Math.min(f.fee, remainder.fee);
                f.fee = f.fee - sf;
                remainder.fee = remainder.fee - sf;
                sv = Math.min(f.feeVat, remainder.feeVat);
                f.feeVat = f.feeVat - sv;
                remainder.fee = remainder.fee - sf;
                if (sf == 0.0 && sv == 0.0) break;
            }
            ++n2;
        }
        for (FeeDetail remove : removeThese) {
            list.remove(remove);
        }
    }

    public static void add(List<FeeDetail> list, FeeDetail add) {
        if (list == null) {
            return;
        }
        if (list.size() == 0) {
            list.add(add);
        } else {
            FeeDetail toAdd = list.get(0);
            toAdd.add(add);
        }
    }

    public FeeDetail() {
    }

    public FeeDetail(String feeType, Double fee, Double feeVat) {
        this.feeType = feeType;
        this.fee = fee;
        this.feeVat = feeVat;
    }

    public FeeDetail(FeeDetail f) {
        this.feeType = f.feeType;
        this.fee = f.fee;
        this.feeVat = f.feeVat;
    }

    public FeeDetail add(FeeDetail f) {
        this.fee = this.fee + f.fee;
        this.feeVat = this.feeVat + f.feeVat;
        return this;
    }

    public FeeDetail subtract(FeeDetail f) {
        this.fee = this.fee - f.fee;
        this.feeVat = this.feeVat - f.feeVat;
        return this;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public Double getFee() {
        return this.fee;
    }

    public void setFee(Double fee) {
        this.fee = fee;
    }

    public Double getFeeVat() {
        return this.feeVat;
    }

    public void setFeeVat(Double feeVat) {
        this.feeVat = feeVat;
    }

    public Double getFeeTotal() {
        return (this.fee != null ? this.fee : 0.0) + (this.feeVat != null ? this.feeVat : 0.0);
    }

    public Double calculateVat(double vatRate) {
        if (this.fee != null && this.fee != 0.0) {
            this.fee = FeeDetail.roundFee(this.fee, 2);
            this.feeVat = this.fee * vatRate;
            this.feeVat = FeeDetail.roundFee(this.feeVat, 2);
        } else if (this.getFeeTotal() != 0.0) {
            double feeTotal = FeeDetail.roundFee(this.getFeeTotal(), 2);
            this.fee = feeTotal / (1.0 + vatRate);
            this.fee = FeeDetail.roundFee(this.fee, 2);
            this.feeVat = FeeDetail.roundFee(feeTotal - this.fee, 2);
        }
        return this.feeVat;
    }

    public static double roundFee(double value, int decimals) {
        if (decimals <= 0) {
            return Math.round(value);
        }
        double divideby = Math.pow(10.0, decimals);
        double rounded = (double)Math.round(value * divideby) / divideby;
        return rounded;
    }

    public static FeeDetail remapFeeAccount(SveaCredential cre, FeeDetail f) {
        if (f == null || f.getFeeType() == null) {
            return f;
        }
        if (cre == null) {
            return f;
        }
        String acctNo = cre.getAccountMap().get(f.getFeeType());
        if (acctNo != null) {
            String remap;
            f.setAccountNr(acctNo);
            if (cre.getAccountRemap() != null && (remap = cre.getAccountRemap().get(acctNo)) != null) {
                f.setAccountNr(remap);
            }
        }
        return f;
    }

    public static List<FeeDetail> remapFeeAccounts(SveaCredential cre, List<FeeDetail> srcFees) {
        if (srcFees == null) {
            return null;
        }
        for (FeeDetail f : srcFees) {
            FeeDetail.remapFeeAccount(cre, f);
        }
        return srcFees;
    }

    public String getAccountNr() {
        return this.accountNr;
    }

    public void setAccountNr(String accountNr) {
        this.accountNr = accountNr;
    }

    public Integer getVatType() {
        return this.vatType;
    }

    public void setVatType(Integer vatType) {
        this.vatType = vatType;
    }

    public void roundAll() {
        if (this.fee == null) {
            this.fee = 0.0;
        }
        this.fee = FeeDetail.roundFee(this.fee, 2);
        if (this.feeVat == null) {
            this.feeVat = 0.0;
        }
        this.feeVat = FeeDetail.roundFee(this.feeVat, 2);
    }

    public String toString() {
        return "FeeDetail {AccountNo: " + (this.accountNr != null ? this.accountNr : " - ") + ", Fee: " + (this.fee != null ? this.fee : " - ") + ", Vat: " + (this.feeVat != null ? this.feeVat : " - ") + ", Total: " + this.getFeeTotal() + "}";
    }
}

