/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation;

import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class PaymentReport {
    private String taxId;
    private String orgName;
    private String taxIdFormat;
    private List<PaymentReportGroup> paymentReportGroup;

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getTaxIdFormat() {
        return this.taxIdFormat;
    }

    public void setTaxIdFormat(String taxIdFormat) {
        this.taxIdFormat = taxIdFormat;
    }

    public List<PaymentReportGroup> getPaymentReportGroup() {
        return this.paymentReportGroup;
    }

    public void setPaymentReportGroup(List<PaymentReportGroup> paymentReportGroup) {
        this.paymentReportGroup = paymentReportGroup;
    }

    public void addPaymentReportGroup(PaymentReportGroup gr) {
        if (this.paymentReportGroup == null) {
            this.paymentReportGroup = new ArrayList<PaymentReportGroup>();
        }
        this.paymentReportGroup.add(gr);
        gr.updateTotalFees();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("{");
        if (this.taxId != null) {
            str.append(this.taxId);
        }
        if (this.orgName != null) {
            if (str.length() > 1) {
                str.append(", ");
            }
            str.append(this.orgName);
        }
        str.append("}");
        return str.toString();
    }

    public List<String> getPaymentTypeReferences() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.paymentReportGroup == null) {
            return result;
        }
        TreeSet<String> resultSet = new TreeSet<String>();
        for (PaymentReportGroup gr : this.paymentReportGroup) {
            if (gr.getPaymentTypeReference() == null) continue;
            resultSet.add(gr.getPaymentTypeReference());
        }
        Iterator i = resultSet.iterator();
        while (i.hasNext()) {
            result.add((String)i.next());
        }
        return result;
    }

    public Date fromDate() throws ParseException {
        if (this.paymentReportGroup == null) {
            return null;
        }
        Date earliestDate = null;
        for (PaymentReportGroup gr : this.paymentReportGroup) {
            if (earliestDate != null && !gr.getReconciliationDateAsDate().before(earliestDate)) continue;
            earliestDate = gr.getReconciliationDateAsDate();
        }
        return earliestDate;
    }

    public Date untilDate() throws ParseException {
        if (this.paymentReportGroup == null) {
            return null;
        }
        Date latestDate = null;
        for (PaymentReportGroup gr : this.paymentReportGroup) {
            if (latestDate != null && !gr.getReconciliationDateAsDate().after(latestDate)) continue;
            latestDate = gr.getReconciliationDateAsDate();
        }
        return latestDate;
    }

    public long countReportLines() {
        if (this.paymentReportGroup == null || this.paymentReportGroup.isEmpty()) {
            return 0L;
        }
        long total = 0L;
        for (PaymentReportGroup g : this.paymentReportGroup) {
            total += (long)(g.getPaymentReportDetail() != null ? g.getPaymentReportDetail().size() : 0);
        }
        return total;
    }

    public void pruneReport() {
        if (this.paymentReportGroup == null || this.paymentReportGroup.isEmpty()) {
            return;
        }
        ArrayList<PaymentReportGroup> pruneThese = new ArrayList<PaymentReportGroup>();
        for (PaymentReportGroup g : this.paymentReportGroup) {
            if (!g.isEmpty()) continue;
            pruneThese.add(g);
        }
        if (!pruneThese.isEmpty()) {
            for (PaymentReportGroup g : pruneThese) {
                this.paymentReportGroup.remove(g);
            }
        }
    }
}

