/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation;

import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReference;
import com.svea.webpay.common.reconciliation.UnclearVatRateException;
import com.svea.webpay.common.reconciliation.VatType;
import java.beans.Transient;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PaymentReportDetail {
    public static Pattern invoiceNoPattern = Pattern.compile(".*?FA?K?T?\\s*(\\d{7,10}).*");
    public static Pattern orderInvoicePattern = Pattern.compile(".*?\\s+(.*?)/(\\d{7,10}).*$");
    public static Pattern reminderPattern = Pattern.compile(".*?\\bP\u00c5M\\.?I?N?(AVG)?.*");
    public static Pattern collectionPattern = Pattern.compile(".*?\\bINK(ASSO)?(AVGI?F?T?)?\\b.*");
    public static Pattern dueDatePattern = Pattern.compile(".*?\\bFFD\\b.*");
    public static Pattern dueDatePatternFi = Pattern.compile(".*?ER\u00c4P\u00c4IV\u00c4.*");
    public static Pattern legalActionPattern = Pattern.compile(".*?\\bBF\\b.*");
    public static Pattern legalActionPattern2 = Pattern.compile(".*?UTL\u00c4?G?G?.*");
    public static Pattern creditPattern = Pattern.compile("^KREDI?T?\\s+.*$");
    public static Pattern debitInvoicePattern = Pattern.compile("^REG?R?E?S?S?.*?(\\d{7,10}).*$");
    public static Pattern costPattern = Pattern.compile("^KOSTN?A?D?E?R?\\s+.*$");
    public static Pattern annualFeePattern = Pattern.compile("^\u00c5RSAVG.*$");
    public static Pattern paymentTermChangePattern = Pattern.compile("^OML.*$");
    public static Pattern refundPattern = Pattern.compile("^\u00c5T?E?R?BE?T?.*$");
    public static Pattern kickbackPattern = Pattern.compile(".*?KICK\\s?BACK.*$");
    public static Pattern depositAcctPattern = Pattern.compile(".*?SP\u00c4RRKONTO.*$");
    public static Pattern vatAdjustmentPattern = Pattern.compile(".*?KORR MOMS.*");
    public static final String REF_EMAIL = "email";
    public static final String REF_ZIPCODE = "zipcode";
    public static final String REF_CLIENT_INVOICE_NO = "client_invoice_no";
    public static final String REF_CLIENT_CUST_NO = "client_cust_no";
    public static final String REF_CLIENT_REF = "client_ref";
    public static final String REF_COMMENT = "comment";
    public static final String REF_CREDIT_ID = "credit_id";
    public static final String REF_DELIVERY_ID = "delivery_id";
    private String paymentId;
    private String invoiceId;
    private String orderId;
    private String checkoutOrderId;
    private String customerId;
    private String payerOrgNo;
    private String payerName;
    private String clientOrderNo;
    private String orderDate;
    private Double orderTotalAmt;
    private Double orderVat;
    private Double paidAmt;
    private Double receivedAmt;
    private Boolean retry = null;
    private Boolean enrichFromInvoice = null;
    private Boolean enrichFromOrder = null;
    private List<PaymentReference> references;
    private List<FeeDetail> fees;

    public PaymentReportDetail() {
    }

    public PaymentReportDetail(String paymentId, String invoiceId, String orderId, String customerId, String payerOrgNo, String payerName, String clientReference, Double paidAmt, Double receivedAmt) {
        this.paymentId = paymentId;
        this.invoiceId = invoiceId;
        this.orderId = orderId;
        this.customerId = customerId;
        this.payerOrgNo = payerOrgNo;
        this.payerName = payerName;
        this.clientOrderNo = clientReference;
        this.paidAmt = paidAmt;
        this.receivedAmt = receivedAmt;
    }

    public void addFee(FeeDetail fee) {
        if (this.fees == null) {
            this.fees = new ArrayList<FeeDetail>();
        }
        this.fees.add(fee);
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getCheckoutOrderId() {
        return this.checkoutOrderId;
    }

    public void setCheckoutOrderId(String checkoutOrderId) {
        this.checkoutOrderId = checkoutOrderId;
    }

    public String getPayerOrgNo() {
        return this.payerOrgNo;
    }

    public void setPayerOrgNo(String payerOrgNo) {
        this.payerOrgNo = payerOrgNo;
    }

    public String getPayerName() {
        return this.payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public String getClientOrderNo() {
        return this.clientOrderNo;
    }

    public void setClientOrderNo(String clientOrderNo) {
        this.clientOrderNo = clientOrderNo;
    }

    public String getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(String orderDate) {
        this.orderDate = orderDate;
    }

    @Transient
    public Date getOrderDateAsDate() throws ParseException {
        if (this.orderDate == null) {
            return null;
        }
        return JsonUtil.dfmt.parse(this.orderDate);
    }

    public Double getOrderTotalAmt() {
        return this.orderTotalAmt;
    }

    public void setOrderTotalAmt(Double orderTotalAmt) {
        this.orderTotalAmt = orderTotalAmt;
    }

    public Double getOrderVat() {
        return this.orderVat;
    }

    public void setOrderVat(Double orderVat) {
        this.orderVat = orderVat;
    }

    public List<PaymentReference> getReferences() {
        return this.references;
    }

    public void setReferences(List<PaymentReference> references) {
        this.references = references;
    }

    @Transient
    public void addReference(String key, String value) {
        if (key == null) {
            return;
        }
        if (this.references == null && value == null) {
            return;
        }
        if (this.references == null) {
            this.references = new ArrayList<PaymentReference>();
        }
        PaymentReference existing = null;
        for (PaymentReference r : this.references) {
            if (!key.equalsIgnoreCase(r.getReferenceKey())) continue;
            existing = r;
            break;
        }
        if (existing != null) {
            existing.setReferenceValue(value);
        } else {
            this.references.add(new PaymentReference(key, value));
        }
    }

    @Transient
    public String getReference(String key) {
        if (this.references == null || key == null) {
            return null;
        }
        for (PaymentReference r : this.references) {
            if (!key.equalsIgnoreCase(r.getReferenceKey())) continue;
            return r.getReferenceValue();
        }
        return null;
    }

    public List<FeeDetail> getFees() {
        return this.fees;
    }

    public void setFees(List<FeeDetail> fees) {
        this.fees = fees;
    }

    public Double getPaidAmt() {
        return this.paidAmt;
    }

    public void setPaidAmt(Double paidAmt) {
        this.paidAmt = paidAmt;
    }

    public Double getReceivedAmt() {
        return this.receivedAmt;
    }

    public void setReceivedAmt(Double receivedAmt) {
        this.receivedAmt = receivedAmt;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public Double calculateReceivedAmt() {
        double totalFees = 0.0;
        if (this.getFees() != null) {
            for (FeeDetail fee : this.getFees()) {
                totalFees += fee.getFeeTotal().doubleValue();
            }
        }
        this.receivedAmt = this.paidAmt - totalFees;
        return this.receivedAmt;
    }

    public Boolean getRetry() {
        return this.retry;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public Boolean getEnrichFromInvoice() {
        return this.enrichFromInvoice;
    }

    public void setEnrichFromInvoice(Boolean enrichFromInvoice) {
        this.enrichFromInvoice = enrichFromInvoice;
    }

    public Boolean getEnrichFromOrder() {
        return this.enrichFromOrder;
    }

    public void setEnrichFromOrder(Boolean enrichFromOrder) {
        this.enrichFromOrder = enrichFromOrder;
    }

    public static PaymentReportDetail parseDeviation(String countryCode, String accountType, Date vatRateDate, boolean isCompany, String description, double amount, double qty, int rowId) throws UnclearVatRateException {
        PaymentReportDetail result = new PaymentReportDetail();
        if (description == null) {
            description = "";
        }
        description = description.toUpperCase();
        Matcher invoiceNoMatcher = invoiceNoPattern.matcher(description);
        Matcher orderInvoiceMatcher = orderInvoicePattern.matcher(description);
        Matcher reminderMatcher = reminderPattern.matcher(description);
        Matcher collectionMatcher = collectionPattern.matcher(description);
        Matcher dueDateMatcher = dueDatePattern.matcher(description);
        Matcher legalActionMatcher = legalActionPattern.matcher(description);
        Matcher legalActionMatcher2 = legalActionPattern2.matcher(description);
        Matcher creditMatcher = creditPattern.matcher(description);
        Matcher debitInvoiceMatcher = debitInvoicePattern.matcher(description);
        Matcher costMatcher = costPattern.matcher(description);
        Matcher annualFeeMatcher = annualFeePattern.matcher(description);
        Matcher paymentTermChangeMatcher = paymentTermChangePattern.matcher(description);
        Matcher refundMatcher = refundPattern.matcher(description);
        Matcher kickbackMatcher = kickbackPattern.matcher(description);
        Matcher depositAcctMatcher = depositAcctPattern.matcher(description);
        Matcher vatAdjustmentMatcher = vatAdjustmentPattern.matcher(description);
        if (invoiceNoMatcher.matches()) {
            result.setInvoiceId(invoiceNoMatcher.group(1));
        }
        if (orderInvoiceMatcher.matches()) {
            result.setClientOrderNo(orderInvoiceMatcher.group(1));
            result.setInvoiceId(orderInvoiceMatcher.group(2));
        }
        if (!(result.getInvoiceId() == null || creditMatcher.matches() || debitInvoiceMatcher.matches() || paymentTermChangeMatcher.matches())) {
            result.setEnrichFromInvoice(Boolean.TRUE);
            FeeDetail fee = new FeeDetail();
            fee.setFee(-amount);
            if (reminderMatcher.matches()) {
                fee.setFeeType("reminder");
            } else if (collectionMatcher.matches()) {
                fee.setFeeType("collection");
            } else if (dueDateMatcher.matches()) {
                fee.setFeeType("duedate");
            } else if (legalActionMatcher.matches()) {
                fee.setFeeType("legal-action");
            } else if (costMatcher.matches()) {
                fee.setFeeType("cost");
            } else if (vatAdjustmentMatcher.matches()) {
                fee.setFeeType("vat");
            } else {
                fee.setFeeType("deviations");
            }
            result.addFee(fee);
            if (result.getFees() != null && result.getFees().size() > 0) {
                if (!vatAdjustmentMatcher.matches()) {
                    double vatRate = 0.0;
                    for (FeeDetail f : result.getFees()) {
                        try {
                            vatRate = VatType.getVatRate(countryCode, f.getFeeType(), accountType, vatRateDate, isCompany);
                            f.calculateVat(vatRate);
                        }
                        catch (UnclearVatRateException uvre) {
                            System.err.println(uvre.getMessage());
                            description = String.valueOf(description) + " :VAT unclear (" + f.getFeeType() + ")";
                        }
                    }
                }
                double totalFees = FeeDetail.getTotalSum(result.getFees());
                result.setReceivedAmt(-totalFees);
                result.setPaidAmt(0.0);
            }
        } else if (result.getInvoiceId() != null && (creditMatcher.matches() || paymentTermChangeMatcher.matches() || refundMatcher.matches())) {
            result.setEnrichFromInvoice(Boolean.TRUE);
            result.setReceivedAmt(amount);
            result.setPaidAmt(amount);
        } else if (debitInvoiceMatcher.matches()) {
            String invoiceId = debitInvoiceMatcher.group(1);
            result.setInvoiceId(invoiceId);
            result.setEnrichFromInvoice(Boolean.TRUE);
            result.setReceivedAmt(amount);
            result.setPaidAmt(amount);
        } else {
            FeeDetail fee;
            if ("admin".equals(accountType) && legalActionMatcher2.matches()) {
                fee = new FeeDetail();
                fee.setFee(-amount);
                fee.setFeeType("legal-action");
                result.addFee(fee);
            } else if (annualFeeMatcher.matches()) {
                fee = new FeeDetail();
                fee.setFee(-amount);
                fee.setFeeType("adm");
                result.addFee(fee);
            } else if (kickbackMatcher.matches()) {
                fee = new FeeDetail();
                fee.setFee(-amount);
                fee.setFeeType("kickback");
                result.addFee(fee);
            } else if (depositAcctMatcher.matches()) {
                fee = new FeeDetail();
                fee.setFee(-amount);
                fee.setFeeType("deposit");
                result.addFee(fee);
            }
            if (result.getFees() != null && result.getFees().size() > 0) {
                double vatRate = 0.0;
                for (FeeDetail f : result.getFees()) {
                    if ("deposit".equalsIgnoreCase(f.getFeeType())) continue;
                    try {
                        vatRate = VatType.getVatRate(countryCode, f.getFeeType(), accountType, vatRateDate, isCompany);
                        f.calculateVat(vatRate);
                    }
                    catch (UnclearVatRateException uvre) {
                        System.err.println(uvre.getMessage());
                        description = String.valueOf(description) + " :VAT unclear (" + f.getFeeType() + ")";
                    }
                }
                double totalFees = FeeDetail.getTotalSum(result.getFees());
                result.setReceivedAmt(-totalFees);
                result.setPaidAmt(0.0);
            }
        }
        if (result.getFees() == null && result.getReceivedAmt() == null) {
            FeeDetail fee = new FeeDetail();
            fee.setFee(0.0);
            fee.setFeeType("deviations");
            result.addFee(fee);
            result.setReceivedAmt(amount);
            result.setPaidAmt(amount);
        }
        result.addReference(REF_COMMENT, description);
        return result;
    }
}

