/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation.conv;

import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.TreeMap;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelToReconFormat {
    private FormulaEvaluator evaluator;
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public PaymentReport fromExcelFileCCFormat(String filename, String taxId, String orgName, String paymentType, String dstAcct) throws EncryptedDocumentException, InvalidFormatException, IOException, ParseException {
        File f = new File(filename);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        return this.fromExcelInputStreamCCFormat(bis, taxId, orgName, paymentType, dstAcct);
    }

    public PaymentReport fromExcelInputStreamCCFormat(InputStream inp, String taxId, String orgName, String paymentType, String dstAcct) throws EncryptedDocumentException, InvalidFormatException, IOException, ParseException {
        Workbook wb = WorkbookFactory.create((InputStream)inp);
        this.evaluator = wb.getCreationHelper().createFormulaEvaluator();
        PaymentReport result = new PaymentReport();
        result.setTaxId(taxId);
        result.setOrgName(orgName);
        PaymentReportGroup group = null;
        PaymentReportDetail pmt = null;
        TreeMap currencyMap = new TreeMap();
        TreeMap<Instant, PaymentReportGroup> groupDateMap = null;
        Sheet sheet = wb.getSheetAt(0);
        Date currentDate = null;
        Date reconciliationDate = null;
        String currentCurrency = null;
        String reconciliationCurrency = null;
        int r = 1;
        while (r < sheet.getLastRowNum() + 1) {
            Row row = sheet.getRow(r);
            if (row.getCell(1) != null && !CellType.BLANK.equals((Object)row.getCell(1).getCellTypeEnum())) {
                int c;
                reconciliationDate = group != null ? group.getReconciliationDateAsDate() : null;
                reconciliationCurrency = group != null ? group.getCurrency() : null;
                currentCurrency = this.getCellAsString(row.getCell(4));
                currentDate = this.getDate(row.getCell(5));
                if (currentCurrency != null && !currentCurrency.equalsIgnoreCase(reconciliationCurrency) && (groupDateMap = (TreeMap<Instant, PaymentReportGroup>)currencyMap.get(currentCurrency)) == null) {
                    groupDateMap = new TreeMap<Instant, PaymentReportGroup>();
                    currencyMap.put(currentCurrency, groupDateMap);
                }
                if (currentDate != null) {
                    Instant rDate;
                    Instant cDate = Instant.ofEpochMilli(currentDate.getTime()).truncatedTo(ChronoUnit.DAYS);
                    Instant instant = rDate = reconciliationDate != null ? Instant.ofEpochMilli(reconciliationDate.getTime()).truncatedTo(ChronoUnit.DAYS) : null;
                    if (!cDate.equals(rDate) && (group = (PaymentReportGroup)groupDateMap.get(cDate)) == null) {
                        group = new PaymentReportGroup();
                        group.setCurrency(currentCurrency);
                        group.setDstAcct(dstAcct);
                        group.setPaymentType(paymentType);
                        group.setReconciliationDate(new Date(cDate.toEpochMilli()));
                        groupDateMap.put(cDate, group);
                        result.addPaymentReportGroup(group);
                    }
                }
                if (group == null) {
                    throw new InvalidFormatException("No date for payment transaction on row " + r);
                }
                pmt = new PaymentReportDetail();
                pmt.setPaymentId(this.getCellAsString(row.getCell(0)));
                pmt.setClientOrderNo(this.getCellAsString(row.getCell(1)));
                if (pmt.getClientOrderNo() != null && (c = pmt.getClientOrderNo().indexOf("-WRetry")) >= 0) {
                    pmt.setClientOrderNo(pmt.getClientOrderNo().substring(0, c));
                }
                pmt.setPaidAmt(row.getCell(3).getNumericCellValue());
                pmt.setReceivedAmt(row.getCell(3).getNumericCellValue());
                group.addDetail(pmt);
            }
            ++r;
        }
        return result;
    }

    private String getCellAsString(Cell c) {
        if (c == null) {
            return null;
        }
        CellType ct = c.getCellTypeEnum();
        if (ct.equals((Object)CellType.FORMULA)) {
            CellValue cellValue = this.evaluator.evaluate(c);
            if (ct.equals((Object)CellType.NUMERIC)) {
                return Integer.toString((int)cellValue.getNumberValue());
            }
            return cellValue.getStringValue();
        }
        return ct.equals((Object)CellType.NUMERIC) ? Integer.toString((int)c.getNumericCellValue()) : c.getStringCellValue();
    }

    private Date getDate(Cell c) throws ParseException {
        if (c == null) {
            return null;
        }
        Date result = null;
        CellType ct = c.getCellTypeEnum();
        if (ct.equals((Object)CellType.STRING)) {
            result = this.df.parse(c.getStringCellValue());
        } else if (ct.equals((Object)CellType.NUMERIC)) {
            result = c.getDateCellValue();
        }
        return result;
    }
}

