/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation.conv;

import com.svea.webpay.common.conv.TaxIdFormatter;
import com.svea.webpay.common.conv.TaxIdStructure;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpay.common.reconciliation.conv.ReconInputConverter;
import com.svea.webpay.common.reconciliation.conv.StringBufferOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.notima.bg.BgFile;
import org.notima.bg.BgMaxFile;
import org.notima.bg.Transaction;
import org.notima.bg.bgmax.BgMaxReceipt;
import org.notima.bg.bgmax.BgMaxSet;

public class ReconToBgMax
implements ReconInputConverter {
    private File outFile;
    public static String defaultCharsetName = "Cp850";
    public static Charset defaultCharSet = Charset.forName(defaultCharsetName);
    private Map<String, String> dstMap = new TreeMap<String, String>();
    private String defaultBg = "000-0000";

    public File getOutFile() {
        return this.outFile;
    }

    @Override
    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public String getDefaultBg() {
        return this.defaultBg;
    }

    public void setDefaultBg(String defaultBg) {
        this.defaultBg = defaultBg;
    }

    public void addBgMap(String paymentType, String bgNo) {
        if (paymentType != null) {
            this.dstMap.put(paymentType.toLowerCase(), bgNo);
        }
    }

    public String getBgNo(String paymentType) {
        if (paymentType == null) {
            return this.defaultBg;
        }
        String result = this.dstMap.get(paymentType.toLowerCase());
        if (result == null) {
            return this.defaultBg;
        }
        return result;
    }

    public List<BgFile> convertFromPaymentReport(PaymentReport report) throws Exception {
        if (report == null) {
            return null;
        }
        if (report.getPaymentReportGroup() == null) {
            return null;
        }
        ArrayList<BgFile> files = new ArrayList<BgFile>();
        BgMaxFile bgFile = null;
        BgMaxSet bgSet = null;
        Date currentReconciliationDate = null;
        for (PaymentReportGroup g : report.getPaymentReportGroup()) {
            if (currentReconciliationDate == null || !currentReconciliationDate.equals(g.getReconciliationDateAsDate())) {
                bgFile = new BgMaxFile(g.getReconciliationDateAsDate());
                files.add((BgFile)bgFile);
                currentReconciliationDate = g.getReconciliationDateAsDate();
            }
            bgSet = bgFile.createSet(currentReconciliationDate, g.getCurrency(), "", "", this.getBgNo(g.getPaymentType()));
            BgMaxReceipt r = null;
            if (g.getPaymentReportDetail() == null) continue;
            for (PaymentReportDetail pd : g.getPaymentReportDetail()) {
                String taxId;
                String taxIdFormat;
                String customerInvoiceNo;
                if (g.getProcessRetryPaymentsOnly() != null && g.getProcessRetryPaymentsOnly().booleanValue() && (pd.getRetry() == null || !pd.getRetry().booleanValue())) continue;
                r = new BgMaxReceipt(g.getReconciliationDateAsDate());
                r.setAmount(pd.getPaidAmt().doubleValue());
                r.setName1(pd.getPayerName());
                String zipCode = pd.getReference("zipcode");
                if (zipCode != null && zipCode.trim().length() > 0) {
                    r.setZipCode(zipCode);
                }
                if ((customerInvoiceNo = pd.getReference("client_invoice_no")) != null && customerInvoiceNo.trim().length() > 0) {
                    r.setReference(customerInvoiceNo);
                } else {
                    r.setReference(pd.getInvoiceId());
                }
                r.setBgcRef(pd.getPaymentId() != null ? pd.getPaymentId() : pd.getOrderId());
                Vector<String> infoRecords = new Vector<String>();
                StringBuffer infoRecord = new StringBuffer();
                if (pd.getOrderId() != null && pd.getOrderId().trim().length() > 0) {
                    infoRecord.append("O: " + pd.getOrderId());
                }
                if (pd.getClientOrderNo() != null && pd.getClientOrderNo().trim().length() > 0) {
                    if (infoRecord.length() > 0) {
                        infoRecord.append(" ");
                    }
                    infoRecord.append("Ref: " + pd.getClientOrderNo());
                }
                if (pd.getCustomerId() != null && pd.getCustomerId().trim().length() > 0) {
                    if (infoRecord.length() > 0) {
                        infoRecord.append(" ");
                    }
                    infoRecord.append("Knr: " + pd.getCustomerId());
                }
                if (infoRecord.length() > 0) {
                    infoRecords.add(infoRecord.toString());
                }
                if (infoRecords.size() > 0) {
                    r.setInfoRecords(infoRecords);
                }
                if (pd.getPayerOrgNo() != null && !(taxIdFormat = TaxIdFormatter.determineFormat("SE", taxId = TaxIdFormatter.removeBlanks(pd.getPayerOrgNo()))).equals(TaxIdStructure.FMT_UNKNOWN)) {
                    r.setTaxId(TaxIdFormatter.printTaxId(taxIdFormat, taxId, TaxIdStructure.FMT_SE10));
                }
                bgSet.addTransaction((Transaction)r);
            }
        }
        return files;
    }

    @Override
    public List<StringBuffer> convertFromRecon(PaymentReport report) throws Exception {
        if (report == null) {
            return null;
        }
        if (report.getPaymentReportGroup() == null) {
            return null;
        }
        List<BgFile> files = this.convertFromPaymentReport(report);
        ArrayList<StringBuffer> resultList = new ArrayList<StringBuffer>();
        for (BgFile bgf : files) {
            StringBuffer fileStr = new StringBuffer();
            StringBufferOutputStream of = new StringBufferOutputStream(fileStr);
            bgf.writeToStream((OutputStream)of, defaultCharSet);
            resultList.add(fileStr);
        }
        if (this.outFile != null) {
            PrintWriter wr = new PrintWriter(this.outFile);
            for (StringBuffer sb : resultList) {
                wr.append(sb);
                wr.append("\n");
            }
            wr.close();
            resultList.clear();
            resultList.add(new StringBuffer(this.outFile.getAbsolutePath()));
        }
        return resultList;
    }
}

