/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation.conv;

import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpay.common.reconciliation.conv.ReconInputConverter;
import java.io.File;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class ReconToFlatFormat
implements ReconInputConverter {
    private File outFile;
    private boolean createBalanceTrxForDebt = false;
    public static final int RECONCILE_DATE_COL = 3;
    public static final int ORDER_DATE_COL = 11;
    public static final Object[] headerColumns = new String[]{"recipient-tax-id", "customer-tax-id", "tax-id-format", "reconciliation-date", "svea-customer-id", "external-customer-id", "customer-name", "customer-email", "customer-zipcode", "external-order-no", "external-invoice-no", "order-date", "order-amt", "order-vat", "svea-invoice-no", "svea-order-no", "pmt-transaction-id", "svea-checkout-id", "customer-paid-amt", "svea-paid-amt", "fee-amt-ex-vat", "fee-type", "fee-vat", "recipient-bank-acct-no", "recipient-bank-acct-type", "client-id", "payment-type", "currency", "dst-currency", "exchange-rate", "comment", "credit-id", "delivery-id"};
    public static int NCOLS = headerColumns.length;
    public DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean isCreateBalanceTrxForDebt() {
        return this.createBalanceTrxForDebt;
    }

    public void setCreateBalanceTrxForDebt(boolean createBalanceTrxForDebt) {
        this.createBalanceTrxForDebt = createBalanceTrxForDebt;
    }

    private Object[] createRowObjectFromFee(PaymentReport report, PaymentReportGroup g, FeeDetail f) throws ParseException {
        int c = 0;
        Object[] row = new Object[NCOLS];
        row[c++] = report.getTaxId();
        row[c++] = null;
        row[c++] = null;
        row[c++] = g.getReconciliationDateAsDate();
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = null;
        row[c++] = 0.0;
        row[c++] = -f.getFeeTotal().doubleValue();
        String feeType = f.getFeeType();
        row[c++] = feeType.equalsIgnoreCase("debt") || feeType.equalsIgnoreCase("deposit") ? Double.valueOf(0.0) : f.getFee();
        row[c++] = feeType;
        row[c++] = f.getFeeVat();
        row[c++] = g.getDstBankAcct();
        row[c++] = g.getDstBankAcctType();
        row[c++] = g.getPaymentTypeReference();
        row[c++] = g.getPaymentType();
        row[c++] = g.getCurrency();
        row[c++] = g.getCurrency();
        row[c++] = new Double(1.0);
        row[c++] = f.getAccountNr();
        return row;
    }

    private Object[] createRowObjectFromPaymentDetail(PaymentReport report, PaymentReportGroup g, PaymentReportDetail d) throws ParseException {
        int c = 0;
        Object[] row = new Object[NCOLS];
        row[c++] = g.getTaxId() != null && g.getTaxId().trim().length() > 0 ? g.getTaxId() : report.getTaxId();
        row[c++] = d.getPayerOrgNo();
        row[c++] = report.getTaxIdFormat();
        row[c++] = g.getReconciliationDateAsDate();
        row[c++] = d.getCustomerId();
        row[c++] = d.getReference("client_cust_no");
        row[c++] = d.getPayerName();
        row[c++] = d.getReference("email");
        row[c++] = d.getReference("zipcode");
        row[c++] = d.getClientOrderNo();
        row[c++] = d.getReference("client_invoice_no");
        row[c++] = d.getOrderDateAsDate();
        row[c++] = d.getOrderTotalAmt();
        row[c++] = d.getOrderVat();
        row[c++] = d.getInvoiceId();
        row[c++] = d.getOrderId();
        row[c++] = d.getPaymentId();
        row[c++] = d.getCheckoutOrderId();
        row[c++] = d.getPaidAmt();
        row[c++] = d.getReceivedAmt();
        String feeType = d.getFees() != null ? (d.getFees().size() == 1 ? d.getFees().get(0).getFeeType() : "mixed") : "";
        row[c++] = feeType.equalsIgnoreCase("debt") || feeType.equalsIgnoreCase("deposit") ? Double.valueOf(0.0) : FeeDetail.getFeeSum(d.getFees());
        row[c++] = feeType;
        row[c++] = FeeDetail.getVatSum(d.getFees());
        row[c++] = g.getDstBankAcct();
        row[c++] = g.getDstBankAcctType();
        row[c++] = g.getPaymentTypeReference();
        row[c++] = g.getPaymentType();
        row[c++] = g.getCurrency();
        row[c++] = g.getCurrency();
        row[c++] = new Double(1.0);
        row[c++] = d.getReference("comment");
        row[c++] = d.getReference("credit_id");
        row[c++] = d.getReference("delivery_id");
        return row;
    }

    public List<Object[]> convertFromReconToRowObjects(PaymentReport report) throws ParseException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Object[] row = null;
        if (report == null || report.getPaymentReportGroup() == null) {
            return rows;
        }
        for (PaymentReportGroup g : report.getPaymentReportGroup()) {
            FeeDetail outBalance = null;
            FeeDetail inBalance = null;
            if (this.createBalanceTrxForDebt && g.getOpeningBalance() != null && g.getOpeningBalance() != 0.0) {
                inBalance = new FeeDetail();
                inBalance.setFeeType("debt");
                inBalance.setFee(-g.getOpeningBalance().doubleValue());
                row = this.createRowObjectFromFee(report, g, inBalance);
                rows.add(row);
            }
            if (g.getPaymentReportDetail() != null) {
                for (PaymentReportDetail d : g.getPaymentReportDetail()) {
                    row = this.createRowObjectFromPaymentDetail(report, g, d);
                    rows.add(row);
                }
            }
            if (g.getTotalOtherFees() != null && g.getTotalOtherFees().size() > 0) {
                for (FeeDetail f : g.getTotalOtherFees()) {
                    row = this.createRowObjectFromFee(report, g, f);
                    rows.add(row);
                }
            }
            if (!this.createBalanceTrxForDebt || g.getEndingBalance() == null || g.getEndingBalance() == 0.0) continue;
            outBalance = new FeeDetail();
            outBalance.setFeeType("debt");
            outBalance.setFee(g.getEndingBalance());
            row = this.createRowObjectFromFee(report, g, outBalance);
            rows.add(row);
        }
        if (rows != null && rows.size() > 0) {
            rows.add(0, headerColumns);
        }
        return rows;
    }

    @Override
    public void setOutFile(File of) {
        this.outFile = of;
    }

    @Override
    public List<StringBuffer> convertFromRecon(PaymentReport report) throws Exception {
        ArrayList<StringBuffer> result = new ArrayList<StringBuffer>();
        StringBuffer buf = new StringBuffer();
        result.add(buf);
        List<Object[]> rows = this.convertFromReconToRowObjects(report);
        CSVPrinter printer = new CSVPrinter((Appendable)buf, CSVFormat.EXCEL);
        int rowCount = 0;
        for (Object[] r : rows) {
            if (this.dateFormat != null && rowCount > 0) {
                if (r[3] != null) {
                    r[3] = this.dateFormat.format((Date)r[3]);
                }
                if (r[11] != null) {
                    r[11] = this.dateFormat.format((Date)r[11]);
                }
            }
            printer.printRecord(r);
            ++rowCount;
        }
        printer.close();
        if (this.outFile != null) {
            if (!this.outFile.getAbsolutePath().toLowerCase().endsWith(".csv")) {
                this.outFile = new File(String.valueOf(this.outFile.getAbsolutePath()) + ".csv");
            }
            PrintWriter fp = new PrintWriter(this.outFile);
            for (StringBuffer s : result) {
                fp.append(s.toString());
                fp.append("\n");
            }
            fp.close();
            result.clear();
            result.add(new StringBuffer(this.outFile.getAbsolutePath()));
        }
        return result;
    }
}

