/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpay.common.reconciliation.conv;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.svea.webpay.common.reconciliation.PaymentFullRow;
import com.svea.webpay.common.reconciliation.PaymentList;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.conv.ReconInputConverter;
import com.svea.webpay.common.reconciliation.conv.ReconToFlatFormat;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ReconToFlatJson
implements ReconInputConverter {
    private String dateFormatStr;
    private DateFormat dfmt;
    public static final String defaultDateFormatStr = "yyyy-MM-dd";
    public static final String defaultFileName = "reconciliation-report";
    private Gson gson;
    private int colNum;
    private File outFile;
    private boolean createBalanceTrxForDebt = false;

    public ReconToFlatJson() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        builder.setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE);
        builder.setLenient();
        this.gson = builder.create();
    }

    public String getDateFormatStr() {
        return this.dateFormatStr;
    }

    public void setDateFormatStr(String dateFormatStr) {
        this.dateFormatStr = dateFormatStr;
    }

    public boolean isCreateBalanceTrxForDebt() {
        return this.createBalanceTrxForDebt;
    }

    public void setCreateBalanceTrxForDebt(boolean createBalanceTrxForDebt) {
        this.createBalanceTrxForDebt = createBalanceTrxForDebt;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public File getOutFile() {
        return this.outFile;
    }

    @Override
    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public PaymentList createFlatJson(PaymentReport report) throws ParseException, IOException {
        if (this.dateFormatStr == null || this.dateFormatStr.trim().length() == 0) {
            this.dateFormatStr = defaultDateFormatStr;
        }
        this.dfmt = new SimpleDateFormat(this.dateFormatStr);
        ReconToFlatFormat flatConverter = new ReconToFlatFormat();
        flatConverter.setCreateBalanceTrxForDebt(this.createBalanceTrxForDebt);
        List<Object[]> rows = flatConverter.convertFromReconToRowObjects(report);
        PaymentList result = new PaymentList();
        int i = 1;
        while (i < rows.size()) {
            Object[] r = rows.get(i);
            result.getPaymentList().add(this.createRow(r));
            ++i;
        }
        return result;
    }

    private PaymentFullRow createRow(Object[] srcRow) {
        this.colNum = 0;
        PaymentFullRow row = new PaymentFullRow();
        row.setRecipientTaxId((String)srcRow[this.colNum++]);
        row.setCustomerTaxId((String)srcRow[this.colNum++]);
        row.setTaxIdFormat((String)srcRow[this.colNum++]);
        if (srcRow[this.colNum] != null) {
            row.setReconciliationDate(this.dfmt.format((Date)srcRow[this.colNum++]));
        } else {
            ++this.colNum;
        }
        row.setSveaCustomerId((String)srcRow[this.colNum++]);
        row.setExternalCustomerId((String)srcRow[this.colNum++]);
        row.setCustomerName((String)srcRow[this.colNum++]);
        row.setCustomerEmail((String)srcRow[this.colNum++]);
        row.setCustomerZipCode((String)srcRow[this.colNum++]);
        row.setExternalOrderNo((String)srcRow[this.colNum++]);
        row.setExternalInvoiceNo((String)srcRow[this.colNum++]);
        if (srcRow[this.colNum] != null) {
            row.setOrderDate(this.dfmt.format((Date)srcRow[this.colNum++]));
        } else {
            ++this.colNum;
        }
        row.setOrderAmt((Double)srcRow[this.colNum++]);
        row.setOrderVat((Double)srcRow[this.colNum++]);
        row.setSveaInvoiceNo((String)srcRow[this.colNum++]);
        row.setSveaOrderNo((String)srcRow[this.colNum++]);
        row.setPaymentTransactionId((String)srcRow[this.colNum++]);
        row.setSveaCheckoutId((String)srcRow[this.colNum++]);
        row.setCustomerPaidAmt((Double)srcRow[this.colNum++]);
        row.setSveaPaidAmt((Double)srcRow[this.colNum++]);
        row.setFeeAmtExVat((Double)srcRow[this.colNum++]);
        row.setFeeType((String)srcRow[this.colNum++]);
        row.setFeeVat((Double)srcRow[this.colNum++]);
        row.setRecipientBankAcctNo((String)srcRow[this.colNum++]);
        row.setRecipientBankAcctType((String)srcRow[this.colNum++]);
        row.setClientId((String)srcRow[this.colNum++]);
        row.setPaymentType((String)srcRow[this.colNum++]);
        row.setCurrency((String)srcRow[this.colNum++]);
        row.setDstCurrency((String)srcRow[this.colNum++]);
        row.setExchangeRate((Double)srcRow[this.colNum++]);
        row.setComment((String)srcRow[this.colNum++]);
        row.setCreditId((String)srcRow[this.colNum++]);
        row.setDeliveryId((String)srcRow[this.colNum++]);
        return row;
    }

    @Override
    public List<StringBuffer> convertFromRecon(PaymentReport report) throws Exception {
        ArrayList<StringBuffer> result = new ArrayList<StringBuffer>();
        PaymentList plist = this.createFlatJson(report);
        StringBuffer buf = new StringBuffer();
        buf.append(this.gson.toJson((Object)plist));
        result.add(buf);
        if (this.outFile != null) {
            if (!this.outFile.getAbsolutePath().toLowerCase().endsWith(".json")) {
                this.outFile = new File(String.valueOf(this.outFile.getAbsolutePath()) + ".json");
            }
            PrintWriter fp = new PrintWriter(this.outFile);
            for (StringBuffer s : result) {
                fp.append(s.toString());
                fp.append("\n");
            }
            fp.close();
            result.clear();
            result.add(new StringBuffer(this.outFile.getAbsolutePath()));
        }
        return result;
    }
}

