/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin;

import com.svea.webpay.common.auth.ListOfSveaCredentials;
import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpayadmin.WebpayAdminBase;
import com.svea.webpayadminservice.client.ArrayOfClientData;
import com.svea.webpayadminservice.client.ArrayOfDeliverOrderInformation;
import com.svea.webpayadminservice.client.ArrayOfGetInvoiceInformation;
import com.svea.webpayadminservice.client.ArrayOfInvoice;
import com.svea.webpayadminservice.client.ArrayOfPaymentPlanStatus;
import com.svea.webpayadminservice.client.ArrayOflong;
import com.svea.webpayadminservice.client.Authentication;
import com.svea.webpayadminservice.client.ClientData;
import com.svea.webpayadminservice.client.CustomerIdentity;
import com.svea.webpayadminservice.client.DeliverOrderInformation;
import com.svea.webpayadminservice.client.DeliveryRequest;
import com.svea.webpayadminservice.client.DeliveryResponse;
import com.svea.webpayadminservice.client.GetClientsByIdentityAccountRequest;
import com.svea.webpayadminservice.client.GetClientsByIdentityAccountResponse2;
import com.svea.webpayadminservice.client.GetInvoiceInformation;
import com.svea.webpayadminservice.client.GetInvoicesRequest;
import com.svea.webpayadminservice.client.GetInvoicesResponse2;
import com.svea.webpayadminservice.client.Invoice;
import com.svea.webpayadminservice.client.InvoiceDistributionType;
import com.svea.webpayadminservice.client.OrderType;
import com.svea.webpayadminservice.client.PaymentPlanListItem;
import com.svea.webpayadminservice.client.PaymentPlanStatus;
import com.svea.webpayadminservice.client.SearchPaymentPlanFilter;
import com.svea.webpayadminservice.client.SearchPaymentPlanSorting;
import com.svea.webpayadminservice.client.SearchPaymentPlansRequest;
import com.svea.webpayadminservice.client.SearchPaymentPlansResponse2;
import com.svea.webpayadminservice.client.SortDirection;
import com.svea.webpayadminservice.client.SortPaymentPlanProperty;
import com.svea.webpayadminservice.client.TextMatchType;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebpayAdminClient
extends WebpayAdminBase {
    public static Logger log = LoggerFactory.getLogger(WebpayAdminClient.class);

    public ListOfSveaCredentials getCredentialsByIdentity(String username, String password) throws Exception {
        GetClientsByIdentityAccountRequest req = new GetClientsByIdentityAccountRequest();
        Authentication auth = new Authentication();
        auth.setUsername(username);
        auth.setPassword(password);
        req.setAuthentication(auth);
        GetClientsByIdentityAccountResponse2 response = this.adminServicePort.getClientsByIdentityAccount(req);
        if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
            throw new Exception(response.getErrorMessage());
        }
        SveaCredential sc = null;
        ListOfSveaCredentials result = new ListOfSveaCredentials();
        List<SveaCredential> lsc = result.getCredentials();
        if (response.getClients() != null) {
            ArrayOfClientData alist = response.getClients();
            List<ClientData> list = alist.getClientData();
            TreeMap invoiceCreds = new TreeMap();
            for (ClientData cd : list) {
                sc = this.convert(cd);
                sc.setUsername(username);
                sc.setPassword(password);
                sc.createDefaultAccountMap();
                if ("invoice".equalsIgnoreCase(sc.getAccountType())) {
                    sc.setIncludeCardPayments(true);
                }
                lsc.add(sc);
            }
        }
        return result;
    }

    private SveaCredential convert(ClientData cd) {
        SveaCredential sc = new SveaCredential();
        sc.setAccountNo(cd.getClientId().toString());
        sc.setCountryCode(cd.getCountry());
        sc.setCurrency(cd.getCurrency());
        sc.setAccountType(SveaCredential.AGREEMENT_TYPE_MAP.get(cd.getAgreementType()));
        return sc;
    }

    public DeliveryResponse deliverOrder(long sveaOrderId, OrderType ot, Integer printType) {
        DeliveryRequest req = new DeliveryRequest();
        req.setAuthentication(this.auth);
        req.setInvoiceDistributionType(InvoiceDistributionType.NOT_DEFINED);
        ArrayOfDeliverOrderInformation aa = new ArrayOfDeliverOrderInformation();
        req.setOrdersToDeliver(aa);
        List<DeliverOrderInformation> ol = aa.getDeliverOrderInformation();
        DeliverOrderInformation doi = new DeliverOrderInformation();
        doi.setSveaOrderId(sveaOrderId);
        doi.setOrderType(ot);
        doi.setPrintType(printType);
        doi.setClientId(Long.parseLong(this.cre.getAccountNo()));
        ol.add(doi);
        DeliveryResponse dr = this.adminServicePort.deliverOrders(req);
        return dr;
    }

    public void enrichFromPaymentPlan(String paymentTypeReference, List<PaymentReportDetail> details, boolean enrichAll, boolean skipTaxId) throws Exception {
        if (details == null || details.size() == 0) {
            return;
        }
        SearchPaymentPlansRequest req = new SearchPaymentPlansRequest();
        req.setAuthentication(this.auth);
        SearchPaymentPlanSorting sort = new SearchPaymentPlanSorting();
        sort.setSortDirection(SortDirection.DESCENDING);
        sort.setSortPaymentPlanProperty(SortPaymentPlanProperty.SVEA_ORDER_ID);
        req.setSearchPaymentPlanSorting(sort);
        SearchPaymentPlanFilter filter = new SearchPaymentPlanFilter();
        ArrayOflong clientIds = new ArrayOflong();
        List<Long> ids = clientIds.getLong();
        ids.add(Long.parseLong(this.cre.getAccountNo()));
        filter.setClientIds(clientIds);
        ArrayOfPaymentPlanStatus aops = new ArrayOfPaymentPlanStatus();
        List<PaymentPlanStatus> pps = aops.getPaymentPlanStatus();
        filter.setAcceptedStatus(aops);
        pps.add(PaymentPlanStatus.CANCELLED);
        pps.add(PaymentPlanStatus.FINISHED);
        pps.add(PaymentPlanStatus.ERROR);
        pps.add(PaymentPlanStatus.WAITING_FOR_CONTRACT);
        pps.add(PaymentPlanStatus.WAITING_TO_BE_SENT);
        filter.setTextMatchType(TextMatchType.CONTRACT_NUMBER);
        req.setSearchPaymentPlanFilter(filter);
        for (PaymentReportDetail d : details) {
            List<PaymentPlanListItem> rows;
            if (!enrichAll && (d.getEnrichFromInvoice() == null || !d.getEnrichFromInvoice().booleanValue())) continue;
            filter.setTextMatch(d.getInvoiceId());
            SearchPaymentPlansResponse2 response = this.adminServicePort.searchPaymentPlans(req);
            if (response.getResultCode() != 0) {
                throw new Exception(response.getErrorMessage());
            }
            if (response.getPaymentPlanListItems() == null || response.getPaymentPlanListItems().getPaymentPlanListItem() == null || (rows = response.getPaymentPlanListItems().getPaymentPlanListItem()).size() <= 0) continue;
            PaymentPlanListItem pp = rows.get(0);
            this.enrichWithPaymentPlanDetails(d, pp, this.cre.isSkipTaxId());
        }
    }

    public void enrichFromInvoice(String paymentTypeReference, List<PaymentReportDetail> details, boolean enrichAll, boolean skipTaxId, boolean skipEmail) throws Exception {
        if (details == null || details.size() == 0) {
            return;
        }
        ArrayList<String> invoicesToRetrieve = new ArrayList<String>();
        ArrayList<PaymentReportDetail> paymentDetails = new ArrayList<PaymentReportDetail>();
        for (PaymentReportDetail d : details) {
            if (d.getInvoiceId() == null || d.getInvoiceId().trim().length() <= 0 || !enrichAll && (d.getEnrichFromInvoice() == null || !d.getEnrichFromInvoice().booleanValue())) continue;
            invoicesToRetrieve.add(d.getInvoiceId());
            paymentDetails.add(d);
        }
        if (invoicesToRetrieve.size() > 0) {
            GetInvoicesRequest req = new GetInvoicesRequest();
            req.setAuthentication(this.auth);
            ArrayOfGetInvoiceInformation aa = new ArrayOfGetInvoiceInformation();
            req.setInvoicesToRetrieve(aa);
            List<GetInvoiceInformation> il = aa.getGetInvoiceInformation();
            for (String invoiceNo : invoicesToRetrieve) {
                GetInvoiceInformation ii = new GetInvoiceInformation();
                ii.setClientId(Long.parseLong(paymentTypeReference));
                ii.setInvoiceId(Long.parseLong(invoiceNo));
                il.add(ii);
            }
            GetInvoicesResponse2 res = this.adminServicePort.getInvoices(req);
            if (res.getResultCode() != 0 && res.getResultCode() != 24001) {
                throw new Exception(res.getResultCode() + " : " + res.getErrorMessage());
            }
            ArrayOfInvoice aoi = res.getInvoices();
            if (aoi != null) {
                List<Invoice> invoiceList = aoi.getInvoice();
                TreeMap<String, Invoice> invoiceMap = new TreeMap<String, Invoice>();
                for (Invoice i : invoiceList) {
                    invoiceMap.put(new Long(i.getInvoiceId()).toString(), i);
                }
                for (PaymentReportDetail d : paymentDetails) {
                    this.enrichWithInvoiceDetails(d, (Invoice)invoiceMap.get(d.getInvoiceId()), skipTaxId, skipEmail);
                }
            }
        }
    }

    public PaymentReportDetail enrichWithPaymentPlanDetails(PaymentReportDetail dst, PaymentPlanListItem src, boolean skipTaxId) {
        if (dst.getPayerName() == null || dst.getPayerName().trim().length() == 0) {
            dst.setPayerName(src.getCustomerName());
        }
        if (!skipTaxId) {
            dst.setPayerOrgNo(src.getNationalIdNumber());
        }
        if (dst.getClientOrderNo() == null || dst.getClientOrderNo().trim().length() == 0) {
            dst.setClientOrderNo(src.getClientOrderId());
        }
        dst.setOrderId(Long.toString(src.getSveaOrderId()));
        return dst;
    }

    public PaymentReportDetail enrichWithInvoiceDetails(PaymentReportDetail dst, Invoice src, boolean skipTaxId, boolean skipEmail) {
        if (src == null) {
            return dst;
        }
        CustomerIdentity c = src.getCustomer();
        if (c != null) {
            if (!skipTaxId) {
                dst.setPayerOrgNo(c.getNationalIdNumber());
            }
            if (!skipEmail && c.getEmail() != null && c.getEmail().trim().length() > 0) {
                dst.addReference("email", c.getEmail());
            }
            if (!skipEmail && c.getZipCode() != null) {
                dst.addReference("zipcode", c.getZipCode());
            }
            if (dst.getPayerName() == null || dst.getPayerName().trim().length() == 0) {
                dst.setPayerName(c.getFullName());
            }
        }
        if (dst.getCustomerId() == null || dst.getCustomerId().trim().length() == 0) {
            dst.setCustomerId(Long.toString(src.getCustomerId()));
        }
        if (dst.getClientOrderNo() == null || dst.getClientOrderNo().trim().length() == 0) {
            dst.setClientOrderNo(src.getClientOrderId());
        }
        dst.setOrderId(Long.toString(src.getSveaOrderId()));
        if (src.getClientReference() != null && src.getClientReference().trim().length() > 0) {
            dst.addReference("client_ref", src.getClientReference());
        }
        return dst;
    }

    public static void updateUndefinedFeeAccountsFromCredential(SveaCredential cre, PaymentReportGroup grp) {
        if (cre == null || grp == null || grp.isEmpty()) {
            return;
        }
        if (grp.getPaymentReportDetail() != null) {
            for (PaymentReportDetail d : grp.getPaymentReportDetail()) {
                WebpayAdminClient.updateFeeAccountsIfNotSet(cre, d.getFees());
            }
        }
        WebpayAdminClient.updateFeeAccountsIfNotSet(cre, grp.getTotalInvoiceFees());
        WebpayAdminClient.updateFeeAccountsIfNotSet(cre, grp.getTotalOtherFees());
    }

    private static void updateFeeAccountsIfNotSet(SveaCredential cre, List<FeeDetail> fees) {
        if (fees == null) {
            return;
        }
        for (FeeDetail f : fees) {
            if (f.getAccountNr() != null && f.getAccountNr().trim().length() != 0) continue;
            f.setAccountNr(cre.getRemappedAccountFor(f.getFeeType()));
        }
    }

    static {
        try {
            URL url = WebpayAdminClient.class.getClassLoader().getResource("logging.properties");
            if (url != null) {
                System.setProperty("java.util.logging.config.file", url.getFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

