/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin.report;

import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportFactory;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpay.common.reconciliation.VatType;
import com.svea.webpayadmin.WebpayAdminBase;
import com.svea.webpayadminservice.client.ArrayOfSpecificationRow;
import com.svea.webpayadminservice.client.GetSpecificationReportRequest;
import com.svea.webpayadminservice.client.GetSpecificationReportResponse2;
import com.svea.webpayadminservice.client.SpecificationReportType;
import com.svea.webpayadminservice.client.SpecificationRow;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class WebpayCardReportFactory
implements PaymentReportFactory {
    public String retryExpression = "(.*?)(\\-WRet)";
    public Pattern retryPattern;
    private WebpayAdminBase svea;
    protected SveaCredential cre;
    private SpecificationReportType specificationReportType = SpecificationReportType.CARD;

    public WebpayCardReportFactory() {
        this.retryPattern = Pattern.compile(this.retryExpression);
    }

    @Override
    public SveaCredential getSveaCredential() {
        return this.cre;
    }

    @Override
    public PaymentReportFactory init(SveaCredential aCre) {
        this.cre = aCre;
        this.svea = new WebpayAdminBase();
        this.svea.initCredentials(aCre);
        return this;
    }

    public SpecificationReportType getSpecificationReportType() {
        return this.specificationReportType;
    }

    public void setSpecificationReportType(SpecificationReportType specificationReportType) {
        this.specificationReportType = specificationReportType;
    }

    @Override
    public List<PaymentReportGroup> createBankStatementLines(PaymentReport report, Date fromDate, Date untilDate) throws Exception {
        ArrayList<PaymentReportGroup> resultList = new ArrayList<PaymentReportGroup>();
        Calendar fromCal = Calendar.getInstance();
        if (fromDate != null) {
            fromCal.setTime(fromDate);
        }
        Calendar untilCal = Calendar.getInstance();
        if (untilDate != null) {
            untilCal.setTime(untilDate);
        } else {
            untilCal.setTime(fromDate);
        }
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 0);
        fromCal.set(14, 0);
        untilCal.set(11, 0);
        untilCal.set(12, 0);
        untilCal.set(13, 0);
        untilCal.set(14, 0);
        Timestamp date = null;
        PaymentReportGroup gr = null;
        while (!fromCal.after(untilCal)) {
            String reconcileAcct;
            date = new Timestamp(fromCal.getTimeInMillis());
            fromCal.add(5, 1);
            gr = new PaymentReportGroup();
            String dstAcct = this.cre.getRemappedAccountFor("cash");
            if (dstAcct != null) {
                gr.setDstAcct(dstAcct);
            }
            if ((reconcileAcct = this.cre.getRemappedAccountFor("reconcile")) != null) {
                gr.setReconcileAcct(reconcileAcct);
            }
            gr.setReconciliationDate(new Date(date.getTime()));
            gr.setPaymentType(this.cre.getAccountType());
            gr.setPaymentTypeReference(this.cre.getAccountNo());
            gr.setVatAcct(this.cre.getRemappedAccountFor("vat"));
            gr.setCurrency(this.cre.getCurrency());
            List<SpecificationRow> invoices = this.getSpecificationReport(date);
            for (SpecificationRow invoice : invoices) {
                if (!invoice.isSveaIsPaymentFacilitator().booleanValue()) continue;
                String clientOrderNumber = invoice.getClientOrderNumber();
                Matcher m = this.retryPattern.matcher(clientOrderNumber);
                if (m.matches()) {
                    clientOrderNumber = m.group(1);
                }
                PaymentReportDetail d = new PaymentReportDetail();
                d.setClientOrderNo(clientOrderNumber);
                d.setPaymentId(Long.toString(invoice.getTransactionId()));
                d.setPaidAmt(invoice.getAmount().doubleValue());
                if (invoice.getFee().signum() != 0) {
                    FeeDetail fee = new FeeDetail("credit", invoice.getFee().doubleValue(), 0.0);
                    fee.setAccountNr(this.cre.getRemappedAccountFor(fee.getFeeType()));
                    fee.setFeeVat(fee.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), fee.getFeeType(), "creditcard", date, this.cre.isCompany())));
                    d.addFee(fee);
                }
                d.calculateReceivedAmt();
                gr.addDetail(d);
            }
            gr.updateTotalFees();
            gr.setTotalVatAmt(FeeDetail.getVatSum(gr.getTotalInvoiceFees()));
            FeeDetail.remapFeeAccounts(this.cre, gr.getTotalOtherFees());
            FeeDetail.remapFeeAccounts(this.cre, gr.getTotalInvoiceFees());
            report.addPaymentReportGroup(gr);
            resultList.add(gr);
        }
        return resultList;
    }

    public List<SpecificationRow> getSpecificationReport(Timestamp date) throws Exception {
        GetSpecificationReportRequest request = new GetSpecificationReportRequest();
        request.setClientId(new Long(this.cre.getAccountNo()));
        request.setAuthentication(this.svea.getAuth());
        request.setReportType(this.specificationReportType);
        XMLGregorianCalendar xdate = this.convert(date);
        request.setFromDate(xdate);
        request.setToDate(xdate);
        GetSpecificationReportResponse2 response = this.svea.getServicePort().getSpecificationReport(request);
        if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
            throw new Exception("Can't read invoice report for account " + this.cre.getAccountNo() + ": " + response.getErrorMessage());
        }
        ArrayOfSpecificationRow res = response.getRows();
        return res != null ? res.getSpecificationRow() : null;
    }

    private XMLGregorianCalendar convert(Timestamp date) throws DatatypeConfigurationException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(date.getTime());
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(11, 0);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
    }
}

