/*
 * Decompiled with CFR 0.152.
 */
package com.svea.webpayadmin.report;

import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.FeeDetail;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportFactory;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpay.common.reconciliation.VatType;
import com.svea.webpayadmin.WebpayAdminBase;
import com.svea.webpayadmin.report.ReportFactoryBase;
import com.svea.webpayadminservice.client.AccountCreditRegressReportDataRow;
import com.svea.webpayadminservice.client.AccountCreditRegressReportRequest;
import com.svea.webpayadminservice.client.AccountCreditRegressReportResponse;
import com.svea.webpayadminservice.client.AccountingAgreementType25ReportDataRow;
import com.svea.webpayadminservice.client.AccountingAgreementType25ReportRequest;
import com.svea.webpayadminservice.client.AccountingAgreementType25ReportResponse;
import com.svea.webpayadminservice.client.ArrayOfAccountCreditRegressReportDataRow;
import com.svea.webpayadminservice.client.ArrayOfAccountingAgreementType25ReportDataRow;
import com.svea.webpayadminservice.client.Authentication;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class WebpayCreditReportFactory
extends ReportFactoryBase
implements PaymentReportFactory {
    @Override
    public PaymentReportFactory init(SveaCredential aCre) {
        this.cre = aCre;
        this.svea = new WebpayAdminBase();
        this.svea.initCredentials(aCre);
        return this;
    }

    @Override
    public List<PaymentReportGroup> createBankStatementLines(PaymentReport report, Date fromDate, Date untilDate) throws Exception {
        ArrayList<PaymentReportGroup> resultList = new ArrayList<PaymentReportGroup>();
        Calendar fromCal = Calendar.getInstance();
        if (fromDate != null) {
            fromCal.setTime(fromDate);
        }
        Calendar untilCal = Calendar.getInstance();
        if (untilDate != null) {
            untilCal.setTime(untilDate);
        } else {
            untilCal.setTime(fromDate);
        }
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 0);
        fromCal.set(14, 0);
        untilCal.set(11, 0);
        untilCal.set(12, 0);
        untilCal.set(13, 0);
        untilCal.set(14, 0);
        Timestamp date = null;
        PaymentReportGroup gr = null;
        while (!fromCal.after(untilCal)) {
            String reconcileAcct;
            date = new Timestamp(fromCal.getTimeInMillis());
            fromCal.add(5, 1);
            gr = new PaymentReportGroup();
            String dstAcct = this.cre.getRemappedAccountFor("cash");
            if (dstAcct != null) {
                gr.setDstAcct(dstAcct);
            }
            if ((reconcileAcct = this.cre.getRemappedAccountFor("reconcile")) != null) {
                gr.setReconcileAcct(reconcileAcct);
            }
            gr.setReconciliationDate(new Date(date.getTime()));
            gr.setPaymentType(this.cre.getAccountType());
            gr.setPaymentTypeReference(this.cre.getAccountNo());
            gr.setVatAcct(this.cre.getRemappedAccountFor("vat"));
            gr.setCurrency(this.cre.getCurrency());
            try {
                this.fillDeviations(gr, date);
                Double totalReceivedAmount = gr.getTotalReceivedAmt();
                Double deviationAmount = gr.calculateReceivedAmt();
                gr.setTotalReceivedAmt(deviationAmount);
                this.fillAccountingAgreements(gr, date);
                this.fillAccountingAgreementRegressions(gr, date);
                gr.setTotalReceivedAmt(totalReceivedAmount);
                gr.updateTotalFees();
                gr.setTotalVatAmt(FeeDetail.getVatSum(gr.getTotalInvoiceFees()));
                FeeDetail.remapFeeAccounts(this.cre, gr.getTotalOtherFees());
                FeeDetail.remapFeeAccounts(this.cre, gr.getTotalInvoiceFees());
                report.addPaymentReportGroup(gr);
                resultList.add(gr);
                FeeDetail rounding = gr.calculateRoundingFee(gr.getTotalReceivedAmt(), null);
                if (rounding != null && !rounding.getFeeTotal().equals(gr.getEndingBalance())) {
                    rounding.setAccountNr(this.cre.getAccountMap().get(rounding.getFeeType()));
                    PaymentReportDetail d = new PaymentReportDetail();
                    d.addFee(rounding);
                    d.setPaidAmt(0.0);
                    d.setReceivedAmt(-rounding.getFeeTotal().doubleValue());
                    gr.addDetail(d);
                    gr.updateTotalFees();
                }
                gr.cancelOtherFees("credit", new String[]{"deviations", "rounding"});
                gr.replaceDeviationsAsRounding();
                gr.roundVatToGroupValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("WebpayCreditReportFactory: " + e.getMessage());
            }
        }
        return resultList;
    }

    private void fillAccountingAgreementRegressions(PaymentReportGroup gr, Timestamp date) throws Exception {
        List<AccountCreditRegressReportDataRow> creditinvoices = this.getCreditRegressReport(date);
        for (AccountCreditRegressReportDataRow invoice : creditinvoices) {
            PaymentReportDetail d = new PaymentReportDetail();
            d.setClientOrderNo(invoice.getCreditForOrderId());
            d.setReceivedAmt(invoice.getAmount().doubleValue());
            d.setPaidAmt(d.getReceivedAmt());
            d.setCustomerId(Integer.toString(invoice.getCreditForCustomerId()));
            d.setPayerName(invoice.getCustomerName());
            if (invoice.getCheckoutOrderId() != null) {
                d.setCheckoutOrderId(invoice.getCheckoutOrderId().toString());
            }
            if (invoice.getSveaOrderCreationDate() != null) {
                d.setOrderDate(JsonUtil.dfmt.format(invoice.getSveaOrderCreationDate().toGregorianCalendar().getTime()));
            }
            if (invoice.getSveaOrderId() != null) {
                d.setOrderId(invoice.getSveaOrderId().toString());
            }
            d.setInvoiceId(Integer.toString(invoice.getInvoiceId()));
            gr.addDetail(d);
        }
    }

    private void fillAccountingAgreements(PaymentReportGroup gr, Timestamp date) throws Exception {
        List<AccountingAgreementType25ReportDataRow> invoices = this.getCreditReport(date);
        for (AccountingAgreementType25ReportDataRow invoice : invoices) {
            double feeAmt;
            PaymentReportDetail d = new PaymentReportDetail();
            d.setClientOrderNo(invoice.getReferenceNumber());
            d.setReceivedAmt(invoice.getPaidAmount().doubleValue());
            d.setPaidAmt(invoice.getAmount().doubleValue());
            d.setCustomerId(Integer.toString(invoice.getAccountNumber()));
            d.setPayerName(invoice.getName());
            if (invoice.getCheckoutOrderId() != null) {
                d.setCheckoutOrderId(invoice.getCheckoutOrderId().toString());
            }
            if (invoice.getSveaOrderCreationDate() != null) {
                d.setOrderDate(JsonUtil.dfmt.format(invoice.getSveaOrderCreationDate().toGregorianCalendar().getTime()));
            }
            if (invoice.getSveaOrderId() != null) {
                d.setOrderId(invoice.getSveaOrderId().toString());
            }
            if ((feeAmt = d.getPaidAmt() - d.getReceivedAmt()) != 0.0) {
                FeeDetail fee = new FeeDetail();
                if (gr.getReconciliationDateAsDate().after(JsonUtil.dfmt.parse("2019-02-15"))) {
                    fee.setFeeType("adm");
                } else {
                    fee.setFeeType("credit");
                }
                fee.setFee(feeAmt);
                FeeDetail.remapFeeAccount(this.cre, fee);
                fee.calculateVat(VatType.getVatRate(this.cre.getCountryCode(), fee.getFeeType(), "account-credit", date, this.cre.isCompany()));
                d.addFee(fee);
            }
            d.calculateReceivedAmt();
            gr.addDetail(d);
        }
    }

    public List<AccountingAgreementType25ReportDataRow> getCreditReport(Timestamp date) throws Exception {
        AccountingAgreementType25ReportRequest request = new AccountingAgreementType25ReportRequest();
        request.setClientId(new Long(this.cre.getAccountNo()));
        Authentication auth = new Authentication();
        auth.setUsername(this.cre.getUsername());
        auth.setPassword(this.cre.getPassword());
        request.setAuthentication(auth);
        XMLGregorianCalendar xdate = this.convert(date);
        request.setFromDate(xdate);
        request.setToDate(xdate);
        AccountingAgreementType25ReportResponse response = this.svea.getServicePort().generateAccountingAgreementType25Report(request);
        if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
            throw new Exception("Can't read invoice report for account " + this.cre.getAccountNo() + ": " + response.getErrorMessage());
        }
        ArrayOfAccountingAgreementType25ReportDataRow res = response.getRows();
        return res != null ? res.getAccountingAgreementType25ReportDataRow() : null;
    }

    public List<AccountCreditRegressReportDataRow> getCreditRegressReport(Timestamp date) throws Exception {
        String[] reportNames = new String[]{"AccountCredit", "Invoice", "PaymentPlan"};
        AccountCreditRegressReportRequest request = new AccountCreditRegressReportRequest();
        request.setClientId(new Long(this.cre.getAccountNo()));
        Authentication auth = new Authentication();
        auth.setUsername(this.cre.getUsername());
        auth.setPassword(this.cre.getPassword());
        request.setAuthentication(auth);
        XMLGregorianCalendar xdate = this.convert(date);
        request.setFromDate(xdate);
        request.setToDate(xdate);
        ArrayList<AccountCreditRegressReportDataRow> result = new ArrayList<AccountCreditRegressReportDataRow>();
        AccountCreditRegressReportResponse response = null;
        ArrayOfAccountCreditRegressReportDataRow res = null;
        for (String reportName : reportNames) {
            request.setReportName(reportName);
            response = this.svea.getServicePort().generateAccountCreditRegressReport(request);
            if (response.getErrorMessage() != null && response.getErrorMessage().trim().length() > 0) {
                throw new Exception("Can't read invoice regress report for account " + this.cre.getAccountNo() + ": " + response.getErrorMessage());
            }
            res = response.getRows();
            if (res == null || res.getAccountCreditRegressReportDataRow() == null) continue;
            result.addAll(res.getAccountCreditRegressReportDataRow());
        }
        return result;
    }
}

