/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.sveawebpay;

import com.svea.businessobjects.paymentgw.SveaPmtGwBusinessObjectFactory;
import com.svea.businessobjects.pmtadmin.SveaPmtAdminBusinessObjectFactory;
import com.svea.businessobjects.sveaadmin.SveaAdminBusinessObjectFactory;
import com.svea.businessobjects.sveaadmin.SveaAdminConverter;
import com.svea.webpay.common.auth.ListOfSveaCredentials;
import com.svea.webpay.common.auth.SveaCredential;
import com.svea.webpay.common.conv.JsonUtil;
import com.svea.webpay.common.reconciliation.PaymentReport;
import com.svea.webpay.common.reconciliation.PaymentReportDetail;
import com.svea.webpay.common.reconciliation.PaymentReportGroup;
import com.svea.webpayadmin.WebpayAdminClient;
import com.svea.webpayadmin.WebpayAdminClientMain;
import com.svea.webpayadminservice.client.CreateOrderRequest;
import com.svea.webpayadminservice.client.CreateOrderResponse;
import com.svea.webpayadminservice.client.DeliveryResponse;
import com.svea.webpayadminservice.client.OrderType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.camel.Header;
import org.notima.api.webpay.pmtapi.PmtApiClientRF;
import org.notima.generic.businessobjects.Invoice;
import org.notima.generic.businessobjects.Order;
import org.notima.generic.businessobjects.Payment;

public class WebpayAdminCamelClient {
    private PaymentReport report;
    private String orgNo;
    private String jsonFile;
    private List<SveaCredential> credentials;
    private Map<String, String> merchantIds;
    private Map<String, String> accountToMerchantIdMap = new TreeMap<String, String>();

    public static WebpayAdminCamelClient createClientFromJsonBody(@Header(value="orgNo") String orgNo, String body) {
        if (body == null || body.trim().length() == 0) {
            return null;
        }
        WebpayAdminCamelClient client = new WebpayAdminCamelClient();
        if (orgNo != null && (client.getOrgNo() == null || client.getOrgNo().trim().length() == 0)) {
            client.setOrgNo(orgNo);
        }
        client.setCredentialsFromJsonBody(body);
        return client;
    }

    public WebpayAdminCamelClient() {
        this.report = new PaymentReport();
        this.credentials = new ArrayList<SveaCredential>();
    }

    public static WebpayAdminCamelClient createClientFromIdentity(@Header(value="identityUser") String username, @Header(value="identityPass") String password) throws Exception {
        if (username == null || password == null) {
            return null;
        }
        WebpayAdminClient adminClient = new WebpayAdminClient();
        WebpayAdminCamelClient result = new WebpayAdminCamelClient();
        ListOfSveaCredentials list = adminClient.getCredentialsByIdentity(username, password);
        if (list != null) {
            result.credentials = list.getCredentials();
        }
        return result;
    }

    public static WebpayAdminCamelClient buildClientFromFile(String jsonFile) throws Exception {
        String line;
        if (jsonFile == null) {
            throw new Exception("No jsonFile specified. Set property jsonFile");
        }
        File f = new File(jsonFile);
        if (!f.exists()) {
            throw new Exception("Can't find jsonFile " + jsonFile);
        }
        BufferedReader br = new BufferedReader(new FileReader(f));
        StringBuffer fileContent = new StringBuffer();
        while ((line = br.readLine()) != null) {
            fileContent.append(line);
        }
        br.close();
        return WebpayAdminCamelClient.createClientFromJsonBody(null, fileContent.toString());
    }

    public WebpayAdminCamelClient setFromJsonBody(@Header(value="jsonConfig") String json) {
        this.setCredentialsFromJsonBody(json);
        return this;
    }

    public WebpayAdminCamelClient setOrgNo(@Header(value="orgNo") String orgNo) {
        this.orgNo = orgNo;
        this.credentials.clear();
        this.report = new PaymentReport();
        return this;
    }

    public String getOrgNo() {
        return this.orgNo;
    }

    public void setCredentialsFromJsonBody(String body) {
        ListOfSveaCredentials credList = (ListOfSveaCredentials)JsonUtil.buildGson().fromJson(body, ListOfSveaCredentials.class);
        this.credentials = credList.getCredentials();
    }

    public List<SveaCredential> getCredentials() {
        return this.credentials;
    }

    public static void removeAllCredentialsBut(@Header(value="client") WebpayAdminCamelClient client, @Header(value="credAccountNo") String accountNo) {
        if (client.credentials == null || accountNo == null) {
            return;
        }
        SveaCredential keepMe = null;
        for (SveaCredential sc : client.credentials) {
            if (!accountNo.equals(sc.getAccountNo())) continue;
            keepMe = sc;
            break;
        }
        client.credentials.clear();
        if (keepMe != null) {
            client.credentials.add(keepMe);
        }
    }

    public static void removeCredential(@Header(value="client") WebpayAdminCamelClient client, @Header(value="credAccountNo") String accountNo) {
        if (client.credentials == null || accountNo == null) {
            return;
        }
        SveaCredential removeMe = null;
        for (SveaCredential sc : client.credentials) {
            if (!accountNo.equals(sc.getAccountNo())) continue;
            removeMe = sc;
            break;
        }
        if (removeMe != null) {
            client.credentials.remove(removeMe);
        }
    }

    public static void overrideOptions(@Header(value="client") WebpayAdminCamelClient client, @Header(value="credAccountNo") String accountNo, @Header(value="includeKickbacks") String includeKickbacks, @Header(value="skipTaxId") String skipTaxId, @Header(value="skipEmail") String skipEmail, @Header(value="enrichFromInvoice") String enrichFromInvoice) {
        if (client.credentials == null || accountNo == null) {
            return;
        }
        if (includeKickbacks == null && skipTaxId == null && skipEmail == null && enrichFromInvoice == null) {
            return;
        }
        SveaCredential credential = null;
        for (SveaCredential sc : client.credentials) {
            if (!accountNo.equals(sc.getAccountNo())) continue;
            credential = sc;
            break;
        }
        if (credential != null) {
            if (includeKickbacks != null) {
                credential.setIncludeKickbacks("Y".equalsIgnoreCase(includeKickbacks));
            }
            if (skipTaxId != null) {
                credential.setSkipTaxId("Y".equalsIgnoreCase(skipTaxId));
            }
            if (skipEmail != null) {
                credential.setSkipEmail("Y".equalsIgnoreCase(skipEmail));
            }
            if (enrichFromInvoice != null) {
                credential.setEnrichFromInvoice("Y".equalsIgnoreCase(enrichFromInvoice));
            }
        }
    }

    public SveaCredential addCredentials(@Header(value="accountNo") String accountNo, @Header(value="username") String username, @Header(value="password") String password) {
        SveaCredential sc = this.getCredentialFromAccountNo(accountNo);
        if (sc == null) {
            sc = new SveaCredential();
            sc.setAccountNo(accountNo);
            this.credentials.add(sc);
        }
        sc.setUsername(username);
        sc.setPassword(password);
        return sc;
    }

    public Invoice<?> getInvoice(String accountNo, String invoiceNo) throws Exception {
        Invoice result = null;
        SveaCredential cr = this.getCredentialFromAccountNo(accountNo);
        if (cr != null) {
            SveaAdminBusinessObjectFactory bo = new SveaAdminBusinessObjectFactory();
            bo.initCredentials(cr);
            result = bo.lookupInvoice(invoiceNo);
        }
        return result;
    }

    public Order<?> getOrder(@Header(value="accountNo") String accountNo, @Header(value="orderId") String orderId, @Header(value="includeCancelledRows") Boolean includeCancelledRows) throws Exception {
        Order result = null;
        SveaCredential cr = this.getCredentialFromAccountNo(accountNo);
        if (cr != null) {
            SveaAdminBusinessObjectFactory bo = new SveaAdminBusinessObjectFactory();
            if (includeCancelledRows != null) {
                bo.setSetting(SveaAdminBusinessObjectFactory.SETTING_INCLUDE_CANCELLED_ROWS, includeCancelledRows.toString());
            }
            bo.initCredentials(cr);
            result = bo.lookupOrder(orderId);
        }
        return result;
    }

    public Order<?> getOrderByClientOrderId(@Header(value="accountNo") String accountNo, @Header(value="clientOrderId") String clientOrderId) throws Exception {
        Order result = null;
        if (clientOrderId == null) {
            return null;
        }
        SveaCredential cr = this.getCredentialFromAccountNo(accountNo);
        if (cr != null) {
            SveaAdminBusinessObjectFactory bo = new SveaAdminBusinessObjectFactory();
            bo.initCredentials(cr);
            result = bo.findByClientOrderId(clientOrderId);
        }
        return result;
    }

    public Order<?> getOrderByCheckoutOrderId(@Header(value="accountNo") String accountNo, @Header(value="checkoutOrderId") String checkoutOrderId) throws Exception {
        SveaCredential cr;
        SveaPmtAdminBusinessObjectFactory sof = new SveaPmtAdminBusinessObjectFactory();
        List<SveaCredential> crList = this.getCheckoutCredentials(accountNo);
        SveaCredential sveaCredential = cr = crList.size() > 0 ? crList.get(0) : null;
        if (cr == null) {
            throw new Exception("No credentials configured for fetching orders using checkoutOrderId.");
        }
        Order result = null;
        for (SveaCredential ss : crList) {
            sof.addCredential(ss.getServer(), ss.getOrgNo(), ss.getMerchantId(), ss.getSecretWord());
        }
        result = sof.lookupOrder(checkoutOrderId);
        return result;
    }

    public Order<?> getOrderByTransactionId(@Header(value="accountNo") String accountNo, @Header(value="transactionId") String transactionId) throws Exception {
        SveaPmtGwBusinessObjectFactory sof = new SveaPmtGwBusinessObjectFactory();
        SveaCredential cr = this.getCredentialFromAccountNo(accountNo);
        if (cr == null || cr.getCardMerchantId() == null) {
            throw new Exception("No credentials configured for fetching orders using transactionId [" + transactionId + "] for accountNo [" + accountNo + "].");
        }
        sof.init(Integer.valueOf(Integer.parseInt(cr.getCardMerchantId())), cr.getCardSecretWord());
        Order result = sof.lookupOrder(transactionId);
        return result;
    }

    public CreateOrderResponse createOrder(@Header(value="accountNo") String accountNo, Order<?> src) throws Exception {
        CreateOrderResponse result = null;
        SveaCredential cr = this.getCredentialFromAccountNo(accountNo);
        if (cr != null) {
            SveaAdminBusinessObjectFactory bo = new SveaAdminBusinessObjectFactory();
            bo.initCredentials(cr);
            CreateOrderRequest req = bo.toSveaCreateOrderRequest(src, null);
            result = bo.getAdminClient().createOrder(req);
        }
        return result;
    }

    public SveaCredential getCredentialFromAccountNo(@Header(value="accountNo") String accountNo) {
        for (SveaCredential cr : this.credentials) {
            if (!accountNo.equals(cr.getAccountNo())) continue;
            return cr;
        }
        return null;
    }

    public String createJsonConfigFromServices(@Header(value="clientUsername") String username, @Header(value="clientPassword") String password) throws Exception {
        WebpayAdminClient client = new WebpayAdminClient();
        ListOfSveaCredentials result = client.getCredentialsByIdentity(username, password);
        return JsonUtil.buildGson().toJson((Object)result);
    }

    public SveaCredential getCheckoutCredential(Long merchantId) {
        if (merchantId != null) {
            Object secret;
            if (this.merchantIds != null && (secret = this.merchantIds.get(Long.toString(merchantId))) != null) {
                SveaCredential cr = new SveaCredential();
                cr.setMerchantId(Long.toString(merchantId));
                cr.setSecretWord((String)secret);
                return cr;
            }
            for (SveaCredential cr : this.credentials) {
                if (cr.getMerchantId() == null || Long.parseLong(cr.getMerchantId()) != merchantId) continue;
                return cr;
            }
        } else {
            List<SveaCredential> list = this.getCheckoutCredentials(null);
            return list.size() > 0 ? list.get(0) : null;
        }
        return null;
    }

    public void mapAccountNoToMerchantId(String accountNo, String merchantId) {
        this.accountToMerchantIdMap.put(accountNo, merchantId);
    }

    private List<SveaCredential> getCheckoutCredentials(String accountNo) {
        String merchantId;
        SveaCredential sc = null;
        ArrayList<SveaCredential> result = new ArrayList<SveaCredential>();
        if (accountNo != null && (merchantId = this.accountToMerchantIdMap.get(accountNo)) != null && (sc = this.getCheckoutCredential(Long.parseLong(merchantId))) != null) {
            result.add(sc);
            return result;
        }
        if (accountNo != null) {
            for (SveaCredential cr : this.credentials) {
                if (!accountNo.equals(cr.getAccountNo()) || cr.getMerchantId() == null || cr.getMerchantId().trim().length() <= 4 || this.hasMerchantIdInMap(cr.getMerchantId())) continue;
                result.add(cr);
                return result;
            }
        }
        for (SveaCredential cr : this.credentials) {
            if (cr.getMerchantId() == null || cr.getMerchantId().trim().length() <= 4 || this.hasMerchantIdInMap(cr.getMerchantId())) continue;
            result.add(cr);
        }
        if (this.merchantIds != null) {
            for (String mid : this.merchantIds.keySet()) {
                sc = new SveaCredential();
                sc.setMerchantId(mid);
                sc.setSecretWord(this.merchantIds.get(mid));
                result.add(sc);
            }
        }
        return result;
    }

    private boolean hasMerchantIdInMap(String merchantId) {
        if (this.merchantIds == null) {
            return false;
        }
        return this.merchantIds.containsKey(merchantId);
    }

    public String getCardMerchantId(String accountNo) {
        SveaCredential cr;
        List<SveaCredential> list = this.getCheckoutCredentials(accountNo);
        SveaCredential sveaCredential = cr = list.size() > 0 ? list.get(0) : null;
        if (cr != null) {
            return cr.getCardMerchantId();
        }
        return null;
    }

    public String deliverCheckoutOrder(Long merchantId, String checkoutOrderNo) throws Exception {
        if (this.credentials == null || this.getCheckoutCredential(merchantId) == null) {
            throw new Exception("No checkout credential");
        }
        PmtApiClientRF client = new PmtApiClientRF();
        SveaCredential cr = this.getCheckoutCredential(merchantId);
        client.init(cr.getServer(), cr.getOrgNo(), cr.getMerchantId(), cr.getSecretWord());
        String result = client.deliverCompleteOrder(Long.valueOf(Long.parseLong(checkoutOrderNo)));
        return result;
    }

    public DeliveryResponse deliverOrder(@Header(value="accountNo") String accountNo, @Header(value="orderType") String orderType, @Header(value="orderNo") String orderNo) throws Exception {
        if (this.credentials == null) {
            throw new Exception("No credentials");
        }
        DeliveryResponse result = null;
        SveaCredential cr = this.getCredentialFromAccountNo(accountNo);
        if (cr != null) {
            SveaAdminBusinessObjectFactory bo = new SveaAdminBusinessObjectFactory();
            bo.initCredentials(cr);
            OrderType ot = OrderType.fromValue((String)orderType);
            result = bo.deliverOrder(Long.valueOf(Long.parseLong(orderNo)), ot);
            return result;
        }
        return null;
    }

    public String getTodayMinusDaysStr(@Header(value="days") Integer days) {
        if (days == null) {
            days = 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, -days.intValue());
        String fromDateStr = JsonUtil.getDateFormat().format(cal.getTime());
        return fromDateStr;
    }

    public List<String> getReconcileDates(@Header(value="reconcileDate") String reconcileDate, @Header(value="lastReconcileDate") String lastReconcileDate) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (reconcileDate != null && reconcileDate.trim().length() > 0) {
            result.add(reconcileDate);
            return result;
        }
        if (lastReconcileDate == null || lastReconcileDate.trim().length() == 0) {
            lastReconcileDate = this.getTodayMinusDaysStr(2);
        }
        Date lastDate = JsonUtil.getDateFormat().parse(lastReconcileDate);
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        Date untilDate = cal.getTime();
        cal.setTime(lastDate);
        cal.add(5, 1);
        int dow = 0;
        while (cal.getTime().before(untilDate)) {
            dow = cal.get(7);
            if (dow != 7 && dow != 1) {
                result.add(JsonUtil.getDateFormat().format(cal.getTime()));
            }
            cal.add(5, 1);
        }
        return result;
    }

    public PaymentReport readPayments(@Header(value="orgNo") String orgNo, @Header(value="clientName") String clientName, @Header(value="fromDate") String fromDateStr, @Header(value="untilDate") String untilDateStr) throws Exception {
        if (fromDateStr == null) {
            fromDateStr = this.getTodayMinusDaysStr(2);
        }
        Date untilDate = null;
        Date fromDate = JsonUtil.getDateFormat().parse(fromDateStr);
        untilDate = untilDateStr != null ? JsonUtil.getDateFormat().parse(untilDateStr) : fromDate;
        WebpayAdminClientMain reportFactory = new WebpayAdminClientMain();
        reportFactory.setCredentials(this.credentials);
        reportFactory.initClients(false);
        reportFactory.setFromDate(fromDate);
        reportFactory.setUntilDate(untilDate);
        this.report = reportFactory.fillReport();
        this.report.setTaxId(orgNo);
        if ((this.report.getOrgName() == null || this.report.getOrgName().trim().length() == 0) && clientName != null) {
            clientName = clientName.replaceAll("\\*", "");
            this.report.setOrgName(clientName);
        }
        this.report.pruneReport();
        return this.report;
    }

    public String getFromDate() {
        if (this.report == null || this.report.getPaymentReportGroup() == null || this.report.getPaymentReportGroup().size() < 1) {
            return null;
        }
        return ((PaymentReportGroup)this.report.getPaymentReportGroup().get(0)).getReconciliationDate();
    }

    public String getReportAsJson() {
        return JsonUtil.PaymentReportToJson((PaymentReport)this.report);
    }

    public PaymentReport getReport() {
        return this.report;
    }

    public List<Payment<PaymentReportDetail>> convertPaymentGroupToPayments(PaymentReportGroup group, @Header(value="processRetryPaymentsOnly") Boolean retriesOnly, @Header(value="feesOnPaymentLevel") Boolean feesOnPaymentLevel) throws ParseException {
        SveaCredential cre = this.getCredentialFromAccountNo(group.getPaymentTypeReference());
        WebpayAdminClient.updateUndefinedFeeAccountsFromCredential((SveaCredential)cre, (PaymentReportGroup)group);
        if (feesOnPaymentLevel == null) {
            feesOnPaymentLevel = Boolean.TRUE;
        }
        SveaAdminConverter conv = new SveaAdminConverter();
        List result = conv.convert(group, retriesOnly != null ? retriesOnly : false, feesOnPaymentLevel.booleanValue());
        return result;
    }

    public Payment<?> removeNativeReference(Payment<?> detail) {
        if (detail != null) {
            detail.setNativePayment(null);
        }
        return detail;
    }

    public PaymentReportDetail markForRetry(@Header(value="paymentDetail") PaymentReportDetail paymentDetail, @Header(value="retry") Boolean retry) {
        if (paymentDetail != null) {
            paymentDetail.setRetry(retry);
        }
        return paymentDetail;
    }

    public boolean hasRetryEntries(@Header(value="paymentReport") PaymentReport report) {
        if (report == null) {
            return false;
        }
        if (report.getPaymentReportGroup() == null || report.getPaymentReportGroup().size() == 0) {
            return false;
        }
        boolean hasRetryEntries = false;
        for (PaymentReportGroup gr : report.getPaymentReportGroup()) {
            if (gr.getPaymentReportDetail() == null || gr.getPaymentReportDetail().size() == 0) continue;
            for (PaymentReportDetail d : gr.getPaymentReportDetail()) {
                if (d == null || d.getRetry() == null || !d.getRetry().booleanValue()) continue;
                gr.setProcessRetryPaymentsOnly(Boolean.TRUE);
                hasRetryEntries = true;
            }
        }
        return hasRetryEntries;
    }

    public SveaPmtAdminBusinessObjectFactory createSveaPmtAdminBusinessObjectFactory(@Header(value="serverName") String serverName, @Header(value="orgNo") String orgNo, @Header(value="merchantId") String merchantId, @Header(value="secretWord") String secretWord) {
        SveaPmtAdminBusinessObjectFactory f = new SveaPmtAdminBusinessObjectFactory();
        f.addCredential(serverName, orgNo, merchantId, secretWord);
        return f;
    }

    public String getJsonFile() {
        return this.jsonFile;
    }

    public void setJsonFile(String jsonFile) {
        this.jsonFile = jsonFile;
    }

    public Map<String, String> getMerchantIds() {
        return this.merchantIds;
    }

    public void setMerchantIds(Map<String, String> merchantIds) {
        this.merchantIds = merchantIds;
    }

    public void setCredentials(List<SveaCredential> credentials) {
        this.credentials = credentials;
    }
}

