/*
 * Decompiled with CFR 0.152.
 */
package org.notima.camel.ubl;

import oasis.names.specification.ubl.schema.xsd.creditnote_21.CreditNoteType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import org.apache.camel.Body;
import org.apache.camel.Header;
import org.notima.generic.businessobjects.Invoice;
import org.notima.generic.ubl.factory.UBL21Converter;
import org.notima.util.NotimaUtil;

public class UblCamelClient {
    public InvoiceType convertFromBusinessObjectsInvoice(Invoice src) {
        InvoiceType result = UBL21Converter.convert((Invoice)src);
        return result;
    }

    public CreditNoteType convertFromBusinessObjectsCreditNote(Invoice src) {
        CreditNoteType result = UBL21Converter.convertToCreditNote((Invoice)src);
        return result;
    }

    public InvoiceType addGlnRecipient(@Header(value="glnRecipient") String gln, @Body InvoiceType dst) {
        if (dst == null) {
            System.err.println("NOOOOOO INVOICE");
            return null;
        }
        if (gln == null || gln.trim().length() == 0) {
            return dst;
        }
        UBL21Converter.setGLNNumber((InvoiceType)dst, (String)gln);
        return dst;
    }

    public InvoiceType addPaymentMeansBg(@Header(value="bgRecipientNo") String bg, @Header(value="factoringInvoicePrefix") String invoicePrefix, @Header(value="bpDocumentNo") String factoringInvoiceNo, @Header(value="paymentTerm") String paymentTerm, @Header(value="bgRecipientName") String bgName, @Body InvoiceType dst) {
        if (dst == null) {
            System.err.println("NOOOOOO INVOICE");
            return null;
        }
        if (dst.getIDValue() == null) {
            System.err.println("NOOOOOO IDVALUE");
        }
        String invoiceRef = dst.getIDValue();
        if ("faktSveaFtg".equals(paymentTerm)) {
            String OCRsource = String.valueOf(invoicePrefix.substring(0, 5)) + NotimaUtil.fillToLength((String)factoringInvoiceNo, (boolean)true, (char)'0', (int)10);
            invoiceRef = NotimaUtil.toOCRNumberWithLengthCheck((String)OCRsource);
            dst.setID(invoiceRef);
        }
        dst = UBL21Converter.addPaymentMeansBankgiro((InvoiceType)dst, (String)bg, (String)invoiceRef, (String)bgName);
        return dst;
    }
}

