/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class BgUtil {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd");

    public static String getDateString(Date d) {
        if (d == null) {
            return "GENAST";
        }
        return dateFormat.format(d);
    }

    public static Date parseDateString(String dateStr) throws ParseException {
        if (dateStr == null || dateStr.trim().length() == 0 || "GENAST".equalsIgnoreCase(dateStr) || "000000".equals(dateStr)) {
            return null;
        }
        return dateFormat.parse(dateStr);
    }

    public static String toDigitsOnly(String cleanUp) {
        if (cleanUp == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < cleanUp.length(); ++i) {
            char c = cleanUp.charAt(i);
            if (c < '0' || c > '9') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean hasDigitsOnly(String ref) {
        if (ref == null || ref.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < ref.length(); ++i) {
            char c = ref.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String removeBlanks(String cleanUp) {
        if (cleanUp == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < cleanUp.length(); ++i) {
            char c = cleanUp.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String trimLeadingZeros(String cleanUp) {
        int i;
        if (cleanUp == null) {
            return "";
        }
        if ((cleanUp = cleanUp.trim()).length() == 0) {
            return "";
        }
        for (i = 0; i < cleanUp.length() && cleanUp.charAt(i) == '0'; ++i) {
        }
        return cleanUp.substring(i);
    }

    public static boolean validateIban(String swift, String iban) {
        boolean pass = false;
        if (swift != null && swift.trim().length() > 0 && iban != null && iban.trim().length() > 0) {
            pass = true;
        }
        return pass;
    }

    public static boolean validateBankgiro(String Bankgiro) {
        int length = BgUtil.toDigitsOnly(Bankgiro).length();
        return length > 0 && length < 10;
    }

    public static String formatBg(String digits) {
        String fmt = BgUtil.toDigitsOnly(digits);
        if ((fmt = BgUtil.trimLeadingZeros(fmt)).length() < 7 || fmt.length() > 8) {
            return digits;
        }
        if (fmt.length() == 8) {
            return fmt.substring(0, 4) + "-" + fmt.substring(4);
        }
        return fmt.substring(0, 3) + "-" + fmt.substring(3);
    }

    public static String formatPg(String digits) {
        String fmt = BgUtil.toDigitsOnly(digits);
        if ((fmt = BgUtil.trimLeadingZeros(fmt)).length() < 2) {
            return fmt;
        }
        return fmt.substring(0, fmt.length() - 1) + "-" + fmt.substring(fmt.length() - 1, fmt.length());
    }

    public static String formatTaxId(String taxId) throws ParseException {
        String taxDigits = BgUtil.toDigitsOnly(taxId);
        if (taxDigits.length() > 12) {
            throw new ParseException(taxId + " invalid.", 0);
        }
        if (taxDigits.length() == 12) {
            taxDigits = (String)taxDigits.subSequence(2, taxDigits.length() - 1);
        }
        return taxDigits;
    }

    public static String getAmountStr(double amount) {
        return BgUtil.getAmountStr(amount, 12, true);
    }

    public static String getAmountStr(double amount, int len, boolean absolute) {
        StringBuffer buf = new StringBuffer();
        long newAmount = Math.round(Math.abs(amount) * 100.0);
        buf.append(Long.toString(newAmount));
        while (buf.length() < len) {
            buf.insert(0, "0");
        }
        if (amount < 0.0 && !absolute) {
            String minusStr;
            char lastDigit = buf.charAt(buf.length() - 1);
            switch (lastDigit) {
                case '0': {
                    minusStr = "-";
                    break;
                }
                case '1': {
                    minusStr = "J";
                    break;
                }
                case '2': {
                    minusStr = "K";
                    break;
                }
                case '3': {
                    minusStr = "L";
                    break;
                }
                case '4': {
                    minusStr = "M";
                    break;
                }
                case '5': {
                    minusStr = "N";
                    break;
                }
                case '6': {
                    minusStr = "O";
                    break;
                }
                case '7': {
                    minusStr = "P";
                    break;
                }
                case '8': {
                    minusStr = "Q";
                    break;
                }
                case '9': {
                    minusStr = "R";
                    break;
                }
                default: {
                    minusStr = "E";
                }
            }
            buf.replace(buf.length() - 1, buf.length(), minusStr);
        }
        return buf.toString();
    }

    public static double parseAmountStr(String amountStr) {
        Double amount = Double.parseDouble(amountStr);
        amount = amount / 100.0;
        return amount;
    }

    public static int getLuhnDigit(double amount) {
        String amountStr = BgUtil.trimLeadingZeros(BgUtil.getAmountStr(amount, 20, true));
        return BgUtil.getLuhnDigit(amountStr);
    }

    public static int getLuhnDigit(String indata) {
        int a = 2;
        int sum = 0;
        for (int i = indata.length() - 1; i >= 0; --i) {
            int term = Character.digit(indata.charAt(i), 10) * a;
            if (term > 9) {
                term -= 9;
            }
            sum += term;
            a = 3 - a;
        }
        int tens = sum / 10 * 10;
        int subtractfrom = tens + 10;
        return (subtractfrom - sum) % 10;
    }

    public static String toOCRNumber(String indata) {
        indata = BgUtil.toDigitsOnly(indata);
        return indata + BgUtil.getLuhnDigit(indata);
    }

    public static String toOCRNumberWithLengthCheck(String indata) {
        indata = BgUtil.toDigitsOnly(indata);
        int length = indata.length() + 2;
        String ocrCode = indata + (length %= 10);
        return ocrCode + BgUtil.getLuhnDigit(ocrCode);
    }

    public static boolean isValidOCRNumber(String OCR) {
        if (OCR == null || OCR.length() == 0) {
            return false;
        }
        String ccNumber1 = BgUtil.toDigitsOnly(OCR);
        int ccLength = ccNumber1.length();
        StringBuffer buf = new StringBuffer();
        for (int i = ccLength; i != 0; --i) {
            buf.append(ccNumber1.charAt(i - 1));
        }
        String ccNumber = buf.toString();
        int sum = 0;
        for (int i = 0; i < ccLength; ++i) {
            int digit = Character.getNumericValue(ccNumber.charAt(i));
            if (i % 2 == 1 && (digit *= 2) > 9) {
                digit -= 9;
            }
            sum += digit;
        }
        return sum % 10 == 0;
    }

    public static String fillToLength(String str, boolean rightAlign, char fillChar, int len) {
        if (str == null) {
            str = "";
        }
        StringBuffer buf = new StringBuffer();
        if (str.length() > len) {
            if (rightAlign) {
                buf.append(str.substring(str.length() - len, str.length()));
            } else {
                buf.append(str.substring(0, len));
            }
            return buf.toString();
        }
        buf.append(str);
        while (buf.length() < len) {
            if (rightAlign) {
                buf.insert(0, fillChar);
                continue;
            }
            buf.append(fillChar);
        }
        return buf.toString();
    }

    public static boolean validateBankAccount(String clearing, String accountNo) {
        if (clearing == null || accountNo == null) {
            return false;
        }
        String clr = BgUtil.toDigitsOnly(clearing);
        String no = BgUtil.toDigitsOnly(accountNo);
        if (clr.length() < 4 || clr.length() > 5) {
            return false;
        }
        return no.length() >= 5 && clr.length() <= 10;
    }

    public static String getAccountString(String clearing, String accountNo) {
        String clr = BgUtil.toDigitsOnly(clearing);
        String no = BgUtil.toDigitsOnly(accountNo);
        return clr + "-" + no;
    }

    public static String onlyUSASCII(String clearupstring) {
        if (clearupstring == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        String work = clearupstring.toUpperCase();
        for (int i = 0; i < work.length(); ++i) {
            char c = work.charAt(i);
            if (c == '\u00c5' || c == '\u00c4') {
                buf.append("A");
                continue;
            }
            if (c == '\u00d6') {
                buf.append("O");
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == ',' || c == '.' || c == '-') {
                buf.append(c);
                continue;
            }
            buf.append(" ");
        }
        return buf.toString();
    }

    public static int daysFromNow(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 12);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        long then = date.getTime();
        Calendar nowCal = Calendar.getInstance();
        nowCal.set(11, 0);
        nowCal.set(12, 0);
        nowCal.set(13, 0);
        nowCal.set(14, 0);
        long now = nowCal.getTimeInMillis();
        long daysInMillis = then - now;
        long days = daysInMillis / 1000L / 60L / 60L / 24L;
        return (int)days;
    }

    public static Date addDays(Date date, int daysToAdd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, daysToAdd);
        return cal.getTime();
    }
}

