/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgHeader;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;

public class BgMaxTk01Header
extends BgHeader {
    public static final int DEFAULT_VERSION = 1;
    private int version = 1;
    private Date createDate;
    private boolean testFile;
    private static Pattern linePattern1 = Pattern.compile("01BGMAX               (\\d{2})(\\d{20})(\\w).*");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static DecimalFormat versionFormat = new DecimalFormat("00");

    public BgMaxTk01Header() {
        super("01");
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isTestFile() {
        return this.testFile;
    }

    public void setTestFile(boolean testFile) {
        this.testFile = testFile;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.version = Integer.parseInt(m.group(1));
            try {
                this.createDate = dateFormat.parse(m.group(2).substring(0, 14));
            }
            catch (ParseException pe) {
                throw new BgParseException("File date: " + m.group(2) + " not valid. ", line);
            }
            this.testFile = "T".equalsIgnoreCase(m.group(3));
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String getCurrency() {
        return null;
    }

    @Override
    public void setCurrency(String currency) {
    }

    @Override
    public Date getPayDate() {
        return this.createDate;
    }

    @Override
    public String getSenderAccount() {
        return null;
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.getTransCode());
        line.append("BGMAX               ");
        line.append(versionFormat.format(this.version));
        line.append(dateFormat.format(this.createDate));
        line.append("000000");
        line.append(this.isTestFile() ? "T" : "P");
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    @Override
    public Date getCreateDate() {
        return this.createDate;
    }
}

