/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class BgMaxTk05Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("05(\\d{10})([\\d|\\s]{10})(\\w{3}).*");
    private String recipientBg;
    private String recipientPg;
    private String currency;

    public BgMaxTk05Record() {
        super("05");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.recipientBg = BgUtil.trimLeadingZeros(m.group(1));
            this.recipientPg = BgUtil.trimLeadingZeros(m.group(2));
            this.currency = m.group(3);
            return this;
        }
        throw new BgParseException(line);
    }

    public String getRecipientBg() {
        return this.recipientBg;
    }

    public void setRecipientBg(String aRecipientBg) {
        this.recipientBg = aRecipientBg;
        if (this.recipientBg == null) {
            return;
        }
        this.recipientBg = BgUtil.toDigitsOnly(this.recipientBg);
    }

    public String getRecipientPg() {
        return this.recipientPg;
    }

    public void setRecipientPg(String recipientPg) {
        this.recipientPg = recipientPg;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.getTransCode());
        line.append(BgUtil.fillToLength(BgUtil.toDigitsOnly(this.recipientBg), true, '0', 10));
        line.append(BgUtil.fillToLength(BgUtil.toDigitsOnly(this.recipientPg), true, (char)(this.recipientPg == null || this.recipientPg.trim().length() == 0 ? 32 : 48), 10));
        line.append(BgUtil.fillToLength(this.currency, true, ' ', 3));
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }
}

