/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class BgMaxTk15Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("15(\\d{35})(\\d{8})(\\d{5})(\\d{18})(\\w{3})(\\d{8})(.*)");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
    private String toBankAccount;
    private String clearing;
    private String accountNo;
    private Date transactionDate;
    private String receiptNo;
    private double amount;
    private String currency;
    private int count;

    public BgMaxTk15Record() {
        super("15");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.toBankAccount = m.group(1);
            this.clearing = BgUtil.trimLeadingZeros(this.toBankAccount.substring(19, 23));
            this.accountNo = this.toBankAccount.substring(23, 35);
            try {
                this.transactionDate = dateFormat.parse(m.group(2));
            }
            catch (ParseException pe) {
                throw new BgParseException("Set date: " + m.group(2) + " not valid. ", line);
            }
            this.receiptNo = m.group(3);
            this.amount = BgUtil.parseAmountStr(m.group(4));
            this.currency = m.group(5);
            this.count = Integer.parseInt(m.group(6));
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.getTransCode());
        line.append(BgUtil.fillToLength(BgUtil.toDigitsOnly(this.clearing), false, '0', 4));
        line.append(BgUtil.fillToLength(BgUtil.toDigitsOnly(this.accountNo), true, '0', 31));
        line.append(dateFormat.format(this.transactionDate));
        line.append(BgUtil.fillToLength(this.receiptNo, true, '0', 5));
        line.append(BgUtil.getAmountStr(this.amount, 18, false));
        line.append(BgUtil.fillToLength(this.currency, true, 'X', 3));
        line.append(BgUtil.fillToLength(Integer.toString(this.count), true, '0', 8));
        line.append(" ");
        return line.toString();
    }

    public String getToBankAccount() {
        return this.toBankAccount;
    }

    public void setToBankAccount(String toBankAccount) {
        this.toBankAccount = toBankAccount;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(Date transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String getReceiptNo() {
        return this.receiptNo;
    }

    public void setReceiptNo(String receiptNo) {
        this.receiptNo = receiptNo;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getClearing() {
        return this.clearing;
    }

    public void setClearing(String clearing) {
        this.clearing = clearing;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }
}

