/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;
import org.notima.bg.bgmax.BgMaxReference;

public class BgMaxTk21Record
extends BgRecord {
    public static final int REDUCTION_FULL_CLOSED = 0;
    public static final int REDUCTION_PART_OPEN = 1;
    public static final int REDUCTION_FINAL_CLOSED = 2;
    private static Pattern linePattern1 = Pattern.compile("21(\\d{10})(.{25})(\\d{18})(\\d)(\\d)(\\d{12})(\\d)(\\d).*");
    private String senderBg;
    private BgMaxReference reference = new BgMaxReference();
    private String bgcRef;
    private int reductionType;

    public BgMaxTk21Record() {
        super("21");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.senderBg = BgUtil.trimLeadingZeros(m.group(1));
            this.reference.reference = BgUtil.trimLeadingZeros(m.group(2));
            this.reference.amount = BgUtil.parseAmountStr(m.group(3));
            this.reference.referenceType = Integer.parseInt(m.group(4));
            this.reference.payChannel = Integer.parseInt(m.group(5));
            this.bgcRef = m.group(6);
            this.reference.scannedImage = Integer.parseInt(m.group(7)) > 0;
            this.reductionType = Integer.parseInt(m.group(8));
            return this;
        }
        throw new BgParseException(line);
    }

    public BgMaxReference getReferenceRecord() {
        return this.reference;
    }

    @Override
    public String toRecordString() {
        StringBuffer seqStr;
        StringBuffer line = new StringBuffer(this.getTransCode());
        if (this.senderBg == null) {
            seqStr = new StringBuffer();
            while (seqStr.length() < 10) {
                seqStr.append(" ");
            }
        } else {
            seqStr = new StringBuffer(this.senderBg);
            while (seqStr.length() < 10) {
                seqStr.insert(0, "0");
            }
        }
        line.append(seqStr);
        String refStr = this.reference != null ? this.reference.reference : "";
        String ref = BgUtil.fillToLength(refStr, false, ' ', 25);
        line.append(ref);
        line.append(BgUtil.getAmountStr(this.getAmount(), 18, false));
        line.append(this.reference != null ? this.reference.referenceType : 0);
        line.append(this.reference != null ? this.reference.payChannel : 1);
        ref = BgUtil.fillToLength(this.bgcRef, true, '0', 12);
        line.append(ref);
        line.append(this.reference != null ? (this.reference.scannedImage ? "1" : "0") : "0");
        line.append(this.reductionType);
        while (line.length() < 81) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getSenderBg() {
        return this.senderBg;
    }

    public void setSenderBg(String senderBg) {
        this.senderBg = senderBg;
    }

    public String getReference() {
        return this.reference.reference;
    }

    public void setReference(String reference) {
        this.reference.reference = reference;
    }

    public double getAmount() {
        return this.reference.amount;
    }

    public void setAmount(double amount) {
        this.reference.amount = amount;
    }

    public int getReferenceType() {
        return this.reference.referenceType;
    }

    public void setReferenceType(int referenceType) {
        this.reference.referenceType = referenceType;
    }

    public int getPayChannel() {
        return this.reference.payChannel;
    }

    public void setPayChannel(int payChannel) {
        this.reference.payChannel = payChannel;
    }

    public String getBgcRef() {
        return this.bgcRef;
    }

    public void setBgcRef(String bgcRef) {
        this.bgcRef = bgcRef;
    }

    public boolean hasScannedImage() {
        return this.reference.scannedImage;
    }

    public void setScannedImage(boolean scannedImage) {
        this.reference.scannedImage = scannedImage;
    }

    public int getReductionType() {
        return this.reductionType;
    }

    public void setReductionType(int reductionType) {
        this.reductionType = reductionType;
    }
}

