/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;
import org.notima.bg.bgmax.BgMaxReference;

public class BgMaxTk22Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("22(\\d{10})(.{25})(\\d{18})(\\d)(\\d)(\\d{12})(\\d).*");
    private BgMaxReference reference = new BgMaxReference();

    public BgMaxTk22Record() {
        super("22");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.reference.reference = BgUtil.trimLeadingZeros(m.group(2));
            this.reference.amount = BgUtil.parseAmountStr(m.group(3));
            this.reference.referenceType = Integer.parseInt(m.group(4));
            this.reference.payChannel = Integer.parseInt(m.group(5));
            this.reference.scannedImage = Integer.parseInt(m.group(7)) > 0;
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        return null;
    }

    public BgMaxReference getReferenceRecord() {
        return this.reference;
    }

    public void setReferenceRecord(BgMaxReference ref) {
        this.reference = ref;
    }
}

