/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class BgMaxTk26Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("26(.{35})(.*)");
    private String name1;
    private String name2;

    public BgMaxTk26Record() {
        super("26");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.name1 = m.group(1).trim();
            this.name2 = m.group(2).trim();
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.transCode);
        line.append(BgUtil.fillToLength(this.name1, false, ' ', 35));
        line.append(BgUtil.fillToLength(this.name2, false, ' ', 35));
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }
}

