/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class BgMaxTk27Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("27(.{35})(.{9}).*");
    private String address;
    private String zipCode;

    public BgMaxTk27Record() {
        super("27");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.address = m.group(1).trim();
            this.zipCode = m.group(2).trim();
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.transCode);
        line.append(BgUtil.fillToLength(this.address, false, ' ', 35));
        line.append(BgUtil.fillToLength(BgUtil.removeBlanks(this.zipCode), false, ' ', 9));
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }
}

