/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class BgMaxTk29Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("29(\\d{12}).*");
    private String taxId;

    public BgMaxTk29Record() {
        super("29");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.taxId = BgUtil.trimLeadingZeros(m.group(1));
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.transCode);
        try {
            this.taxId = BgUtil.formatTaxId(this.taxId);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        line.append(BgUtil.fillToLength(this.taxId, true, '0', 12));
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }
}

