/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgFooter;
import org.notima.bg.BgParseException;
import org.notima.bg.BgUtil;

public class BgMaxTk70Footer
extends BgFooter {
    private static Pattern linePattern1 = Pattern.compile("70(\\d{8})(\\d{8})(\\d{8})(\\d{8}).*");
    private int countReceipts;
    private int countReductions;
    private int countExtraReferences;
    private int countWhat;

    public BgMaxTk70Footer() {
        super("70");
    }

    @Override
    public BgFooter parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.countReceipts = Integer.parseInt(m.group(1));
            this.countReductions = Integer.parseInt(m.group(2));
            this.countExtraReferences = Integer.parseInt(m.group(3));
            this.countWhat = Integer.parseInt(m.group(4));
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.transCode);
        String receiptsString = Integer.toString(this.countReceipts);
        receiptsString = BgUtil.fillToLength(receiptsString, true, '0', 8);
        line.append(receiptsString);
        String reductionsStr = Integer.toString(this.countReductions);
        reductionsStr = BgUtil.fillToLength(reductionsStr, true, '0', 8);
        line.append(reductionsStr);
        String extraRefStr = Integer.toString(this.countExtraReferences);
        extraRefStr = BgUtil.fillToLength(extraRefStr, true, '0', 8);
        line.append(extraRefStr);
        String whatStr = Integer.toString(this.countWhat);
        whatStr = BgUtil.fillToLength(whatStr, true, '0', 8);
        line.append(whatStr);
        return line.toString();
    }

    public int getCountReceipts() {
        return this.countReceipts;
    }

    public void setCountReceipts(int countReceipts) {
        this.countReceipts = countReceipts;
    }

    public int getCountReductions() {
        return this.countReductions;
    }

    public void setCountReductions(int countReductions) {
        this.countReductions = countReductions;
    }

    public int getCountExtraReferences() {
        return this.countExtraReferences;
    }

    public void setCountExtraReferences(int countExtraReferences) {
        this.countExtraReferences = countExtraReferences;
    }

    public int getCountWhat() {
        return this.countWhat;
    }

    public void setCountWhat(int countWhat) {
        this.countWhat = countWhat;
    }
}

