/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.notima.bg.BgFooter;
import org.notima.bg.BgHeader;
import org.notima.bg.BgRecord;
import org.notima.bg.BgSet;
import org.notima.bg.Transaction;
import org.notima.bg.lb.LbPayment;

public abstract class AbstractLbSet
implements BgSet {
    public static final int BANK_HANDELSBANKEN = 1;
    public static final int BANK_SWEDBANK = 2;
    public static final int BANK_SEB = 3;
    public static final int BANK_NORDEA = 4;
    protected BgHeader header;
    protected BgFooter footer;
    protected Vector<Transaction> records;
    protected Vector<Transaction> creditTransactions = new Vector();
    protected Map<String, Vector<BgRecord>> creditRecords = new TreeMap<String, Vector<BgRecord>>();

    public AbstractLbSet(BgHeader header, BgFooter footer) {
        this.header = header;
        this.footer = footer;
        this.records = new Vector();
    }

    @Override
    public String getSenderBankAccount() {
        return this.header.getSenderAccount();
    }

    @Override
    public String getRecipientBankAccount() {
        return null;
    }

    @Override
    public String getCurrency() {
        return this.header.getCurrency();
    }

    public void setCurrency(String currency) {
        this.header.setCurrency(currency);
    }

    public Date getPayDate() {
        return this.header.getPayDate();
    }

    public BgHeader getHeader() {
        return this.header;
    }

    public void setHeader(BgHeader header) {
        this.header = header;
    }

    public BgFooter getFooter() {
        return this.footer;
    }

    public void setFooter(BgFooter footer) {
        this.footer = footer;
    }

    @Override
    public Vector<Transaction> getRecords() {
        return this.records;
    }

    @Override
    public void addTransaction(Transaction payment) {
        payment.setParentSet(this);
        if (this.footer != null) {
            this.footer.incrementAmount(payment.getAmount());
            this.footer.incrementCount();
            if (payment.getForeignAmount() != 0.0) {
                this.footer.incrementForeignAmount(payment.getForeignAmount());
            }
        }
        if (payment.getAmount() < 0.0) {
            this.creditTransactions.add(payment);
        }
        this.records.add((LbPayment)payment);
    }

    @Override
    public void setRecords(Vector<Transaction> records) {
        this.records = records;
        this.footer.setAmount(0.0);
        if (records != null) {
            this.footer.setCount(records.size());
        }
        Iterator<Transaction> it = records.iterator();
        while (it.hasNext()) {
            this.footer.incrementAmount(it.next().getAmount());
        }
    }

    @Override
    public String toRecordString() {
        StringBuffer lines = new StringBuffer();
        lines.append(this.header.toRecordString() + "\n");
        if (this.records != null && this.records.size() > 0) {
            for (int i = 0; i < this.records.size(); ++i) {
                Transaction payment = this.records.get(i);
                payment.setSeqNo(i + 1);
                lines.append(payment.toRecordString());
            }
        }
        lines.append(this.footer.toRecordString() + "\n");
        return lines.toString();
    }

    @Override
    public abstract Date getCreditRecordDate(String var1, double var2);

    public abstract void addCreditRecord(BgRecord var1);
}

