/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.Date;
import java.util.Vector;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgSet;
import org.notima.bg.BgUtil;
import org.notima.bg.Transaction;
import org.notima.bg.lb.LbTk14Record;
import org.notima.bg.lb.LbTk16Record;
import org.notima.bg.lb.LbTk25Record;
import org.notima.bg.lb.LbTk26Record;
import org.notima.bg.lb.LbTk2Record;
import org.notima.bg.lb.LbTk3Record;
import org.notima.bg.lb.LbTk40Record;
import org.notima.bg.lb.LbTk4Record;
import org.notima.bg.lb.LbTk54Record;
import org.notima.bg.lb.LbTk5Record;
import org.notima.bg.lb.LbTk65Record;
import org.notima.bg.lb.LbTk6Record;
import org.notima.bg.lb.LbTk7Record;

public class LbPayment
implements Transaction {
    private Vector<BgRecord> records = new Vector();
    private BgSet parentSet;
    private double amount;
    private String dstName;
    private String dstAccount;
    private String dstBg;
    private String dstPg;
    private String ourRef;
    private Date transDate;
    private String comment;
    private String ocr;
    private double foreignAmount;
    private String foreignCurrency;
    private boolean foreign = false;
    private Vector<String> info = new Vector();

    public static LbPayment createBankPayment(String dstAccount, double amount, String comment, String ourRef, Date payDate) {
        LbPayment payment = new LbPayment();
        payment.amount = (double)Math.round(amount * 100.0) / 100.0;
        LbTk40Record rec1 = new LbTk40Record(dstAccount, comment);
        BgRecord rec2 = amount >= 0.0 ? new LbTk14Record(amount, ourRef, payDate) : new LbTk16Record(amount, ourRef, payDate);
        payment.records = new Vector();
        payment.records.add(rec1);
        payment.records.add(rec2);
        payment.dstAccount = dstAccount;
        payment.ourRef = ourRef;
        payment.transDate = payDate;
        payment.comment = comment;
        return payment;
    }

    public static LbPayment createBgPayment(String recipientBg, String OCR, double amount, String ourRef, Date payDate) {
        BgRecord rec1;
        LbPayment payment = new LbPayment();
        payment.amount = (double)Math.round(amount * 100.0) / 100.0;
        boolean digitsOnly = BgUtil.hasDigitsOnly(OCR);
        if (amount >= 0.0) {
            rec1 = new LbTk14Record(recipientBg, amount, ourRef);
            ((LbTk14Record)rec1).setPayDate(payDate);
            if (digitsOnly) {
                ((LbTk14Record)rec1).setOcrRef(OCR);
            }
            payment.records.add(rec1);
        } else {
            rec1 = new LbTk16Record(recipientBg, amount, ourRef);
            if (digitsOnly) {
                ((LbTk16Record)rec1).setOcrRef(OCR);
            }
            payment.records.add(rec1);
        }
        if (!digitsOnly && OCR != null && OCR.trim().length() > 0) {
            LbTk25Record rec = new LbTk25Record();
            rec.setRecipientBg(recipientBg);
            rec.setInfoText(OCR.trim());
            payment.records.add(rec);
        }
        payment.dstBg = recipientBg;
        payment.ourRef = ourRef;
        payment.transDate = payDate;
        payment.ocr = OCR;
        return payment;
    }

    public static LbPayment createPgPayment(String recipientPg, String OCR, double amount, String ourRef, Date payDate, String[] infoText) {
        LbPayment payment = new LbPayment();
        payment.amount = (double)Math.round(amount * 100.0) / 100.0;
        if (amount >= 0.0) {
            LbTk54Record rec1 = new LbTk54Record(recipientPg, OCR, amount, ourRef, payDate);
            payment.records.add(rec1);
            if (infoText != null && infoText.length > 0) {
                for (int i = 0; i < infoText.length; ++i) {
                    if (infoText[i] == null || infoText[i].trim().length() <= 0) continue;
                    LbTk65Record rec2 = new LbTk65Record(recipientPg, infoText[i]);
                    payment.records.add(rec2);
                    payment.info.add(infoText[i]);
                }
            }
        } else {
            return null;
        }
        payment.dstPg = recipientPg;
        payment.ourRef = ourRef;
        payment.transDate = payDate;
        payment.ocr = OCR;
        return payment;
    }

    public static LbPayment createUtlPayment(int recipientNo, String swift, String iban, String name, String address, String postal, String countryCode, String invoiceRef, double amount, double foreignAmount, String currency, String ourRef, Date payDate, int bankCode, String costDist, String trxType, String hbAccountNo) {
        BgRecord amountRec;
        LbPayment payment = new LbPayment();
        payment.setForeign(true);
        payment.comment = invoiceRef;
        payment.ourRef = ourRef;
        payment.transDate = payDate;
        payment.foreignAmount = (double)Math.round(foreignAmount * 100.0) / 100.0;
        payment.amount = (double)Math.round(amount * 100.0) / 100.0;
        LbTk2Record nameRec = new LbTk2Record(recipientNo, name, "");
        payment.records.add(nameRec);
        LbTk3Record addrRec = new LbTk3Record(recipientNo, address, postal, countryCode, costDist, trxType);
        payment.records.add(addrRec);
        if (iban != null & iban.length() > 0) {
            LbTk4Record ibanRec = new LbTk4Record(recipientNo, swift, iban);
            payment.records.add(ibanRec);
        }
        if (payment.foreignAmount >= 0.0) {
            amountRec = new LbTk6Record(recipientNo, invoiceRef, payment.amount, currency, payDate, payment.foreignAmount);
            payment.records.add(amountRec);
        } else {
            amountRec = new LbTk5Record(recipientNo, invoiceRef, payment.amount, currency, payDate, payment.foreignAmount);
            payment.records.add(amountRec);
        }
        LbTk7Record bankRec = new LbTk7Record(recipientNo, bankCode, hbAccountNo);
        payment.records.add(bankRec);
        return payment;
    }

    @Override
    public void addRecord(BgRecord record) {
        BgRecord r;
        record.setParentSet(this.parentSet);
        int code = Integer.parseInt(record.getTransCode());
        if (code == 40) {
            r = (LbTk40Record)record;
            this.dstAccount = ((LbTk40Record)r).getFullAccountNo();
        }
        if (code == 14) {
            r = (LbTk14Record)record;
            this.dstBg = BgUtil.trimLeadingZeros(((LbTk14Record)r).recipientBg);
            this.ocr = ((LbTk14Record)r).ocrRef.trim();
            this.ourRef = ((LbTk14Record)r).ourRefText.trim();
            this.amount = ((LbTk14Record)r).amount;
            this.transDate = ((LbTk14Record)r).payDate;
        }
        if (code == 16) {
            r = (LbTk16Record)record;
            this.dstBg = BgUtil.trimLeadingZeros(((LbTk16Record)r).getRecipientBg());
            this.ocr = ((LbTk16Record)r).ocrRef.trim();
            this.ourRef = ((LbTk16Record)r).ourRefText.trim();
            this.amount = ((LbTk16Record)r).getAmount();
            this.transDate = ((LbTk16Record)r).getPayDate();
        }
        if (code == 54) {
            r = (LbTk54Record)record;
            this.dstPg = BgUtil.trimLeadingZeros(((LbTk54Record)r).getRecipientPg());
            this.ocr = ((LbTk54Record)r).getOcrRef();
            this.ourRef = ((LbTk54Record)r).getOurRef();
            this.amount = ((LbTk54Record)r).getAmount();
            this.transDate = ((LbTk54Record)r).getPayDate();
        }
        if (code == 26) {
            this.dstName = ((LbTk26Record)record).getRecipientName();
        }
        this.records.add(record);
    }

    @Override
    public void setTransactionDate(Date payDate) {
        for (BgRecord rec : this.records) {
            if (rec instanceof LbTk14Record) {
                ((LbTk14Record)rec).setPayDate(payDate);
            }
            if (!(rec instanceof LbTk54Record)) continue;
            ((LbTk54Record)rec).setPayDate(payDate);
        }
        this.transDate = payDate;
    }

    @Override
    public void setSeqNo(int seqNo) {
        if (this.records != null && this.records.size() > 0) {
            for (int i = 0; i < this.records.size(); ++i) {
                this.records.get(i).setSeqNo(seqNo);
            }
        }
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public String toRecordString() {
        StringBuffer lines = new StringBuffer();
        if (this.records != null && this.records.size() > 0) {
            for (int i = 0; i < this.records.size(); ++i) {
                lines.append(this.records.get(i).toRecordString() + "\n");
            }
        }
        return lines.toString();
    }

    public Vector<BgRecord> getRecords() {
        return this.records;
    }

    public void setRecords(Vector<BgRecord> records) {
        this.records = records;
    }

    public String getDstName() {
        return this.dstName;
    }

    public void setDstName(String dstName) {
        this.dstName = dstName;
    }

    public String getDstAccount() {
        return this.dstAccount;
    }

    public void setDstAccount(String dstAccount) {
        this.dstAccount = dstAccount;
    }

    public String getDstPg() {
        return this.dstPg;
    }

    public void setDstPg(String dstPg) {
        this.dstPg = dstPg;
    }

    public String getOurRef() {
        return this.ourRef;
    }

    public void setOurRef(String ourRef) {
        this.ourRef = ourRef;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getOcr() {
        return this.ocr;
    }

    public void setOcr(String ocr) {
        this.ocr = ocr;
    }

    public Vector<String> getInfo() {
        return this.info;
    }

    public void setInfo(Vector<String> info) {
        this.info = info;
    }

    @Override
    public Date getTransactionDate() {
        return this.transDate;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public boolean isBgPayment() {
        return this.dstBg != null && this.dstBg.trim().length() > 0;
    }

    public boolean isPgPayment() {
        return this.dstPg != null && this.dstPg.trim().length() > 0;
    }

    public boolean isAccountPayment() {
        return this.dstAccount != null && this.dstAccount.trim().length() > 0;
    }

    public String getDstBg() {
        return this.dstBg;
    }

    public void setDstBg(String dstBg) {
        this.dstBg = dstBg;
    }

    public String getDestination() {
        if (this.isBgPayment()) {
            return this.dstBg;
        }
        if (this.isPgPayment()) {
            return this.dstPg;
        }
        if (this.isAccountPayment()) {
            return this.dstAccount;
        }
        return null;
    }

    public String getDestinationFormatted() throws BgParseException {
        if (this.isBgPayment()) {
            return BgUtil.formatBg(this.dstBg);
        }
        if (this.isPgPayment()) {
            return BgUtil.formatPg(this.dstPg);
        }
        if (this.isAccountPayment()) {
            return this.dstAccount;
        }
        return null;
    }

    @Override
    public boolean isForeign() {
        return this.foreign;
    }

    public void setForeign(boolean international) {
        this.foreign = international;
    }

    @Override
    public double getForeignAmount() {
        return this.foreignAmount;
    }

    public void setForeignAmount(double foreignAmount) {
        this.foreignAmount = foreignAmount;
    }

    @Override
    public String getForeignCurrency() {
        return this.foreignCurrency;
    }

    public void setForeignCurrency(String currency) {
        this.foreignCurrency = currency;
    }

    @Override
    public BgSet getParentSet() {
        return this.parentSet;
    }

    @Override
    public void setParentSet(BgSet parentSet) {
        this.parentSet = parentSet;
        for (BgRecord rec : this.records) {
            rec.setParentSet(parentSet);
        }
    }
}

