/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgRecordFactory;
import org.notima.bg.lb.LbTk11Header;
import org.notima.bg.lb.LbTk14Record;
import org.notima.bg.lb.LbTk16Record;
import org.notima.bg.lb.LbTk20Record;
import org.notima.bg.lb.LbTk21Record;
import org.notima.bg.lb.LbTk25Record;
import org.notima.bg.lb.LbTk26Record;
import org.notima.bg.lb.LbTk29Record;
import org.notima.bg.lb.LbTk40Record;
import org.notima.bg.lb.LbTk54Record;
import org.notima.bg.lb.LbTk65Record;

public class LbRecordFactory
implements BgRecordFactory {
    @Override
    public BgRecord parseRecord(String line) throws BgParseException {
        if (line == null || line.trim().length() < 2) {
            return null;
        }
        BgRecord record = null;
        String transCodeStr = line.substring(0, 2);
        int transCode = Integer.parseInt(transCodeStr);
        switch (transCode) {
            case 11: {
                record = new LbTk11Header();
                break;
            }
            case 14: {
                record = new LbTk14Record();
                break;
            }
            case 16: {
                record = new LbTk16Record();
                break;
            }
            case 20: {
                record = new LbTk20Record();
                break;
            }
            case 21: {
                record = new LbTk21Record();
                break;
            }
            case 25: {
                record = new LbTk25Record();
                break;
            }
            case 26: {
                record = new LbTk26Record();
                break;
            }
            case 29: {
                record = new LbTk29Record();
                break;
            }
            case 40: {
                record = new LbTk40Record();
                break;
            }
            case 54: {
                record = new LbTk54Record();
                break;
            }
            case 65: {
                record = new LbTk65Record();
                break;
            }
            default: {
                throw new BgParseException("No parser for line " + line);
            }
        }
        record.parse(line);
        return record;
    }
}

