/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgHeader;
import org.notima.bg.BgParseException;
import org.notima.bg.BgUtil;

public class LbTk11Header
extends BgHeader {
    private String bgAccount;
    private Date fileDate;
    private Date payDate;
    private String currency = "";
    private static Pattern linePattern1 = Pattern.compile("11(\\d{10})(\\d{6})LEV.*");
    private static Pattern linePattern2 = Pattern.compile(".*?BETALNINGAR(.{6}).{13}(.{3}).*");

    public LbTk11Header() {
        super("11");
    }

    public LbTk11Header(String senderAccount) {
        super("11");
        this.bgAccount = senderAccount;
        this.setHeaderType("LEVERANT\u00d6RSBETALNINGAR");
        this.fileDate = Calendar.getInstance().getTime();
    }

    @Override
    public String getSenderAccount() {
        return this.bgAccount;
    }

    @Override
    public String getCurrency() {
        if (this.currency == null || this.currency.trim().length() == 0) {
            return "SEK";
        }
        return this.currency;
    }

    @Override
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public Date getPayDate() {
        return this.payDate;
    }

    public void setPayDate(Date payDate) {
        this.payDate = payDate;
    }

    public String getBgAccount() {
        return this.bgAccount;
    }

    public void setBgAccount(String bgAccount) {
        this.bgAccount = bgAccount;
    }

    public Date getFileDate() {
        return this.fileDate;
    }

    public void setCreateDate(Date fileDate) {
        this.fileDate = fileDate;
    }

    @Override
    public LbTk11Header parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.bgAccount = BgUtil.trimLeadingZeros(m.group(1));
            try {
                this.fileDate = BgUtil.parseDateString(m.group(2));
            }
            catch (ParseException pe) {
                throw new BgParseException("File date: " + m.group(2) + " not valid. ", line);
            }
            m = linePattern2.matcher(line);
            if (m.matches()) {
                this.currency = m.group(2);
                try {
                    this.payDate = BgUtil.parseDateString(m.group(1));
                }
                catch (ParseException pe2) {
                    throw new BgParseException("Pay date: " + m.group(1) + " not valid. ", line);
                }
            }
            return this;
        }
        throw new BgParseException(line);
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer("11");
        StringBuffer account = new StringBuffer();
        if (this.bgAccount != null) {
            for (int i = 0; i < this.bgAccount.length(); ++i) {
                char c = this.bgAccount.charAt(i);
                if (c < '0' || c > '9') continue;
                account.append(c);
            }
        }
        while (account.length() < 10) {
            account.insert(0, '0');
        }
        line.append(account);
        if (this.fileDate == null) {
            this.fileDate = Calendar.getInstance().getTime();
        }
        String dateStr = BgUtil.getDateString(this.fileDate);
        line.append(dateStr);
        line.append(this.getHeaderType());
        if (this.payDate != null) {
            line.append(BgUtil.getDateString(this.payDate));
        } else {
            line.append("      ");
        }
        line.append("             ");
        line.append(this.currency);
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    @Override
    public Date getCreateDate() {
        return this.fileDate;
    }
}

