/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class LbTk20Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("20(\\d{9})(.)(\\d{6})(\\d{12})(\\d{12}).*");
    private String recipientBg;
    private Date creditDate;
    private double creditAmount;
    private double remainderAmount;

    public LbTk20Record() {
        super("21");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (m.matches()) {
            this.setRecipientBg((m.group(1) + m.group(2)).trim());
            try {
                this.creditDate = BgUtil.parseDateString(m.group(3));
            }
            catch (Exception ee) {
                throw new BgParseException("Invalid date", line);
            }
        } else {
            throw new BgParseException(line);
        }
        this.creditAmount = BgUtil.parseAmountStr(m.group(4));
        this.remainderAmount = BgUtil.parseAmountStr(m.group(5));
        return this;
    }

    @Override
    public String toRecordString() {
        StringBuffer seqStr;
        StringBuffer line = new StringBuffer(this.getTransCode());
        if (this.recipientBg == null) {
            seqStr = new StringBuffer(Integer.toString(this.seqNo));
            while (seqStr.length() < 9) {
                seqStr.insert(0, "0");
            }
            seqStr.append(" ");
        } else {
            seqStr = new StringBuffer(this.recipientBg);
            while (seqStr.length() < 10) {
                seqStr.insert(0, "0");
            }
        }
        line.append(seqStr);
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }

    public String getRecipientBg() {
        return this.recipientBg;
    }

    public void setRecipientBg(String recipientBg) {
        this.recipientBg = BgUtil.toDigitsOnly(recipientBg);
        this.recipientBg = BgUtil.trimLeadingZeros(this.recipientBg);
    }

    public Date getCreditDate() {
        return this.creditDate;
    }

    public void setCreditDate(Date creditDate) {
        this.creditDate = creditDate;
    }

    public double getCreditAmount() {
        return this.creditAmount;
    }

    public void setCreditAmount(double creditAmount) {
        this.creditAmount = creditAmount;
    }

    public double getRemainderAmount() {
        return this.remainderAmount;
    }

    public void setRemainderAmount(double remainderAmount) {
        this.remainderAmount = remainderAmount;
    }
}

