/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;

public class LbTk26Record
extends BgRecord {
    private static Pattern linePattern1 = Pattern.compile("26(\\d{10})(.{35})(.*)");
    private String recipientId;
    private String recipientName;
    private String info;

    public LbTk26Record() {
        super("26");
    }

    @Override
    public String toRecordString() {
        return null;
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern1.matcher(line);
        if (!m.matches()) {
            throw new BgParseException(line);
        }
        this.recipientId = m.group(1);
        this.recipientName = m.group(2).trim();
        this.info = m.group(3).trim();
        return this;
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }
}

