/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class LbTk3Record
extends BgRecord {
    public static final String COST_SHA = "0";
    public static final String COST_BEN = "1";
    public static final String COST_OUR = "9";
    public static final String TRX_NORMAL = "B";
    public static final String TRX_EXPRESS = "T";
    public static final String TRX_CHECK = "C";
    private int m_recipientNo;
    private String m_adress;
    private String m_postal;
    private String m_countryCode;
    private String m_countryName;
    private String m_bankCountryCode;
    private String m_costDistribution;
    private String m_trxType;

    public LbTk3Record(int recipientNo, String address, String postal, String countryCode, String costDist, String trxType) {
        super("3");
        this.m_recipientNo = recipientNo;
        this.m_adress = BgUtil.onlyUSASCII(address);
        this.m_postal = BgUtil.onlyUSASCII(postal);
        this.m_countryCode = countryCode;
        this.m_countryName = "";
        this.m_postal = this.m_postal + " " + this.m_countryName;
        this.m_bankCountryCode = this.m_countryCode;
        this.m_costDistribution = costDist;
        this.m_trxType = trxType;
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        return null;
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.getTransCode());
        line.append(BgUtil.fillToLength(Integer.toString(this.m_recipientNo), true, '0', 7));
        line.append(BgUtil.fillToLength(this.m_adress.toUpperCase(), false, ' ', 30));
        line.append(BgUtil.fillToLength(this.m_postal.toUpperCase(), false, ' ', 35));
        line.append(" ");
        line.append(this.m_bankCountryCode);
        line.append(" ");
        if (this.m_costDistribution == null || this.m_costDistribution.length() < 1) {
            line.append(COST_SHA);
        } else {
            line.append(this.m_costDistribution.charAt(0));
        }
        if (this.m_trxType == null || this.m_trxType.length() < 1) {
            line.append(TRX_NORMAL);
        } else {
            line.append(this.m_trxType.charAt(0));
        }
        line.append(" ");
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }
}

