/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class LbTk40Record
extends BgRecord {
    protected String clearingNo;
    protected String accountNo;
    protected String infoText;
    protected boolean isSalary;
    private static Pattern linePattern2 = Pattern.compile("40(\\d{9})(\\d|\\s)(\\d{4})(\\d{12}).*");

    public LbTk40Record() {
        super("40");
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        Matcher m = linePattern2.matcher(line);
        if (m.matches()) {
            this.seqNo = Integer.parseInt(m.group(1));
            this.clearingNo = m.group(3);
            this.accountNo = BgUtil.trimLeadingZeros(m.group(4));
            return this;
        }
        throw new BgParseException(line);
    }

    public LbTk40Record(String dstAccount, String comment) {
        super("40");
        boolean swedbank = dstAccount.startsWith("8");
        int pos = dstAccount.indexOf("-");
        if (pos > 0) {
            this.clearingNo = dstAccount.substring(0, pos - (swedbank ? 1 : 0));
            if (pos < dstAccount.length() - 1) {
                this.accountNo = dstAccount.substring(pos + 1, dstAccount.length());
            }
        } else if (dstAccount.length() > 4) {
            this.clearingNo = dstAccount.substring(0, 4);
            this.accountNo = dstAccount.substring(swedbank ? 5 : 4, dstAccount.length());
        }
        this.infoText = comment;
    }

    public String getClearingNo() {
        return this.clearingNo;
    }

    public void setClearingNo(String aClearingNo) {
        this.clearingNo = BgUtil.toDigitsOnly(aClearingNo);
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public void setAccountNo(String aAccountNo) {
        this.accountNo = BgUtil.toDigitsOnly(aAccountNo);
    }

    public String getInfoText() {
        return this.infoText;
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
    }

    public String getFullAccountNo() {
        int i;
        char c;
        StringBuffer accountNoBuf = new StringBuffer();
        for (int i2 = 0; i2 < this.accountNo.length(); ++i2) {
            c = this.accountNo.charAt(i2);
            if (c < '0' || c > '9') continue;
            accountNoBuf.append(c);
        }
        while (accountNoBuf.length() < 12) {
            accountNoBuf.insert(0, "0");
        }
        StringBuffer clearingNoBuf = new StringBuffer();
        for (i = 0; i < this.clearingNo.length(); ++i) {
            c = this.clearingNo.charAt(i);
            if (c < '0' || c > '9') continue;
            clearingNoBuf.append(c);
        }
        if (this.clearingNo == null || !this.clearingNo.startsWith("8") || this.clearingNo.length() > 4) {
            // empty if block
        }
        if (clearingNoBuf.length() > 4 && this.clearingNo.startsWith("8")) {
            clearingNoBuf.setLength(4);
        } else {
            for (i = clearingNoBuf.length() - 1; i > 3; --i) {
                accountNoBuf.setCharAt(i - 4, clearingNoBuf.charAt(i));
            }
        }
        while (clearingNoBuf.length() < 4) {
            clearingNoBuf.insert(0, "0");
        }
        clearingNoBuf.setLength(4);
        return clearingNoBuf.toString() + accountNoBuf.toString();
    }

    public boolean isSalary() {
        return this.isSalary;
    }

    public void setSalary(boolean isSalary) {
        this.isSalary = isSalary;
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.transCode);
        line.append("0000");
        StringBuffer seqBuf = new StringBuffer(Integer.toString(this.seqNo));
        while (seqBuf.length() < 5) {
            seqBuf.insert(0, "0");
        }
        seqBuf.append(" ");
        line.append(seqBuf);
        String fullAccountStr = this.getFullAccountNo();
        line.append(fullAccountStr);
        StringBuffer refBuf = new StringBuffer();
        if (this.getInfoText() != null) {
            refBuf.append(this.getInfoText());
        }
        if (refBuf.length() > 12) {
            refBuf.setLength(12);
        } else {
            while (refBuf.length() < 12) {
                refBuf.append(" ");
            }
        }
        line.append(refBuf.toString());
        if (this.isSalary()) {
            line.append("L");
        } else {
            line.append(" ");
        }
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }
}

