/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import java.util.Date;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgUtil;

public class LbTk5Record
extends BgRecord {
    private int m_recipientNo;
    private String m_invoiceRef;
    private String m_currencyCode;
    private double m_amount;
    private Date m_payDate;
    private double m_foreignAmount;

    public LbTk5Record(int recipientNo, String invoiceRef, double amount, String currencyCode, Date payDate, double foreignAmount) {
        super("5");
        this.m_recipientNo = recipientNo;
        this.m_invoiceRef = invoiceRef;
        this.m_amount = amount;
        this.m_currencyCode = currencyCode;
        this.m_payDate = payDate;
        this.m_foreignAmount = foreignAmount;
    }

    @Override
    public BgRecord parse(String line) throws BgParseException {
        return null;
    }

    @Override
    public String toRecordString() {
        StringBuffer line = new StringBuffer(this.getTransCode());
        line.append(BgUtil.fillToLength(Integer.toString(this.m_recipientNo), true, '0', 7));
        line.append(BgUtil.fillToLength(this.m_invoiceRef, false, ' ', 25));
        if (this.m_amount != 0.0) {
            line.append(BgUtil.getAmountStr(this.m_amount, 11, false));
        } else {
            line.append("           ");
        }
        line.append("          ");
        line.append(this.m_currencyCode.substring(0, 3).toUpperCase());
        line.append(BgUtil.getDateString(this.m_payDate));
        line.append(" ");
        line.append("0");
        line.append(BgUtil.getAmountStr(this.m_foreignAmount, 13, false));
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }
}

