/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.lb;

import org.notima.bg.BgFooter;
import org.notima.bg.BgParseException;
import org.notima.bg.BgSet;
import org.notima.bg.BgUtil;
import org.notima.bg.lb.LbUtlSet;

public class LbTk9Footer
extends BgFooter {
    private int totalRecipientsNo;
    private String bgAccount;
    private int bankId = 0;

    public LbTk9Footer(String senderAccount) {
        super("9");
        this.bgAccount = senderAccount;
    }

    @Override
    public BgFooter parse(String line) throws BgParseException {
        return null;
    }

    @Override
    public String toRecordString() {
        BgSet parentSet = this.getParentSet();
        if (parentSet != null && parentSet instanceof LbUtlSet) {
            this.bankId = ((LbUtlSet)parentSet).getBankId();
        }
        StringBuffer line = new StringBuffer(this.transCode);
        StringBuffer account = new StringBuffer();
        String bga = BgUtil.toDigitsOnly(this.bgAccount);
        account.append(bga);
        while (account.length() < 8) {
            account.insert(0, '0');
        }
        line.append(account);
        line.append(BgUtil.getAmountStr(this.amount));
        line.append("      ");
        line.append("    ");
        if (this.totalRecipientsNo == 0) {
            line.append("            ");
        } else {
            line.append(BgUtil.fillToLength(Integer.toString(this.totalRecipientsNo), true, ' ', 12));
        }
        if (this.bankId != 1) {
            line.append(BgUtil.fillToLength(Integer.toString(this.count), true, ' ', 12));
        } else {
            line.append("            ");
        }
        line.append(BgUtil.fillToLength(" ", false, ' ', 8));
        double totalUtl = this.foreignAmount * 100.0;
        line.append(BgUtil.fillToLength(Long.toString(Math.round(totalUtl)), true, '0', 15));
        while (line.length() < 80) {
            line.append(" ");
        }
        return line.toString();
    }
}

