/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Entity;
import org.notima.bg.BgUtil;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.Invoice;
import org.notima.generic.businessobjects.InvoiceLine;

@Entity
public class DunningEntry<B, I> {
    private int lineNo;
    private int nextLineNo = 10;
    private int lineNoIncrement = 10;
    private String letterCurrency;
    private String letterNo;
    private String bgNo;
    private String ocrNo;
    private int bgAmount;
    private int bgAmountCheck;
    private int bgAmountOre;
    private int bgNoDigitsOnly;
    private double totalClaims;
    private double totalInterest;
    private double totalLegalCost;
    private double grandTotal;
    private Date letterDate;
    private Date letterDueDate;
    private BusinessPartner<B> debtor = new BusinessPartner();
    private BusinessPartner<B> creditor = new BusinessPartner();
    private ArrayList<Invoice<I>> invoices = new ArrayList();
    private String letterNoPrefix;
    private String ocrNoPrefix;
    private int letterNoLengthCheck = 0;

    public void calculateValues() {
        int ore;
        this.grandTotal = 0.0;
        for (Invoice<I> invoice : this.invoices) {
            invoice.calculateGrandTotal();
            this.grandTotal += invoice.getGrandTotal();
        }
        this.grandTotal = InvoiceLine.round(this.grandTotal, 2);
        this.bgAmount = (int)this.grandTotal;
        this.bgAmountOre = ore = (int)((this.grandTotal - (double)((long)this.grandTotal)) * 100.0 + 0.5);
        this.letterDate = new Date();
        Date tempDue = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(tempDue);
        cal.add(5, 8);
        this.letterDueDate = cal.getTime();
    }

    public void calculateLetterNo() {
        if (this.letterNoPrefix != null && this.letterNoPrefix != "" && this.letterNoLengthCheck < this.letterNo.length()) {
            this.letterNo = this.letterNoPrefix + this.letterNo;
            this.letterNoLengthCheck = this.letterNo.length();
        }
    }

    public void calculateOcrNo() {
        if (this.ocrNo == null) {
            String ocr = this.letterNoPrefix != null && this.letterNoPrefix != "" && this.letterNo.substring(0, this.letterNoPrefix.length()) == this.letterNoPrefix ? this.ocrNoPrefix + this.letterNo.substring(this.letterNoPrefix.length()) : this.ocrNoPrefix + this.letterNo;
            this.ocrNo = BgUtil.toOCRNumberWithLengthCheck(ocr);
        }
    }

    public void addInvoice(Invoice<I> i) {
        if (i.getLineNo() == 0) {
            i.setLineNo(this.nextLineNo);
            this.nextLineNo += this.lineNoIncrement;
        }
        this.invoices.add(i);
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public int getNextLineNo() {
        return this.nextLineNo;
    }

    public void setNextLineNo(int nextLineNo) {
        this.nextLineNo = nextLineNo;
    }

    public int getLineNoIncrement() {
        return this.lineNoIncrement;
    }

    public void setLineNoIncrement(int lineNoIncrement) {
        this.lineNoIncrement = lineNoIncrement;
    }

    public String getLetterCurrency() {
        return this.letterCurrency;
    }

    public void setLetterCurrency(String letterCurrency) {
        this.letterCurrency = letterCurrency;
    }

    public String getLetterNo() {
        return this.letterNo;
    }

    public void setLetterNo(String letterNo) {
        this.letterNo = letterNo;
    }

    public String getBgNo() {
        return this.bgNo;
    }

    public void setBgNo(String bgNo) {
        this.bgNo = bgNo;
    }

    public String getOcrNo() {
        return this.ocrNo;
    }

    public void setOcrNo(String ocrNo) {
        this.ocrNo = ocrNo;
    }

    public int getBgAmount() {
        return this.bgAmount;
    }

    public void setBgAmount(int bgAmount) {
        this.bgAmount = bgAmount;
    }

    public int getBgAmountCheck() {
        return this.bgAmountCheck;
    }

    public void setBgAmountCheck(int bgAmountcheck) {
        this.bgAmountCheck = bgAmountcheck;
    }

    public int getBgAmountOre() {
        return this.bgAmountOre;
    }

    public void setBgAmountOre(int bgAmountOre) {
        this.bgAmountOre = bgAmountOre;
    }

    public int getBgNoDigitsOnly() {
        return this.bgNoDigitsOnly;
    }

    public void setBgNoDigitsOnly(int bgNoDigitsOnly) {
        this.bgNoDigitsOnly = bgNoDigitsOnly;
    }

    public double getTotalClaims() {
        return this.totalClaims;
    }

    public void setTotalClaims(double totalClaims) {
        this.totalClaims = totalClaims;
    }

    public double getTotalInterest() {
        return this.totalInterest;
    }

    public void setTotalInterest(double totalInterest) {
        this.totalInterest = totalInterest;
    }

    public double getTotalLegalCost() {
        return this.totalLegalCost;
    }

    public void setTotalLegalCost(double totalLegalCost) {
        this.totalLegalCost = totalLegalCost;
    }

    public double getGrandTotal() {
        return this.grandTotal;
    }

    public void setGrandTotal(double grandTotal) {
        this.grandTotal = grandTotal;
    }

    public Date getLetterDate() {
        return this.letterDate;
    }

    public void setLetterDate(Date letterDate) {
        this.letterDate = letterDate;
    }

    public Date getLetterDueDate() {
        return this.letterDueDate;
    }

    public void setLetterDueDate(Date letterDueDate) {
        this.letterDueDate = letterDueDate;
    }

    public BusinessPartner<B> getDebtor() {
        return this.debtor;
    }

    public void setDebtor(BusinessPartner<B> debtor) {
        this.debtor = debtor;
    }

    public BusinessPartner<B> getCreditor() {
        return this.creditor;
    }

    public void setCreditor(BusinessPartner<B> creditor) {
        this.creditor = creditor;
    }

    public ArrayList<Invoice<I>> getInvoices() {
        return this.invoices;
    }

    public void setInvoices(ArrayList<Invoice<I>> invoices) {
        this.invoices = invoices;
    }

    public String getLetterNoPrefix() {
        return this.letterNoPrefix;
    }

    public void setLetterNoPrefix(String letterNoPrefix) {
        this.letterNoPrefix = letterNoPrefix;
    }

    public String getOcrNoPrefix() {
        return this.ocrNoPrefix;
    }

    public void setOcrNoPrefix(String ocrNoPrefix) {
        this.ocrNoPrefix = ocrNoPrefix;
    }

    public int getLetterNoLengthCheck() {
        return this.letterNoLengthCheck;
    }

    public void setLetterNoLengthCheck(int letterNoLengthCheck) {
        this.letterNoLengthCheck = letterNoLengthCheck;
    }
}

