/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import org.notima.generic.businessobjects.Product;
import org.notima.generic.ifacebusinessobjects.OrderInvoiceLine;

@Entity
public class InvoiceLine
implements OrderInvoiceLine {
    private String groupKey;
    private String key;
    private String name;
    private double qtyEntered;
    private double qtyDelivered;
    private Double priceActual;
    private double lineNet;
    private int lineNo;
    private String taxKey;
    private double taxPercent;
    private double theirTotal;
    private double taxAmount;
    private String productKey;
    private String description;
    private String poDocumentNo;
    private String poReference;
    private String vendorProductNo;
    private String UOM;
    private boolean taxIncludedInPrice;
    private Double priceNormal;
    private String accountNo;
    @ManyToOne
    private Product<?> product;

    @Override
    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getQtyEntered() {
        return this.qtyEntered;
    }

    public void setQtyEntered(double qtyEntered) {
        this.qtyEntered = qtyEntered;
    }

    public double getQtyDelivered() {
        return this.qtyDelivered;
    }

    public void setQtyDelivered(double qtyDelivered) {
        this.qtyDelivered = qtyDelivered;
    }

    @Override
    public Double getPriceActual() {
        if (this.priceActual == null && this.priceNormal != null) {
            return this.priceNormal;
        }
        return this.priceActual;
    }

    public void setPriceActual(Double priceActual) {
        this.priceActual = priceActual;
    }

    @Override
    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    @Override
    public String getTaxKey() {
        return this.taxKey;
    }

    public void setTaxKey(String taxKey) {
        this.taxKey = taxKey;
    }

    @Override
    public String getProductKey() {
        return this.productKey;
    }

    public void setProductKey(String productKey) {
        this.productKey = productKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public double getTaxPercent() {
        return this.taxPercent;
    }

    public void setTaxPercent(double taxPercent) {
        this.taxPercent = taxPercent;
    }

    public String getPoDocumentNo() {
        return this.poDocumentNo;
    }

    public void setPoDocumentNo(String poDocumentNo) {
        this.poDocumentNo = poDocumentNo;
    }

    public String getPoReference() {
        return this.poReference;
    }

    public void setPoReference(String poDocumentReference) {
        this.poReference = poDocumentReference;
    }

    public String getVendorProductNo() {
        return this.vendorProductNo;
    }

    public void setVendorProductNo(String vendorProductNo) {
        this.vendorProductNo = vendorProductNo;
    }

    @Override
    public String getUOM() {
        return this.UOM;
    }

    public void setUOM(String uOM) {
        this.UOM = uOM;
    }

    public double calculateLineTotalIncTax(int roundingDecimals) {
        double lineTotal;
        if (this.taxIncludedInPrice) {
            double lineIncTax = InvoiceLine.round(this.priceActual * this.qtyEntered, roundingDecimals);
            this.taxAmount = lineIncTax - lineIncTax / (1.0 + this.taxPercent / 100.0);
            this.taxAmount = InvoiceLine.round(this.taxAmount, roundingDecimals);
            this.lineNet = lineIncTax - this.taxAmount;
            lineTotal = lineIncTax;
        } else {
            this.lineNet = InvoiceLine.round(this.priceActual * this.qtyEntered, roundingDecimals);
            this.taxAmount = this.lineNet * (this.taxPercent / 100.0);
            this.taxAmount = InvoiceLine.round(this.taxAmount, roundingDecimals);
            lineTotal = this.lineNet * (1.0 + this.taxPercent / 100.0);
            lineTotal = InvoiceLine.round(lineTotal, roundingDecimals);
        }
        return lineTotal;
    }

    public static double round(double value, int roundingDecimals) {
        DecimalFormat df = new DecimalFormat("#." + new String(new char[roundingDecimals]).replace("\u0000", "#"));
        df.setRoundingMode(RoundingMode.HALF_DOWN);
        return Double.parseDouble(df.format(value).replace(',', '.'));
    }

    public boolean isTaxIncludedInPrice() {
        return this.taxIncludedInPrice;
    }

    public void setTaxIncludedInPrice(boolean taxIncludedInPrice) {
        this.taxIncludedInPrice = taxIncludedInPrice;
    }

    public Product<?> getProduct() {
        return this.product;
    }

    public void setProduct(Product<?> product) {
        this.product = product;
    }

    public double getTheirTotal() {
        return this.theirTotal;
    }

    public void setTheirTotal(double theirTotal) {
        this.theirTotal = theirTotal;
    }

    public double getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(double taxAmount) {
        this.taxAmount = taxAmount;
    }

    public double getLineNet() {
        return this.lineNet;
    }

    public void setLineNet(double lineNet) {
        this.lineNet = lineNet;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }

    @Override
    public Double getPriceNormal() {
        if (this.priceNormal == null && this.priceActual != null) {
            return this.priceActual;
        }
        return this.priceNormal;
    }

    public void setPriceNormal(Double priceNormal) {
        this.priceNormal = priceNormal;
    }

    @Override
    public boolean isPricesIncludeVAT() {
        return this.isTaxIncludedInPrice();
    }
}

