/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.notima.generic.businessobjects.BusinessPartner;
import org.notima.generic.businessobjects.InvoiceLine;
import org.notima.generic.businessobjects.KeyValue;
import org.notima.generic.businessobjects.Location;
import org.notima.generic.businessobjects.OrderLine;
import org.notima.generic.businessobjects.PaymentTerm;
import org.notima.generic.businessobjects.Person;
import org.notima.generic.businessobjects.TaxSummary;
import org.notima.generic.ifacebusinessobjects.FactoringReservation;
import org.notima.generic.ifacebusinessobjects.OrderInvoice;
import org.notima.generic.ifacebusinessobjects.OrderInvoiceLine;

@Entity
@XmlRootElement(name="order")
public class Order<O>
implements OrderInvoice {
    private String orderKey;
    private String paymentTermKey;
    private String paymentRule;
    private PaymentTerm paymentTerm;
    @OneToMany
    private List<OrderLine> lines = new Vector<OrderLine>();
    private double netTotal;
    private double grandTotal;
    private double vatTotal;
    @ManyToOne
    private BusinessPartner<?> bpartner;
    @ManyToOne
    private BusinessPartner<?> billBpartner;
    @ManyToOne
    private BusinessPartner<?> sender;
    @ManyToOne
    private Location billLocation;
    @ManyToOne
    private Location shipLocation;
    @ManyToOne
    private Person billPerson;
    private Date dateOrdered;
    private Date datePromised;
    private Date dateDelivered;
    @Id
    @GeneratedValue
    private String warehouseId;
    private String currency;
    private String ourCustomerNo;
    private String externalReference1;
    private String externalReference2;
    private boolean salesOrder;
    private int roundingDecimals = 2;
    private String deliveryRule;
    private String deliveryViaRule;
    private String shipper;
    @OneToMany
    private List<KeyValue> attributes = new ArrayList<KeyValue>();
    @ManyToOne
    private FactoringReservation factoringReservation;
    private String status;
    private transient O nativeOrder;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[orderKey=>" + this.orderKey + "],[BpIdentityNo=>" + (this.bpartner != null ? this.bpartner.getIdentityNo() : "") + "]");
        for (OrderLine line : this.lines) {
            if (buf.length() > 0) {
                buf.append("\r\n");
            }
            buf.append("  " + line.toString());
        }
        return buf.toString();
    }

    public void addOrderLine(OrderLine line) {
        this.lines.add(line);
    }

    @Override
    public String getPaymentTermKey() {
        return this.paymentTermKey;
    }

    public List<OrderLine> getLines() {
        return this.lines;
    }

    @Override
    public double getGrandTotal() {
        return this.grandTotal;
    }

    @Override
    public BusinessPartner<?> getBusinessPartner() {
        return this.bpartner;
    }

    public BusinessPartner<?> getBpartner() {
        return this.bpartner;
    }

    public void setBpartner(BusinessPartner<?> bpartner) {
        this.bpartner = bpartner;
    }

    public Location getBillLocation() {
        return this.billLocation;
    }

    public void setBillLocation(Location billAddress) {
        this.billLocation = billAddress;
    }

    @Override
    public Location getShipLocation() {
        return this.shipLocation;
    }

    public void setShipLocation(Location shipAddress) {
        this.shipLocation = shipAddress;
    }

    public void setPaymentTermKey(String paymentTermKey) {
        this.paymentTermKey = paymentTermKey;
    }

    public void setLines(List<OrderLine> lines) {
        this.lines = lines;
    }

    @Override
    public void setGrandTotal(double grandTotal) {
        this.grandTotal = grandTotal;
    }

    @Override
    public Person getBillPerson() {
        return this.billPerson;
    }

    public void setBillPerson(Person billPerson) {
        this.billPerson = billPerson;
    }

    @Override
    public BusinessPartner<?> getBillBpartner() {
        if (this.billBpartner == null) {
            return this.bpartner;
        }
        return this.billBpartner;
    }

    public void setBillBpartner(BusinessPartner<?> billBpartner) {
        this.billBpartner = billBpartner;
    }

    public Date getDateOrdered() {
        return this.dateOrdered;
    }

    public void setDateOrdered(Date dateOrdered) {
        this.dateOrdered = dateOrdered;
    }

    public Date getDateDelivered() {
        return this.dateDelivered;
    }

    public void setDateDelivered(Date dateDelivered) {
        this.dateDelivered = dateDelivered;
    }

    public String getOrderKey() {
        return this.orderKey;
    }

    public void setOrderKey(String orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public String getDocumentKey() {
        return this.getOrderKey();
    }

    @Override
    public Date getDocumentDate() {
        return this.getDateOrdered();
    }

    @Override
    @XmlTransient
    public FactoringReservation getFactoringReservation() {
        return this.factoringReservation;
    }

    @Override
    public void setFactoringReservation(FactoringReservation factoringReservation) {
        this.factoringReservation = factoringReservation;
    }

    @Override
    public void setDocumentKey(String key) {
        this.setOrderKey(key);
    }

    @Override
    public void setDocumentDate(Date date) {
        this.setDateOrdered(date);
    }

    @Override
    public Date getDueDate() {
        return null;
    }

    @Override
    public double getFreightAmount() {
        return 0.0;
    }

    @Override
    public String getShipmentNo() {
        return null;
    }

    @Override
    public boolean isCreditNote() {
        return false;
    }

    @Override
    public String getOurCustomerNo() {
        return this.ourCustomerNo;
    }

    public String getExternalReference1() {
        return this.externalReference1;
    }

    public void setExternalReference1(String externalReference1) {
        this.externalReference1 = externalReference1;
    }

    public String getExternalReference2() {
        return this.externalReference2;
    }

    public void setExternalReference2(String externalReference2) {
        this.externalReference2 = externalReference2;
    }

    @Override
    public boolean isInvoice() {
        return false;
    }

    @Override
    public boolean isOrder() {
        return true;
    }

    @Override
    public double getVatTotal() {
        return this.vatTotal;
    }

    public void setVatTotal(double vatTotal) {
        this.vatTotal = vatTotal;
    }

    public void setOurCustomerNo(String ourCustomerNo) {
        this.ourCustomerNo = ourCustomerNo;
    }

    public boolean isSalesOrder() {
        return this.salesOrder;
    }

    public void setSalesOrder(boolean isSalesOrder) {
        this.salesOrder = isSalesOrder;
    }

    public Date getDatePromised() {
        return this.datePromised;
    }

    public void setDatePromised(Date datePromised) {
        this.datePromised = datePromised;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    @Override
    public BusinessPartner<?> getSender() {
        return this.sender;
    }

    public void setSender(BusinessPartner<?> sender) {
        this.sender = sender;
    }

    @Override
    public List<OrderInvoiceLine> getOrderInvoiceLines() {
        if (this.lines != null) {
            ArrayList<OrderInvoiceLine> oiLines = new ArrayList<OrderInvoiceLine>();
            oiLines.addAll(this.lines);
            return oiLines;
        }
        return null;
    }

    public List<KeyValue> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<KeyValue> attributes) {
        this.attributes = attributes;
    }

    public void calculateTaxPercentFromTotal() {
        double taxPercent = this.vatTotal / (this.grandTotal - this.vatTotal);
        taxPercent = Math.round(taxPercent * 10000.0);
        taxPercent /= 100.0;
        for (OrderLine o : this.lines) {
            o.setTaxPercent(taxPercent);
        }
    }

    public String getDeliveryRule() {
        return this.deliveryRule;
    }

    public void setDeliveryRule(String deliveryRule) {
        this.deliveryRule = deliveryRule;
    }

    public String getShipper() {
        return this.shipper;
    }

    public void setShipper(String shipper) {
        this.shipper = shipper;
    }

    public String getDeliveryViaRule() {
        return this.deliveryViaRule;
    }

    public void setDeliveryViaRule(String deliveryViaRule) {
        this.deliveryViaRule = deliveryViaRule;
    }

    public String getPaymentRule() {
        return this.paymentRule;
    }

    public void setPaymentRule(String paymentRule) {
        this.paymentRule = paymentRule;
    }

    public PaymentTerm getPaymentTerm() {
        return this.paymentTerm;
    }

    public void setPaymentTerm(PaymentTerm paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public O getNativeOrder() {
        return this.nativeOrder;
    }

    public void setNativeOrder(O nativeOrder) {
        this.nativeOrder = nativeOrder;
    }

    public double calculateGrandTotal() {
        double total = 0.0;
        this.vatTotal = 0.0;
        this.netTotal = 0.0;
        for (OrderLine line : this.lines) {
            total += line.calculateLineTotalIncTax(this.roundingDecimals);
            this.vatTotal += line.getTaxAmount();
            this.netTotal += line.getLineNet();
        }
        total = InvoiceLine.round(total, this.roundingDecimals);
        this.vatTotal = InvoiceLine.round(this.vatTotal, this.roundingDecimals);
        this.netTotal = InvoiceLine.round(this.netTotal, this.roundingDecimals);
        this.grandTotal = total;
        return total;
    }

    public Map<String, TaxSummary> calculateTaxSummary() {
        TreeMap<String, TaxSummary> result = new TreeMap<String, TaxSummary>();
        String taxKey = null;
        for (OrderLine il : this.getLines()) {
            TaxSummary ts;
            taxKey = il.getTaxKey();
            if (taxKey == null) {
                taxKey = new Double(il.getTaxPercent()).toString();
            }
            if ((ts = (TaxSummary)result.get(taxKey)) == null) {
                ts = new TaxSummary();
                ts.setKey(taxKey);
                ts.setRate(il.getTaxPercent());
                result.put(taxKey, ts);
            }
            ts.setTaxBase(ts.getTaxBase() + il.getLineNet());
            ts.setTaxAmount(ts.getTaxAmount() + il.getTaxAmount());
        }
        return result;
    }
}

