/*
 * Decompiled with CFR 0.152.
 */
package org.notima.generic.businessobjects.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class InterestCalculator {
    public static DateFormat dfmt = new SimpleDateFormat("YYYY-MM-dd");

    public static double calculateFixedRate(String fromDate, String untilDate, double amount, double rate, int decimals) throws ParseException {
        return InterestCalculator.calculateFixedRate(dfmt.parse(fromDate), dfmt.parse(untilDate), amount, rate, decimals);
    }

    public static double calculateFixedRate(Date fromDate, Date untilDate, double amount, double rate, int decimals) {
        if (rate == 0.0 || amount == 0.0) {
            return 0.0;
        }
        Calendar fromCal = Calendar.getInstance();
        fromCal.setTime(fromDate);
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 0);
        fromCal.set(14, 0);
        Calendar untilCal = Calendar.getInstance();
        untilCal.setTime(untilDate);
        untilCal.set(11, 23);
        untilCal.set(12, 59);
        untilCal.set(13, 0);
        untilCal.set(14, 0);
        long seconds = (untilCal.getTimeInMillis() - fromCal.getTimeInMillis()) / 1000L;
        double days = Math.round((double)seconds / 86400.0);
        double interest = amount * rate * (days / 365.0);
        return InterestCalculator.roundToDecimals(interest, decimals);
    }

    public static double roundToDecimals(double amount, int decimals) {
        double multiplier = Math.pow(10.0, decimals);
        double result = (double)Math.round(amount * multiplier) / multiplier;
        return result;
    }
}

