/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.notima.bg.BgFile;
import org.notima.bg.BgFooter;
import org.notima.bg.BgHeader;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgSet;
import org.notima.bg.Transaction;
import org.notima.bg.bgmax.BgMaxReceipt;
import org.notima.bg.bgmax.BgMaxRecordFactory;
import org.notima.bg.bgmax.BgMaxSet;
import org.notima.bg.bgmax.BgMaxTk01Header;
import org.notima.bg.bgmax.BgMaxTk05Record;
import org.notima.bg.bgmax.BgMaxTk15Record;
import org.notima.bg.bgmax.BgMaxTk70Footer;

public class BgMaxFile
extends BgFile {
    private List<BgSet> records = new Vector<BgSet>();

    public BgMaxFile() {
    }

    public BgMaxFile(Date createDate) {
        BgMaxTk01Header header = new BgMaxTk01Header();
        header.setCreateDate(createDate);
        this.fileHeader = header;
    }

    public Set<String> getBgRecipients() {
        TreeSet<String> result = new TreeSet<String>();
        for (BgSet s : this.records) {
            result.add(s.getRecipientBankAccount());
        }
        return result;
    }

    @Override
    public void readFromFile(File file, Charset cs) throws IOException, BgParseException {
        this.lastFile = file;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));
        BgMaxSet currentSet = null;
        Transaction currentTrans = null;
        int code = 0;
        String line = reader.readLine();
        if (line == null) {
            reader.close();
            throw new BgParseException("File is empty");
        }
        BgMaxRecordFactory factory = new BgMaxRecordFactory();
        this.fileHeader = (BgHeader)factory.parseRecord(line);
        while ((line = reader.readLine()) != null) {
            BgRecord record = factory.parseRecord(line);
            code = Integer.parseInt(record.getTransCode());
            if (code == 1) {
                currentSet = new BgMaxSet();
                this.fileHeader = (BgHeader)record;
            }
            if (code == 5) {
                if (currentSet == null) {
                    currentSet = new BgMaxSet();
                }
                currentSet.setSetHeader((BgMaxTk05Record)record);
                continue;
            }
            if (code == 15) {
                if (currentSet == null) {
                    reader.close();
                    throw new BgParseException("Footer but no current set. Error in file.", line);
                }
                if (currentTrans != null) {
                    currentSet.addTransaction(currentTrans);
                }
                currentSet.setSetFooter((BgMaxTk15Record)record);
                this.records.add(currentSet);
                currentSet = null;
                currentTrans = null;
                continue;
            }
            if (code == 70) {
                this.fileFooter = (BgFooter)record;
                break;
            }
            if (currentSet == null) {
                reader.close();
                throw new BgParseException("No current set. Error in file.", line);
            }
            if (code == 20 || code == 21) {
                if (currentTrans != null) {
                    currentSet.addTransaction(currentTrans);
                }
                currentTrans = new BgMaxReceipt(this.fileHeader.getPayDate());
            }
            currentTrans.addRecord(record);
        }
        reader.close();
    }

    @Override
    public BgFooter getFileFooter() {
        return this.fileFooter;
    }

    public BgFooter generateFileFooter() {
        if (this.fileFooter == null) {
            this.fileFooter = new BgMaxTk70Footer();
        }
        BgMaxTk70Footer footer = (BgMaxTk70Footer)this.fileFooter;
        int sets = this.records.size();
        int payments = 0;
        int reductions = 0;
        for (BgSet bg : this.records) {
            for (Transaction t : bg.getRecords()) {
                if (t.getAmount() > 0.0) {
                    ++payments;
                    continue;
                }
                ++reductions;
            }
        }
        footer.setCountReceipts(payments);
        footer.setCountReductions(reductions);
        footer.setCountWhat(sets);
        return this.fileFooter;
    }

    public BgMaxSet createSet(Date setDate, String currency, String clearing, String bankAccount, String bgAccount) {
        BgMaxSet result = new BgMaxSet(setDate, currency, clearing, bankAccount, bgAccount);
        this.records.add(result);
        return result;
    }

    @Override
    public List<BgSet> getRecords() {
        return this.records;
    }

    @Override
    public void writeToFile(File file, Charset cs) throws IOException {
        this.lastFile = file;
        FileOutputStream os = new FileOutputStream(file);
        this.writeToStream(os, cs);
    }

    @Override
    public Date getFileDate() {
        return this.fileHeader.getCreateDate();
    }

    @Override
    public void writeToStream(OutputStream os, Charset cs) throws IOException {
        if (this.fileFooter == null) {
            this.generateFileFooter();
        }
        os.write(this.getFileHeader().toRecordString().getBytes(cs));
        os.write(10);
        if (this.records != null) {
            for (int i = 0; i < this.records.size(); ++i) {
                os.write(this.records.get(i).toRecordString().getBytes(cs));
            }
        }
        os.write(this.getFileFooter().toRecordString().getBytes(cs));
        os.write(10);
        os.close();
    }
}

