/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.notima.bg.BgFile;
import org.notima.bg.BgFooter;
import org.notima.bg.BgHeader;
import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgSet;
import org.notima.bg.BgUtil;
import org.notima.bg.lb.AbstractLbSet;
import org.notima.bg.lb.LbPayment;
import org.notima.bg.lb.LbPaymentRecord;
import org.notima.bg.lb.LbRecordFactory;
import org.notima.bg.lb.LbSet;
import org.notima.bg.lb.LbTk11Header;
import org.notima.bg.lb.LbTk16Record;
import org.notima.bg.lb.LbTk29Record;

public class LbFile
extends BgFile {
    public static final String FILE_PREFIX = "LB_ATER_";
    public static final String FILE_SUFFIX = ".txt";
    private List<BgSet> records = new Vector<BgSet>();

    @Override
    public List<BgSet> getRecords() {
        return this.records;
    }

    public void addSet(AbstractLbSet rec) {
        if (this.records == null) {
            this.records = new Vector<BgSet>();
        }
        this.records.add(rec);
    }

    public void setRecords(Vector<BgSet> records) {
        this.records = records;
    }

    @Override
    public void writeToFile(File file, Charset cs) throws IOException {
        this.lastFile = file;
        FileOutputStream os = new FileOutputStream(file);
        this.writeToStream(os, cs);
    }

    public static void splitToFiles(File src, File dir, Charset cs) throws IOException, BgParseException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src), cs));
        Date fileDate = null;
        int code = 0;
        LbRecordFactory factory = new LbRecordFactory();
        TreeMap<String, StringBuffer> outFiles = new TreeMap<String, StringBuffer>();
        StringBuffer outFile = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            BgRecord rec;
            BgRecord record = factory.parseRecord(line);
            outFile.append(line);
            outFile.append("\r\n");
            code = Integer.parseInt(record.getTransCode());
            if (code == 29) {
                rec = new LbTk29Record();
                ((LbTk29Record)rec).parse(line);
                if (outFiles.containsKey(((LbTk29Record)rec).getSenderAccount())) {
                    reader.close();
                    throw new BgParseException("Sender account " + ((LbTk29Record)rec).getSenderAccount() + " appears more than once in the file");
                }
                outFiles.put(((LbTk29Record)rec).getSenderAccount(), outFile);
                outFile = new StringBuffer();
            }
            if (code != 11 || fileDate != null) continue;
            rec = new LbTk11Header();
            ((LbTk11Header)rec).parse(line);
            fileDate = ((LbTk11Header)rec).getFileDate();
        }
        reader.close();
        for (String key : outFiles.keySet()) {
            File file = new File(dir.getCanonicalPath() + File.separator + FILE_PREFIX + key + "_" + BgUtil.getDateString(fileDate) + FILE_SUFFIX);
            if (file.exists()) {
                throw new BgParseException("File " + file.getCanonicalPath() + " already exists.");
            }
            FileOutputStream writer = new FileOutputStream(file);
            writer.write(((StringBuffer)outFiles.get(key)).toString().getBytes(cs));
            writer.close();
        }
    }

    public Set<String> getBgSenders() {
        TreeSet<String> result = new TreeSet<String>();
        if (this.records == null) {
            return result;
        }
        for (BgSet s : this.records) {
            result.add(s.getSenderBankAccount());
        }
        return result;
    }

    @Override
    public void readFromFile(File file, Charset cs) throws IOException, BgParseException {
        String line;
        this.lastFile = file;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));
        LbSet currentSet = null;
        LbPayment currentPayment = null;
        boolean completePayment = false;
        int code = 0;
        LbRecordFactory factory = new LbRecordFactory();
        while ((line = reader.readLine()) != null) {
            LbPaymentRecord r;
            BgRecord record = factory.parseRecord(line);
            code = Integer.parseInt(record.getTransCode());
            if ((code == 25 || code == 65) && currentPayment != null) {
                currentPayment.addRecord(record);
                continue;
            }
            if (code != 25 && code != 65 && code != 21 && code != 20 && completePayment) {
                currentSet.addTransaction(currentPayment);
                currentPayment = null;
            }
            if (record instanceof BgHeader) {
                currentSet = new LbSet((BgHeader)record, null);
                continue;
            }
            if (record instanceof BgFooter) {
                if (currentSet == null) {
                    reader.close();
                    throw new BgParseException("Footer but no current set. Error in file.", line);
                }
                currentSet.setFooter((BgFooter)record);
                this.records.add(currentSet);
                currentSet = null;
                completePayment = false;
                continue;
            }
            if (currentSet == null) {
                reader.close();
                throw new BgParseException("Footer but no current set. Error in file.", line);
            }
            if (code == 21 || code == 20) {
                currentSet.addCreditRecord(record);
                continue;
            }
            if (currentPayment == null) {
                currentPayment = new LbPayment();
                completePayment = false;
            }
            if (record instanceof LbPaymentRecord && ((r = (LbPaymentRecord)((Object)record)).getPayDate() == null || r instanceof LbTk16Record)) {
                ((LbPaymentRecord)((Object)record)).setPayDate(currentSet.getPayDate());
            }
            currentPayment.addRecord(record);
            if (code != 14 && code != 15 && code != 16 && code != 17 && code != 54) continue;
            completePayment = true;
        }
        reader.close();
    }

    public String toFileString() {
        StringBuffer fileBuf = new StringBuffer();
        if (this.records != null) {
            for (int i = 0; i < this.records.size(); ++i) {
                fileBuf.append(this.records.get(i).toRecordString());
            }
        }
        return fileBuf.toString();
    }

    @Override
    public Date getFileDate() {
        if (this.records != null && this.records.size() > 0) {
            return ((LbSet)this.records.get(0)).getHeader().getCreateDate();
        }
        return null;
    }

    @Override
    public void writeToStream(OutputStream os, Charset cs) throws IOException {
        if (this.records != null) {
            for (int i = 0; i < this.records.size(); ++i) {
                os.write(this.records.get(i).toRecordString().getBytes(cs));
            }
        }
        os.close();
    }
}

