/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import java.util.Date;
import java.util.Vector;
import org.notima.bg.BgRecord;
import org.notima.bg.BgSet;
import org.notima.bg.Transaction;
import org.notima.bg.bgmax.BgMaxReference;
import org.notima.bg.bgmax.BgMaxTk20Record;
import org.notima.bg.bgmax.BgMaxTk21Record;
import org.notima.bg.bgmax.BgMaxTk22Record;
import org.notima.bg.bgmax.BgMaxTk23Record;
import org.notima.bg.bgmax.BgMaxTk25Record;
import org.notima.bg.bgmax.BgMaxTk26Record;
import org.notima.bg.bgmax.BgMaxTk27Record;
import org.notima.bg.bgmax.BgMaxTk28Record;
import org.notima.bg.bgmax.BgMaxTk29Record;

public class BgMaxReceipt
implements Transaction {
    private Vector<BgRecord> records = new Vector();
    private double amount;
    private Date transDate;
    private String senderBg;
    private String name1;
    private String name2;
    private Vector<String> infoRecords = new Vector();
    private String address;
    private String zipCode;
    private String city;
    private String country;
    private String countryCode;
    private String taxId;
    private int reductionType;
    private Vector<BgMaxReference> references = new Vector();
    private String reference;
    private int referenceType;
    private int payChannel;
    private String bgcRef;
    private boolean scannedImage;

    public BgMaxReceipt(Date transDate) {
        this.transDate = transDate;
    }

    @Override
    public void addRecord(BgRecord record) {
        BgRecord r;
        int code = Integer.parseInt(record.getTransCode());
        if (code == 20) {
            r = (BgMaxTk20Record)record;
            this.amount = ((BgMaxTk20Record)r).getAmount();
            this.senderBg = ((BgMaxTk20Record)r).getSenderBg();
            this.reference = ((BgMaxTk20Record)r).getReference();
            this.referenceType = ((BgMaxTk20Record)r).getReferenceType();
            this.payChannel = ((BgMaxTk20Record)r).getPayChannel();
            this.bgcRef = ((BgMaxTk20Record)r).getBgcRef();
            this.scannedImage = ((BgMaxTk20Record)r).hasScannedImage();
            this.references.add(((BgMaxTk20Record)r).getReferenceRecord());
        }
        if (code == 21) {
            r = (BgMaxTk21Record)record;
            this.amount = -((BgMaxTk21Record)r).getAmount();
            this.senderBg = ((BgMaxTk21Record)r).getSenderBg();
            this.reference = ((BgMaxTk21Record)r).getReference();
            this.referenceType = ((BgMaxTk21Record)r).getReferenceType();
            this.payChannel = ((BgMaxTk21Record)r).getPayChannel();
            this.bgcRef = ((BgMaxTk21Record)r).getBgcRef();
            this.scannedImage = ((BgMaxTk21Record)r).hasScannedImage();
            this.reductionType = ((BgMaxTk21Record)r).getReductionType();
            this.references.add(((BgMaxTk21Record)r).getReferenceRecord());
        }
        if (code == 22) {
            r = (BgMaxTk22Record)record;
            this.references.add(((BgMaxTk22Record)r).getReferenceRecord());
        }
        if (code == 23) {
            r = (BgMaxTk23Record)record;
            this.references.add(((BgMaxTk23Record)r).getReferenceRecord());
        }
        if (code == 25) {
            r = (BgMaxTk25Record)record;
            this.infoRecords.add(((BgMaxTk25Record)r).getInfoText());
        }
        if (code == 26) {
            r = (BgMaxTk26Record)record;
            this.name1 = ((BgMaxTk26Record)r).getName1();
            this.name2 = ((BgMaxTk26Record)r).getName2();
        }
        if (code == 27) {
            r = (BgMaxTk27Record)record;
            this.address = ((BgMaxTk27Record)r).getAddress();
            this.zipCode = ((BgMaxTk27Record)r).getZipCode();
        }
        if (code == 28) {
            r = (BgMaxTk28Record)record;
            this.city = ((BgMaxTk28Record)r).getCity();
            this.country = ((BgMaxTk28Record)r).getCountry();
            this.countryCode = ((BgMaxTk28Record)r).getCountryCode();
        }
        if (code == 29) {
            r = (BgMaxTk29Record)record;
            this.taxId = ((BgMaxTk29Record)r).getTaxId();
        }
        this.records.add(record);
    }

    public void createRecord(BgRecord record) {
        BgMaxReference r;
        BgRecord rec;
        BgRecord r2;
        int code = Integer.parseInt(record.getTransCode());
        if (code == 20) {
            r2 = (BgMaxTk20Record)record;
            ((BgMaxTk20Record)r2).setAmount(this.amount);
            ((BgMaxTk20Record)r2).setSenderBg(this.senderBg);
            ((BgMaxTk20Record)r2).setReference(this.reference);
            ((BgMaxTk20Record)r2).setReferenceType(this.referenceType);
            ((BgMaxTk20Record)r2).setPayChannel(this.payChannel);
            ((BgMaxTk20Record)r2).setBgcRef(this.bgcRef);
            ((BgMaxTk20Record)r2).setScannedImage(this.scannedImage);
        }
        if (code == 21) {
            r2 = (BgMaxTk21Record)record;
            ((BgMaxTk21Record)r2).setAmount(-this.amount);
            ((BgMaxTk21Record)r2).setSenderBg(this.senderBg);
            ((BgMaxTk21Record)r2).setReference(this.reference);
            ((BgMaxTk21Record)r2).setReferenceType(this.referenceType);
            ((BgMaxTk21Record)r2).setPayChannel(this.payChannel);
            ((BgMaxTk21Record)r2).setBgcRef(this.bgcRef);
            ((BgMaxTk21Record)r2).setScannedImage(this.scannedImage);
            ((BgMaxTk21Record)r2).setReductionType(this.reductionType);
        }
        if (code == 22) {
            rec = (BgMaxTk22Record)record;
            r = ((BgMaxTk22Record)rec).getReferenceRecord();
            r.setAmount(this.amount);
            r.setSenderBg(this.senderBg);
            r.setReference(this.reference);
            r.setReferenceType(this.referenceType);
            r.setPayChannel(this.payChannel);
            r.setBgcRef(this.bgcRef);
            r.setScannedImage(this.scannedImage);
        }
        if (code == 23) {
            rec = (BgMaxTk23Record)record;
            r = ((BgMaxTk23Record)rec).getReferenceRecord();
            r.setAmount(this.amount);
            r.setSenderBg(this.senderBg);
            r.setReference(this.reference);
            r.setReferenceType(this.referenceType);
            r.setPayChannel(this.payChannel);
            r.setBgcRef(this.bgcRef);
            r.setScannedImage(this.scannedImage);
        }
        if (code == 26) {
            r2 = (BgMaxTk26Record)record;
            ((BgMaxTk26Record)r2).setName1(this.name1);
            ((BgMaxTk26Record)r2).setName2(this.name2);
        }
        if (code == 27) {
            r2 = (BgMaxTk27Record)record;
            ((BgMaxTk27Record)r2).setAddress(this.address);
            ((BgMaxTk27Record)r2).setZipCode(this.zipCode);
        }
        if (code == 28) {
            r2 = (BgMaxTk28Record)record;
            ((BgMaxTk28Record)r2).setCity(this.city);
            ((BgMaxTk28Record)r2).setCountry(this.country);
            ((BgMaxTk28Record)r2).setCountryCode(this.countryCode);
        }
        if (code == 29) {
            r2 = (BgMaxTk29Record)record;
            ((BgMaxTk29Record)r2).setTaxId(this.taxId);
        }
        this.records.add(record);
    }

    @Override
    public double getAmount() {
        return this.amount;
    }

    @Override
    public void setSeqNo(int seqNo) {
        if (this.records != null && this.records.size() > 0) {
            for (int i = 0; i < this.records.size(); ++i) {
                this.records.get(i).setSeqNo(seqNo);
            }
        }
    }

    private void createRecordsFromAttributes() {
        if (this.amount > 0.0) {
            this.createRecord(new BgMaxTk20Record());
        } else {
            this.createRecord(new BgMaxTk21Record());
        }
        if (this.references != null) {
            for (BgMaxReference bgRef : this.references) {
                BgMaxTk22Record r = new BgMaxTk22Record();
                r.setReferenceRecord(bgRef);
                this.createRecord(r);
            }
        }
        if (this.name1 != null || this.name2 != null) {
            this.createRecord(new BgMaxTk26Record());
        }
        if (this.address != null || this.zipCode != null) {
            this.createRecord(new BgMaxTk27Record());
        }
        if (this.city != null || this.country != null || this.countryCode != null) {
            this.createRecord(new BgMaxTk28Record());
        }
        if (this.taxId != null) {
            this.createRecord(new BgMaxTk29Record());
        }
        if (this.infoRecords != null && this.infoRecords.size() > 0) {
            for (String infoStr : this.infoRecords) {
                this.createRecord(new BgMaxTk25Record(infoStr));
            }
        }
    }

    @Override
    public String toRecordString() {
        StringBuffer lines = new StringBuffer();
        if (this.records == null || this.records.size() == 0) {
            this.createRecordsFromAttributes();
        }
        if (this.records != null && this.records.size() > 0) {
            for (int i = 0; i < this.records.size(); ++i) {
                lines.append(this.records.get(i).toRecordString() + "\n");
            }
        }
        return lines.toString();
    }

    @Override
    public Date getTransactionDate() {
        return this.transDate;
    }

    @Override
    public void setTransactionDate(Date d) {
        this.transDate = d;
    }

    public String getSenderBg() {
        return this.senderBg;
    }

    public void setSenderBg(String srcBg) {
        this.senderBg = srcBg;
    }

    public String getName1() {
        return this.name1;
    }

    public void setName1(String name1) {
        this.name1 = name1;
    }

    public String getName2() {
        return this.name2;
    }

    public void setName2(String name2) {
        this.name2 = name2;
    }

    public Vector<String> getInfoRecords() {
        return this.infoRecords;
    }

    public void setInfoRecords(Vector<String> infoRecords) {
        this.infoRecords = infoRecords;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public int getReductionType() {
        return this.reductionType;
    }

    public void setReductionType(int reductionType) {
        this.reductionType = reductionType;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public int getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(int referenceType) {
        this.referenceType = referenceType;
    }

    public int getPayChannel() {
        return this.payChannel;
    }

    public void setPayChannel(int payChannel) {
        this.payChannel = payChannel;
    }

    public String getBgcRef() {
        return this.bgcRef;
    }

    public void setBgcRef(String bgcRef) {
        this.bgcRef = bgcRef;
    }

    public boolean isScannedImage() {
        return this.scannedImage;
    }

    public void setScannedImage(boolean scannedImage) {
        this.scannedImage = scannedImage;
    }

    public String getAllInfo() {
        StringBuffer buf = new StringBuffer();
        Vector<String> info = this.getInfoRecords();
        if (info != null && info.size() > 0) {
            for (String line : info) {
                if (line == null || line.trim().length() <= 0) continue;
                buf.append(line + "\n");
            }
        }
        if (this.getAddress() != null) {
            buf.append(this.getAddress() + "\n");
        }
        if (this.getZipCode() != null) {
            buf.append(this.getZipCode() + " ");
        }
        if (this.getCity() != null) {
            buf.append(this.getCity());
        }
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) == '\n') {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    @Override
    public double getForeignAmount() {
        return 0.0;
    }

    @Override
    public String getForeignCurrency() {
        return null;
    }

    @Override
    public boolean isForeign() {
        return false;
    }

    @Override
    public BgSet getParentSet() {
        return null;
    }

    @Override
    public void setParentSet(BgSet parentSet) {
    }
}

