/*
 * Decompiled with CFR 0.152.
 */
package org.notima.bg.bgmax;

import org.notima.bg.BgParseException;
import org.notima.bg.BgRecord;
import org.notima.bg.BgRecordFactory;
import org.notima.bg.bgmax.BgMaxTk01Header;
import org.notima.bg.bgmax.BgMaxTk05Record;
import org.notima.bg.bgmax.BgMaxTk15Record;
import org.notima.bg.bgmax.BgMaxTk20Record;
import org.notima.bg.bgmax.BgMaxTk21Record;
import org.notima.bg.bgmax.BgMaxTk22Record;
import org.notima.bg.bgmax.BgMaxTk23Record;
import org.notima.bg.bgmax.BgMaxTk25Record;
import org.notima.bg.bgmax.BgMaxTk26Record;
import org.notima.bg.bgmax.BgMaxTk27Record;
import org.notima.bg.bgmax.BgMaxTk28Record;
import org.notima.bg.bgmax.BgMaxTk29Record;
import org.notima.bg.bgmax.BgMaxTk70Footer;

public class BgMaxRecordFactory
implements BgRecordFactory {
    @Override
    public BgRecord parseRecord(String line) throws BgParseException {
        if (line == null || line.trim().length() < 2) {
            return null;
        }
        BgRecord record = null;
        String transCodeStr = line.substring(0, 2);
        int transCode = Integer.parseInt(transCodeStr);
        switch (transCode) {
            case 1: {
                record = new BgMaxTk01Header();
                break;
            }
            case 5: {
                record = new BgMaxTk05Record();
                break;
            }
            case 15: {
                record = new BgMaxTk15Record();
                break;
            }
            case 20: {
                record = new BgMaxTk20Record();
                break;
            }
            case 21: {
                record = new BgMaxTk21Record();
                break;
            }
            case 22: {
                record = new BgMaxTk22Record();
                break;
            }
            case 23: {
                record = new BgMaxTk23Record();
                break;
            }
            case 25: {
                record = new BgMaxTk25Record();
                break;
            }
            case 26: {
                record = new BgMaxTk26Record();
                break;
            }
            case 27: {
                record = new BgMaxTk27Record();
                break;
            }
            case 28: {
                record = new BgMaxTk28Record();
                break;
            }
            case 29: {
                record = new BgMaxTk29Record();
                break;
            }
            case 70: {
                record = new BgMaxTk70Footer();
                break;
            }
            default: {
                throw new BgParseException("Record not valid for this type of file", line);
            }
        }
        record.parse(line);
        return record;
    }
}

